/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.PojoWithSerializeWith;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.MarshallExternalizersTest")
public class MarshallExternalizersTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.globalConfigurationBuilder(), this.configBuilder(), 2);
        this.waitForClusterToForm();
    }

    protected ConfigurationBuilder configBuilder() {
        return MarshallExternalizersTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
    }

    protected GlobalConfigurationBuilder globalConfigurationBuilder() {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return globalBuilder;
    }

    public void testReplicateMarshallableByPojo(Method m) {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(17, TestingUtil.k(m));
        this.doReplicatePojo(m, pojo);
    }

    @Test(dependsOnMethods={"testReplicateMarshallableByPojo"})
    public void testReplicateMarshallableByPojoToNewJoiningNode(Method m) {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(85, TestingUtil.k(m));
        this.doReplicatePojoToNewJoiningNode(m, pojo);
    }

    protected void doReplicatePojo(Method m, Object o) {
        Cache cache1 = this.manager(0).getCache();
        Cache cache2 = this.manager(1).getCache();
        cache1.put((Object)TestingUtil.k(m), o);
        AssertJUnit.assertEquals((Object)o, (Object)cache2.get((Object)TestingUtil.k(m)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReplicatePojoToNewJoiningNode(Method m, Object o) {
        Cache cache1 = this.manager(0).getCache();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(this.globalConfigurationBuilder(), this.configBuilder());
        try {
            Cache cache3 = cm.getCache();
            cache1.put((Object)TestingUtil.k(m), o);
            AssertJUnit.assertEquals((Object)o, (Object)cache3.get((Object)TestingUtil.k(m)));
        }
        finally {
            cm.stop();
        }
    }
}

