/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.management.MBeanServer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="jmx.JmxStatsFunctionalTest")
public class JmxStatsFunctionalTest
extends AbstractInfinispanTest {
    private static final String JMX_DOMAIN = JmxStatsFunctionalTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private final MBeanServer server = this.mBeanServerLookup.getMBeanServer();
    private EmbeddedCacheManager cm;
    private EmbeddedCacheManager cm2;
    private EmbeddedCacheManager cm3;

    @AfterMethod(alwaysRun=true)
    public void destroyCacheManager() {
        TestingUtil.killCacheManagers(this.cm, this.cm2, this.cm3);
        this.cm = null;
        this.cm2 = null;
        this.cm3 = null;
    }

    public void testDefaultDomain() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache.build());
        ConfigurationBuilder remote1 = this.config();
        remote1.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1.build());
        ConfigurationBuilder remote2 = this.config();
        remote2.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC);
        this.cm.defineConfiguration("remote2", remote2.build());
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        this.cm.getCache("remote2");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "RpcManager")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "Statistics")));
        TestingUtil.killCacheManagers(this.cm);
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "RpcManager")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote2(invalidation_async)", "Statistics")));
    }

    public void testDifferentDomain() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
    }

    public void testOnlyGlobalJmxStatsEnabled() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().disable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        ConfigurationBuilder remote1 = this.config();
        remote1.statistics().disable();
        remote1.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1.build());
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheManagerObjectName(jmxDomain)));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "LockManager")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "LockManager")));
    }

    public void testOnlyPerCacheJmxStatsEnabled() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().enable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        ConfigurationBuilder remote1 = this.config();
        remote1.statistics().enable();
        remote1.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.cm.defineConfiguration("remote1", remote1.build());
        this.cm.getCache("local_cache");
        this.cm.getCache("remote1");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheManagerObjectName(jmxDomain)));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "remote1(repl_sync)", "RpcManager")));
    }

    public void testMultipleManagersOnSameServerFails(Method method) {
        String jmxDomain = JMX_DOMAIN + "_" + method.getName();
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, jmxDomain, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().enable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        GlobalConfigurationBuilder globalConfiguration2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration2, jmxDomain, this.mBeanServerLookup);
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, JmxDomainConflictException.class, () -> TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration2, new ConfigurationBuilder()));
    }

    public void testMultipleManagersOnSameServerWithCloneFails() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().enable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        GlobalConfigurationBuilder globalConfiguration2 = new GlobalConfigurationBuilder();
        globalConfiguration2.read(globalConfiguration.build());
        globalConfiguration2.transport().defaultTransport();
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, JmxDomainConflictException.class, () -> TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration2, new ConfigurationBuilder()));
    }

    public void testMultipleManagersOnSameServer() {
        String jmxDomain = JMX_DOMAIN;
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, jmxDomain, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().enable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        String jmxDomain2 = JMX_DOMAIN + "2";
        GlobalConfigurationBuilder globalConfiguration2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration2, jmxDomain2, this.mBeanServerLookup);
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration2, new ConfigurationBuilder());
        ConfigurationBuilder localCache2 = this.config();
        localCache2.statistics().enable();
        this.cm2.defineConfiguration("local_cache", localCache.build());
        this.cm2.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "local_cache(local)", "Statistics")));
        String jmxDomain3 = JMX_DOMAIN + "3";
        GlobalConfigurationBuilder globalConfiguration3 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration3, jmxDomain3, this.mBeanServerLookup);
        this.cm3 = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration3, new ConfigurationBuilder());
        ConfigurationBuilder localCache3 = this.config();
        localCache3.statistics().enable();
        this.cm3.defineConfiguration("local_cache", localCache.build());
        this.cm3.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain3, "local_cache(local)", "Statistics")));
    }

    public void testUnregisterJmxInfoOnStop() {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        localCache.statistics().enable();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        TestingUtil.killCacheManagers(this.cm);
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertFalse((boolean)TestingUtil.existsDomain(this.server, jmxDomain));
    }

    public void testCorrectUnregistering() {
        AssertJUnit.assertFalse((boolean)TestingUtil.existsDomain(this.server, "infinispan"));
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration, new ConfigurationBuilder());
        ConfigurationBuilder localCache = this.config();
        this.cm.defineConfiguration("local_cache", localCache.build());
        this.cm.getCache("local_cache");
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Cache")));
        GlobalConfigurationBuilder globalConfiguration2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration2, JMX_DOMAIN + "2", this.mBeanServerLookup);
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration2, new ConfigurationBuilder());
        ConfigurationBuilder remoteCache = new ConfigurationBuilder();
        remoteCache.statistics().enable();
        remoteCache.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.cm2.defineConfiguration("remote_cache", remoteCache.build());
        this.cm2.getCache("remote_cache");
        String jmxDomain2 = this.cm2.getCacheManagerConfiguration().jmx().domain();
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Cache")));
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
        this.cm2.stop();
        AssertJUnit.assertTrue((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "CacheComponent")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
        this.cm.stop();
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain, "local_cache(local)", "Statistics")));
        AssertJUnit.assertFalse((boolean)this.server.isRegistered(TestingUtil.getCacheObjectName(jmxDomain2, "remote_cache(repl_sync)", "Statistics")));
    }

    public void testStopUnstartedCacheManager() {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createCacheManager(globalConfiguration, new ConfigurationBuilder());
        this.cm.stop();
    }

    public void testConfigurationProperties() throws Exception {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfiguration.transport().siteId("TESTVALUE1");
        globalConfiguration.transport().rackId("TESTVALUE2");
        globalConfiguration.transport().machineId("TESTVALUE3");
        TestCacheManagerFactory.configureJmx(globalConfiguration, JMX_DOMAIN, this.mBeanServerLookup);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(globalConfiguration, new ConfigurationBuilder());
        String jmxDomain = this.cm.getCacheManagerConfiguration().jmx().domain();
        ConfigurationBuilder localCache = this.config();
        localCache.memory().storageType(StorageType.BINARY);
        this.cm.defineConfiguration("local_cache1", localCache.build());
        localCache.memory().storageType(StorageType.OBJECT);
        this.cm.defineConfiguration("local_cache2", localCache.build());
        this.cm.getCache("local_cache1");
        this.cm.getCache("local_cache2");
        Properties props1 = (Properties)this.server.getAttribute(TestingUtil.getCacheObjectName(jmxDomain, "local_cache1(local)", "Cache"), "configurationAsProperties");
        Properties props2 = (Properties)this.server.getAttribute(TestingUtil.getCacheObjectName(jmxDomain, "local_cache2(local)", "Cache"), "configurationAsProperties");
        Properties propsGlobal = (Properties)this.server.getAttribute(TestingUtil.getCacheManagerObjectName(jmxDomain), "globalConfigurationAsProperties");
        assert ("BINARY".equals(props1.getProperty("memory.storage")));
        assert ("OBJECT".equals(props2.getProperty("memory.storage")));
        log.tracef("propsGlobal=%s", (Object)propsGlobal);
        assert ("TESTVALUE1".equals(propsGlobal.getProperty("transport.siteId")));
        assert ("TESTVALUE2".equals(propsGlobal.getProperty("transport.rackId")));
        assert ("TESTVALUE3".equals(propsGlobal.getProperty("transport.machineId")));
    }

    private ConfigurationBuilder config() {
        ConfigurationBuilder configuration = new ConfigurationBuilder();
        configuration.clustering().stateTransfer().fetchInMemoryState(false).statistics().enable();
        return configuration;
    }
}

