/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.interceptors.distribution.L1WriteSynchronizer;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="interceptors.distribution.L1WriteSynchronizerTest")
public class L1WriteSynchronizerTest
extends AbstractInfinispanTest {
    private L1WriteSynchronizer sync;
    private InternalDataContainer dc;
    private StateTransferLock stl;
    private ClusteringDependentLogic cdl;
    private final long l1Timeout = 1000L;

    @BeforeMethod
    public void beforeMethod() {
        this.dc = (InternalDataContainer)Mockito.mock(InternalDataContainer.class);
        this.stl = (StateTransferLock)Mockito.mock(StateTransferLock.class);
        this.cdl = (ClusteringDependentLogic)Mockito.mock(ClusteringDependentLogic.class);
        Mockito.when((Object)this.cdl.getCacheTopology()).thenReturn((Object)((LocalizedCacheTopology)Mockito.mock(LocalizedCacheTopology.class)));
        this.sync = new L1WriteSynchronizer(this.dc, 1000L, this.stl, this.cdl);
    }

    @Test
    public void testNullICEProvided() throws ExecutionException, InterruptedException {
        this.sync.runL1UpdateIfPossible(null);
        AssertJUnit.assertNull((Object)this.sync.get());
    }

    @Test
    public void testNullICEProvidedWait() throws ExecutionException, InterruptedException, TimeoutException {
        this.sync.runL1UpdateIfPossible(null);
        AssertJUnit.assertNull((Object)this.sync.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testGetReturnValueWait() throws InterruptedException, ExecutionException, TimeoutException {
        Object value = new Object();
        ImmortalCacheEntry ice = new ImmortalCacheEntry(value, value);
        this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        AssertJUnit.assertEquals((Object)ice, (Object)this.sync.get());
    }

    @Test
    public void testGetReturnValueTimeWait() throws InterruptedException, ExecutionException, TimeoutException {
        Object value = new Object();
        ImmortalCacheEntry ice = new ImmortalCacheEntry(value, value);
        this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        AssertJUnit.assertEquals((Object)ice, (Object)this.sync.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testExceptionWait() throws InterruptedException {
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        this.sync.retrievalEncounteredException(t);
        try {
            this.sync.get();
        }
        catch (ExecutionException e) {
            AssertJUnit.assertEquals((Object)t, (Object)e.getCause());
        }
    }

    @Test
    public void testExceptionTimeWait() throws InterruptedException, TimeoutException {
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        this.sync.retrievalEncounteredException(t);
        try {
            this.sync.get(1L, TimeUnit.SECONDS);
            AssertJUnit.fail((String)"Should have thrown an execution exception");
        }
        catch (ExecutionException e) {
            AssertJUnit.assertEquals((Object)t, (Object)e.getCause());
        }
    }

    @Test
    public void testSpawnedThreadBlockingValue() throws InterruptedException, ExecutionException, TimeoutException {
        Object value = new Object();
        Future<Object> future = this.fork(() -> this.sync.get());
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ImmortalCacheEntry ice = new ImmortalCacheEntry(value, value);
        this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        AssertJUnit.assertEquals((Object)ice, (Object)future.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testSpawnedThreadBlockingValueTimeWait() throws InterruptedException, ExecutionException, TimeoutException {
        Object value = new Object();
        Future<Object> future = this.fork(() -> this.sync.get(5L, TimeUnit.SECONDS));
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ImmortalCacheEntry ice = new ImmortalCacheEntry(value, value);
        this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        AssertJUnit.assertEquals((Object)ice, (Object)future.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testSpawnedThreadBlockingNullValue() throws InterruptedException, ExecutionException, TimeoutException {
        Future<Object> future = this.fork(() -> this.sync.get());
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.sync.runL1UpdateIfPossible(null);
        AssertJUnit.assertNull((Object)future.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testSpawnedThreadBlockingNullValueTimeWait() throws InterruptedException, ExecutionException, TimeoutException {
        Future<Object> future = this.fork(() -> this.sync.get(5L, TimeUnit.SECONDS));
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.sync.runL1UpdateIfPossible(null);
        AssertJUnit.assertNull((Object)future.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testSpawnedThreadBlockingException() throws InterruptedException, ExecutionException, TimeoutException {
        Exception t = new Exception();
        Future<Object> future = this.fork(() -> this.sync.get());
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.sync.retrievalEncounteredException((Throwable)t);
        try {
            this.sync.get(1L, TimeUnit.SECONDS);
            AssertJUnit.fail((String)"Should have thrown an execution exception");
        }
        catch (ExecutionException e) {
            AssertJUnit.assertEquals((Object)t, (Object)e.getCause());
        }
    }

    @Test
    public void testSpawnedThreadBlockingExceptionTimeWait() throws InterruptedException, ExecutionException, TimeoutException {
        Exception t = new Exception();
        Future<Object> future = this.fork(() -> this.sync.get(5L, TimeUnit.SECONDS));
        try {
            future.get(50L, TimeUnit.MILLISECONDS);
            AssertJUnit.fail((String)"Should have thrown a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.sync.retrievalEncounteredException((Throwable)t);
        try {
            this.sync.get(1L, TimeUnit.SECONDS);
            AssertJUnit.fail((String)"Should have thrown an execution exception");
        }
        catch (ExecutionException e) {
            AssertJUnit.assertEquals((Object)t, (Object)e.getCause());
        }
    }

    @Test
    public void testWriteCancelled() {
        AssertJUnit.assertTrue((boolean)this.sync.trySkipL1Update());
        Object keyValue = new Object();
        ImmortalCacheEntry ice = new ImmortalCacheEntry(keyValue, keyValue);
        this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        ((InternalDataContainer)Mockito.verify((Object)this.dc, (VerificationMode)Mockito.never())).put(Mockito.any(), Mockito.any(), (Metadata)Mockito.any(Metadata.class));
    }

    @Test
    public void testWriteCannotCancel() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        CyclicBarrier barrier = new CyclicBarrier(2);
        ((StateTransferLock)Mockito.doAnswer(i -> {
            barrier.await();
            return null;
        }).when((Object)this.stl)).acquireSharedTopologyLock();
        Future<Void> future = this.fork(() -> {
            Object keyValue = new Object();
            ImmortalCacheEntry ice = new ImmortalCacheEntry(keyValue, keyValue);
            this.sync.runL1UpdateIfPossible((InternalCacheEntry)ice);
        });
        barrier.await(1L, TimeUnit.SECONDS);
        AssertJUnit.assertFalse((boolean)this.sync.trySkipL1Update());
        future.get(1L, TimeUnit.SECONDS);
        ((InternalDataContainer)Mockito.verify((Object)this.dc)).put(Mockito.any(), Mockito.any(), (Metadata)Mockito.any(Metadata.class));
    }

    @Test
    public void testDCUpdatedHigherICELifespan() {
        this.verifyDCUpdate(Long.MAX_VALUE, false);
    }

    @Test
    public void testDCUpdatedLowerICELifespan() {
        this.verifyDCUpdate(50L, true);
    }

    private void verifyDCUpdate(long iceLifespan, boolean shouldBeIceLifespan) {
        Object value = new Object();
        Object key = new Object();
        InternalCacheEntry ice = (InternalCacheEntry)Mockito.when((Object)((InternalCacheEntry)Mockito.mock(InternalCacheEntry.class, (Answer)Mockito.RETURNS_DEEP_STUBS)).getValue()).thenReturn(value).getMock();
        Mockito.when((Object)ice.getKey()).thenReturn(key);
        Mockito.when((Object)ice.getLifespan()).thenReturn((Object)iceLifespan);
        this.sync.runL1UpdateIfPossible(ice);
        ((InternalDataContainer)Mockito.verify((Object)this.dc)).put(Mockito.eq((Object)key), Mockito.eq((Object)value), (Metadata)Mockito.any(Metadata.class));
        Metadata.Builder verifier = (Metadata.Builder)Mockito.verify((Object)ice.getMetadata().builder());
        verifier.lifespan(shouldBeIceLifespan ? iceLifespan : 1000L);
        verifier.maxIdle(-1L);
    }
}

