/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.EnumSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.ClusterHealthImpl;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="health.impl.ClusterHealthImplTest", groups={"functional"})
public class ClusterHealthImplTest
extends AbstractInfinispanTest {
    private static final String INTERNAL_CACHE_NAME = "internal_cache";
    private static final String CACHE_NAME = "test_cache";
    private EmbeddedCacheManager localCacheManager;
    private EmbeddedCacheManager cacheManager;
    private ClusterHealth clusterHealth;
    private InternalCacheRegistry internalCacheRegistry;

    @BeforeClass
    private void init() {
        this.localCacheManager = TestCacheManagerFactory.createCacheManager();
        this.cacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        this.internalCacheRegistry = TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, InternalCacheRegistry.class);
        this.clusterHealth = new ClusterHealthImpl(this.cacheManager, this.internalCacheRegistry);
    }

    @BeforeMethod
    private void configureBeforeMethod() {
        this.internalCacheRegistry.registerInternalCache(INTERNAL_CACHE_NAME, new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_ASYNC).build(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
        this.cacheManager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().build());
    }

    @AfterMethod(alwaysRun=true)
    private void cleanAfterMethod() {
        if (this.cacheManager != null) {
            this.cacheManager.administration().removeCache(CACHE_NAME);
            this.cacheManager.undefineConfiguration(CACHE_NAME);
            this.cacheManager.administration().removeCache(INTERNAL_CACHE_NAME);
        }
        if (this.internalCacheRegistry != null) {
            this.internalCacheRegistry.unregisterInternalCache(INTERNAL_CACHE_NAME);
        }
    }

    @AfterClass(alwaysRun=true)
    private void cleanUp() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
            this.cacheManager = null;
        }
    }

    public void testGetClusterName() {
        AssertJUnit.assertEquals((String)this.cacheManager.getClusterName(), (String)this.clusterHealth.getClusterName());
    }

    public void testCallingGetHealthStatusDoesNotCreateAnyCache() {
        this.clusterHealth.getHealthStatus();
        AssertJUnit.assertFalse((boolean)this.cacheManager.cacheExists(CACHE_NAME));
        AssertJUnit.assertFalse((boolean)this.cacheManager.cacheExists(INTERNAL_CACHE_NAME));
    }

    public void testHealthyStatusWithoutAnyUserCreatedCache() {
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testHealthyStatusWhenUserCacheIsHealthy() {
        this.cacheManager.getCache(CACHE_NAME, true);
        HealthStatus healthStatus = this.clusterHealth.getHealthStatus();
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)healthStatus);
    }

    public void testUnhealthyStatusWhenUserCacheIsStopped() {
        Cache testCache = this.cacheManager.getCache(CACHE_NAME, true);
        testCache.stop();
        HealthStatus healthStatus = this.clusterHealth.getHealthStatus();
        AssertJUnit.assertEquals((Object)HealthStatus.FAILED, (Object)healthStatus);
        this.cacheManager.administration().removeCache(CACHE_NAME);
        healthStatus = this.clusterHealth.getHealthStatus();
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)healthStatus);
    }

    public void testRebalancingStatusWhenUserCacheIsRebalancing() {
        this.mockRehashInProgress(CACHE_NAME);
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl(this.cacheManager, this.internalCacheRegistry);
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY_REBALANCING, (Object)clusterHealth.getHealthStatus());
    }

    public void testHealthyStatusForInternalCaches() {
        this.cacheManager.getCache(INTERNAL_CACHE_NAME, true);
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testUnhealthyStatusWhenInternalCacheIsStopped() {
        Cache internalCache = this.cacheManager.getCache(INTERNAL_CACHE_NAME, true);
        internalCache.stop();
        AssertJUnit.assertEquals((Object)HealthStatus.FAILED, (Object)this.clusterHealth.getHealthStatus());
    }

    public void testRebalancingStatusWhenInternalCacheIsRebalancing() {
        this.mockRehashInProgress(INTERNAL_CACHE_NAME);
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl(this.cacheManager, this.internalCacheRegistry);
        AssertJUnit.assertEquals((Object)HealthStatus.HEALTHY_REBALANCING, (Object)clusterHealth.getHealthStatus());
    }

    public void testGetNodeNames() {
        AssertJUnit.assertEquals((String)this.cacheManager.getAddress().toString(), (String)((String)this.clusterHealth.getNodeNames().get(0)));
    }

    public void testGetNumberOfNodes() {
        AssertJUnit.assertEquals((int)1, (int)this.clusterHealth.getNumberOfNodes());
    }

    public void testGetNumberOfNodesWithNullTransport() {
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl(this.localCacheManager, this.internalCacheRegistry);
        AssertJUnit.assertEquals((int)0, (int)clusterHealth.getNumberOfNodes());
    }

    public void testGetNodeNamesWithNullTransport() {
        ClusterHealthImpl clusterHealth = new ClusterHealthImpl(this.localCacheManager, this.internalCacheRegistry);
        AssertJUnit.assertTrue((boolean)clusterHealth.getNodeNames().isEmpty());
    }

    private void mockRehashInProgress(String cacheName) {
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.isRehashInProgress()).thenReturn((Object)true);
        TestingUtil.replaceComponent(this.cacheManager.getCache(cacheName), DistributionManager.class, mockDistributionManager, false);
    }
}

