/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="health.impl.CacheHealthImplTest", groups={"functional"})
public class CacheHealthImplTest {
    @Test
    public void testHealthyStatus() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        DistributionManager distributionManagerMock = (DistributionManager)Mockito.mock(DistributionManager.class);
        ((DistributionManager)Mockito.doReturn((Object)false).when((Object)distributionManagerMock)).isRehashInProgress();
        ((ComponentRegistry)Mockito.doReturn((Object)distributionManagerMock).when((Object)componentRegistryMock)).getDistributionManager();
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)componentRegistryMock)).getStatus();
        PartitionHandlingManager partitionHandlingManagerMock = (PartitionHandlingManager)Mockito.mock(PartitionHandlingManager.class);
        ((PartitionHandlingManager)Mockito.doReturn((Object)AvailabilityMode.AVAILABLE).when((Object)partitionHandlingManagerMock)).getAvailabilityMode();
        ((ComponentRegistry)Mockito.doReturn((Object)partitionHandlingManagerMock).when((Object)componentRegistryMock)).getComponent((Class)ArgumentMatchers.eq(PartitionHandlingManager.class));
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.HEALTHY);
    }

    @Test
    public void testUnhealthyStatusWithFailedComponent() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.FAILED).when((Object)componentRegistryMock)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithTerminatedComponent() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.TERMINATED).when((Object)componentRegistryMock)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithStoppingComponent() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.STOPPING).when((Object)componentRegistryMock)).getStatus();
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testUnhealthyStatusWithDegradedPartition() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)componentRegistryMock)).getStatus();
        PartitionHandlingManager partitionHandlingManagerMock = (PartitionHandlingManager)Mockito.mock(PartitionHandlingManager.class);
        ((PartitionHandlingManager)Mockito.doReturn((Object)AvailabilityMode.DEGRADED_MODE).when((Object)partitionHandlingManagerMock)).getAvailabilityMode();
        ((ComponentRegistry)Mockito.doReturn((Object)partitionHandlingManagerMock).when((Object)componentRegistryMock)).getComponent((Class)ArgumentMatchers.eq(PartitionHandlingManager.class));
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.DEGRADED);
    }

    @Test
    public void testRebalancingStatusOnRebalance() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        DistributionManager distributionManagerMock = (DistributionManager)Mockito.mock(DistributionManager.class);
        ((DistributionManager)Mockito.doReturn((Object)true).when((Object)distributionManagerMock)).isRehashInProgress();
        ((ComponentRegistry)Mockito.doReturn((Object)distributionManagerMock).when((Object)componentRegistryMock)).getDistributionManager();
        ((ComponentRegistry)Mockito.doReturn((Object)ComponentStatus.RUNNING).when((Object)componentRegistryMock)).getStatus();
        PartitionHandlingManager partitionHandlingManagerMock = (PartitionHandlingManager)Mockito.mock(PartitionHandlingManager.class);
        ((PartitionHandlingManager)Mockito.doReturn((Object)AvailabilityMode.AVAILABLE).when((Object)partitionHandlingManagerMock)).getAvailabilityMode();
        ((ComponentRegistry)Mockito.doReturn((Object)partitionHandlingManagerMock).when((Object)componentRegistryMock)).getComponent((Class)ArgumentMatchers.eq(PartitionHandlingManager.class));
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        HealthStatus status = cacheHealth.getStatus();
        Assert.assertEquals((Object)status, (Object)HealthStatus.HEALTHY_REBALANCING);
    }

    @Test
    public void testReturningName() {
        ComponentRegistry componentRegistryMock = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        ((ComponentRegistry)Mockito.doReturn((Object)"test").when((Object)componentRegistryMock)).getCacheName();
        CacheHealthImpl cacheHealth = new CacheHealthImpl(componentRegistryMock);
        String name = cacheHealth.getCacheName();
        Assert.assertEquals((String)name, (String)"test");
    }
}

