/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.interceptors.impl.TransactionalExceptionEvictionInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.ExceptionEvictionTest")
public class ExceptionEvictionTest
extends MultipleCacheManagersTest {
    private static final int SIZE = 10;
    public static final int IMMORTAL_ENTRY_SIZE = 104;
    public static final int OPTIMISTIC_TX_OVERHEAD = 48;
    public static final int MORTAL_ENTRY_OVERHEAD = 16;
    private int nodeCount;
    private ConfigurationBuilder configurationBuilder;
    protected ControlledTimeService timeService = new ControlledTimeService();

    public ExceptionEvictionTest nodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    @Override
    public ExceptionEvictionTest cacheMode(CacheMode cacheMode) {
        super.cacheMode(cacheMode);
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.BINARY).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.BINARY).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OBJECT).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OBJECT).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.OPTIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OFF_HEAP).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.BINARY).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.BINARY).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.BINARY).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.LOCAL).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(1).storageType(StorageType.OBJECT).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OBJECT).cacheMode(CacheMode.DIST_SYNC).lockingMode(LockingMode.PESSIMISTIC), new ExceptionEvictionTest().nodeCount(3).storageType(StorageType.OBJECT).cacheMode(CacheMode.REPL_SYNC).lockingMode(LockingMode.PESSIMISTIC)};
    }

    @Override
    protected String[] parameterNames() {
        return ExceptionEvictionTest.concat(super.parameterNames(), "nodeCount");
    }

    @Override
    protected Object[] parameterValues() {
        return ExceptionEvictionTest.concat(super.parameterValues(), this.nodeCount);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        int i;
        this.configurationBuilder = new ConfigurationBuilder();
        MemoryConfigurationBuilder memoryConfigurationBuilder = this.configurationBuilder.memory();
        memoryConfigurationBuilder.storageType(this.storageType);
        memoryConfigurationBuilder.evictionStrategy(EvictionStrategy.EXCEPTION);
        switch (this.storageType) {
            case OBJECT: {
                memoryConfigurationBuilder.size(10L);
                break;
            }
            case BINARY: {
                memoryConfigurationBuilder.evictionType(EvictionType.MEMORY).size(this.convertAmountForStorage(10L) + 16L);
                break;
            }
            case OFF_HEAP: {
                memoryConfigurationBuilder.evictionType(EvictionType.MEMORY).size(24L + this.convertAmountForStorage(10L) + UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)2048L));
            }
        }
        this.configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(this.lockingMode);
        this.configurationBuilder.clustering().cacheMode(this.cacheMode).hash().numOwners(this.nodeCount);
        for (i = 0; i < this.nodeCount; ++i) {
            this.addClusterEnabledCacheManager(this.configurationBuilder);
        }
        for (i = 0; i < this.nodeCount; ++i) {
            EmbeddedCacheManager manager = this.manager(i);
            TestingUtil.replaceComponent((CacheContainer)manager, TimeService.class, this.timeService, true);
        }
        this.waitForClusterToForm();
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        super.clearContent();
        for (Cache cache : this.caches()) {
            cache.clear();
        }
        for (Cache cache : this.caches()) {
            this.eventuallyEquals(0L, () -> TestingUtil.extractComponent(cache, TransactionalExceptionEvictionInterceptor.class).pendingTransactionCount());
        }
    }

    Throwable getMostNestedSuppressedThrowable(Throwable t) {
        Throwable nested = this.getNestedThrowable(t);
        Throwable[] suppressedNested = nested.getSuppressed();
        if (suppressedNested.length > 0) {
            nested = this.getNestedThrowable(suppressedNested[0]);
        }
        return nested;
    }

    Throwable getNestedThrowable(Throwable t) {
        Throwable cause;
        while ((cause = t.getCause()) != null) {
            t = cause;
        }
        return t;
    }

    long convertAmountForStorage(long expected) {
        boolean optimistic = this.lockingMode == LockingMode.OPTIMISTIC;
        switch (this.storageType) {
            case OBJECT: {
                return expected;
            }
            case BINARY: {
                return expected * (long)(optimistic ? 152 : 104);
            }
            case OFF_HEAP: {
                return expected * (optimistic ? UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)51L) : UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)33L));
            }
        }
        throw new IllegalStateException("Unconfigured storage type: " + String.valueOf(this.storageType));
    }

    void assertInterceptorCount() {
        for (Cache cache : this.caches()) {
            ExceptionEvictionTest.eventually(() -> {
                boolean equal;
                long expectedCount = this.convertAmountForStorage(cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
                TransactionalExceptionEvictionInterceptor interceptor = TestingUtil.extractComponent(cache, TransactionalExceptionEvictionInterceptor.class);
                long size = interceptor.getCurrentSize();
                log.debugf("Exception eviction size for cache: %s is: %d", (Object)cache.getCacheManager().getAddress(), (Object)size);
                boolean bl = equal = (expectedCount += interceptor.getMinSize()) == size;
                if (!equal) {
                    log.fatal((Object)("Expected: " + expectedCount + " but was: " + size + " for: " + String.valueOf(cache.getCacheManager().getAddress())));
                }
                return equal;
            });
        }
    }

    public void testExceptionOnInsert() {
        for (int i = 0; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        try {
            this.cache(0).put((Object)-1, (Object)-1);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable t) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
        }
    }

    public void testExceptionOnInsertFunctional() {
        for (int i = 0; i < 10; ++i) {
            this.cache(0).computeIfAbsent((Object)i, (SerializableFunction & Serializable)k -> 10);
        }
        try {
            this.cache(0).computeIfAbsent((Object)-1, (SerializableFunction & Serializable)k -> 10);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable t) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
        }
    }

    public void testExceptionOnInsertWithRemove() {
        for (int i = 0; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        this.cache(0).remove((Object)0);
        this.cache(0).put((Object)-128, (Object)-128);
        try {
            this.cache(0).put((Object)-1, (Object)-1);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable t) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
        }
    }

    public void testNoExceptionWhenReplacingEntry() {
        for (int i = 0; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        this.cache(0).put((Object)0, (Object)0);
    }

    public void testNoExceptionAfterRollback() throws SystemException, NotSupportedException {
        for (int i = 1; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        this.assertInterceptorCount();
        TransactionManager tm = this.cache(0).getAdvancedCache().getTransactionManager();
        tm.begin();
        this.cache(0).put((Object)0, (Object)0);
        tm.rollback();
        this.assertInterceptorCount();
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)0));
        this.cache(0).put((Object)11, (Object)11);
        this.assertInterceptorCount();
        try {
            this.cache(0).put((Object)-1, (Object)-1);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable t) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
        }
        this.assertInterceptorCount();
    }

    public void testRollbackPreventedException() throws SystemException, NotSupportedException {
        for (int i = 0; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        TransactionManager tm = this.cache(0).getAdvancedCache().getTransactionManager();
        tm.begin();
        try {
            this.cache(0).put((Object)11, (Object)11);
        }
        finally {
            tm.rollback();
        }
        AssertJUnit.assertNull((Object)this.cache(0).get((Object)11));
    }

    public void testExceptionWithCommitMultipleEntries() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException {
        for (int i = 1; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        TransactionManager tm = this.cache(0).getAdvancedCache().getTransactionManager();
        tm.begin();
        try {
            this.cache(0).put((Object)0, (Object)0);
            this.cache(0).put((Object)11, (Object)11);
        }
        catch (Throwable t) {
            tm.setRollbackOnly();
            throw t;
        }
        finally {
            if (tm.getStatus() == 0) {
                try {
                    tm.commit();
                    AssertJUnit.fail((String)"Should have thrown an exception!");
                }
                catch (RollbackException e) {
                    Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(e));
                }
            } else {
                tm.rollback();
                AssertJUnit.fail((String)"Transaction was no longer active!");
            }
        }
    }

    @DataProvider(name="expiration")
    public Object[][] expirationParams() {
        return new Object[][]{{true, true}, {true, false}, {false, true}, {false, false}};
    }

    @Test(dataProvider="expiration")
    public void testEntryExpirationOverwritten(boolean maxIdle, boolean readInTx) throws Exception {
        Integer expiringKey = 0;
        if (maxIdle) {
            this.cache(0).put((Object)expiringKey, (Object)0, -1L, null, 10L, TimeUnit.SECONDS);
        } else {
            this.cache(0).put((Object)expiringKey, (Object)0, 10L, TimeUnit.SECONDS);
        }
        for (int i = 1; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        this.timeService.advance(TimeUnit.SECONDS.toMillis(11L));
        if (readInTx) {
            TestingUtil.withTx(this.cache(0).getAdvancedCache().getTransactionManager(), () -> {
                AssertJUnit.assertNull((Object)this.cache(0).get(expiringKey));
                return null;
            });
        } else {
            AssertJUnit.assertNull((Object)this.cache(0).get((Object)expiringKey));
        }
        this.cache(0).put((Object)expiringKey, (Object)0);
        try {
            this.cache(0).put((Object)-1, (Object)-1);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable t) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
        }
    }

    @Test(dataProvider="expiration")
    public void testEntryExpiration(boolean maxIdle, boolean readInTx) throws Exception {
        Integer expiringKey = 0;
        if (maxIdle) {
            this.cache(0).put((Object)expiringKey, (Object)0, -1L, null, 10L, TimeUnit.SECONDS);
        } else {
            this.cache(0).put((Object)expiringKey, (Object)0, 10L, TimeUnit.SECONDS);
        }
        for (int i = 1; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        this.timeService.advance(TimeUnit.SECONDS.toMillis(11L));
        if (readInTx) {
            TestingUtil.withTx(this.cache(0).getAdvancedCache().getTransactionManager(), () -> {
                AssertJUnit.assertNull((Object)this.cache(0).get(expiringKey));
                return null;
            });
        } else {
            AssertJUnit.assertNull((Object)this.cache(0).get((Object)expiringKey));
        }
        for (Cache cache : this.caches()) {
            ExpirationManager expirationManager = cache.getAdvancedCache().getExpirationManager();
            expirationManager.processExpiration();
        }
        Object storageKey = this.cache(0).getAdvancedCache().getKeyDataConversion().toStorage((Object)expiringKey);
        for (Cache cache : this.caches()) {
            ExceptionEvictionTest.eventually(() -> cache.getAdvancedCache().getDataContainer().peek(storageKey) == null);
        }
        this.cache(0).put((Object)-128, (Object)-128);
        try {
            this.cache(0).put((Object)-1, (Object)-1);
            AssertJUnit.fail((String)"Should have thrown an exception!");
        }
        catch (Throwable throwable) {
            Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(throwable));
        }
    }

    public void testDistributedOverflowOnPrimary() {
        this.testDistributedOverflow(true);
    }

    public void testDistributedOverflowOnBackup() {
        this.testDistributedOverflow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testDistributedOverflow(boolean onPrimary) {
        if (!this.cacheMode.isDistributed() || this.nodeCount < 3) {
            return;
        }
        this.addClusterEnabledCacheManager(this.configurationBuilder);
        this.addClusterEnabledCacheManager(this.configurationBuilder);
        try {
            Address targetNode;
            int minKey;
            this.waitForClusterToForm();
            LocalizedCacheTopology lct = this.cache(0).getAdvancedCache().getDistributionManager().getCacheTopology();
            DataConversion dc = this.cache(0).getAdvancedCache().getKeyDataConversion();
            int nextKey = minKey = 1;
            Iterator owners = lct.getWriteOwners(dc.toStorage((Object)nextKey)).iterator();
            if (onPrimary) {
                targetNode = (Address)owners.next();
            } else {
                owners.next();
                targetNode = (Address)owners.next();
            }
            this.cache(0).put((Object)nextKey, (Object)nextKey);
            for (int i = 0; i < 9; ++i) {
                nextKey = this.getNextIntWithOwners(nextKey, lct, dc, targetNode, null);
                this.cache(0).put((Object)nextKey, (Object)nextKey);
            }
            this.assertInterceptorCount();
            for (Cache cache : this.caches()) {
                if (!targetNode.equals((Object)cache.getCacheManager().getAddress())) continue;
                AssertJUnit.assertEquals((int)10, (int)cache.getAdvancedCache().getDataContainer().size());
                break;
            }
            nextKey = this.getNextIntWithOwners(nextKey, lct, dc, targetNode, onPrimary);
            try {
                this.cache(0).put((Object)nextKey, (Object)nextKey);
                AssertJUnit.fail((String)"Should have thrown an exception!");
            }
            catch (Throwable t) {
                Exceptions.assertException(ContainerFullException.class, (Throwable)this.getMostNestedSuppressedThrowable(t));
            }
            this.assertInterceptorCount();
        }
        finally {
            this.killMember(3);
            this.killMember(3);
        }
    }

    int getNextIntWithOwners(int exclusiveValue, LocalizedCacheTopology lct, DataConversion dc, Address ownerAddress, Boolean primary) {
        DistributionInfo di;
        if (exclusiveValue < -128) {
            throw new IllegalArgumentException("We cannot support integers smaller than -128 as they will throw off BINARY sizing");
        }
        int valueToTest = exclusiveValue;
        do {
            if (++valueToTest >= 128) {
                throw new IllegalStateException("Could not generate a key with the given owners");
            }
            Object keyAsStorage = dc.toStorage((Object)valueToTest);
            di = lct.getDistribution(keyAsStorage);
        } while (!(primary == null ? di.writeOwners().contains(ownerAddress) : (primary == Boolean.TRUE ? di.primary().equals((Object)ownerAddress) : di.writeOwners().contains(ownerAddress))));
        return valueToTest;
    }

    public void testInterceptorSizeCorrectWithStateTransfer() {
        if (!this.cacheMode.isClustered() || this.cacheMode.isDistributed() && this.nodeCount == 1) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        int numberToKill = 0;
        this.assertInterceptorCount();
        try {
            this.addClusterEnabledCacheManager(this.configurationBuilder);
            this.waitForClusterToForm();
            ++numberToKill;
            this.assertInterceptorCount();
            this.addClusterEnabledCacheManager(this.configurationBuilder);
            this.waitForClusterToForm();
            ++numberToKill;
            this.assertInterceptorCount();
            this.killMember(this.nodeCount);
            --numberToKill;
            this.assertInterceptorCount();
            this.killMember(this.nodeCount);
            --numberToKill;
            this.assertInterceptorCount();
        }
        finally {
            for (int i = 0; i < numberToKill; ++i) {
                this.killMember(this.nodeCount);
            }
        }
    }
}

