/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.eviction.impl.EvictionWithConcurrentOperationsTest;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PassivationPersistenceManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionWithPassivationAndConcurrentOperationsTest")
public class EvictionWithPassivationAndConcurrentOperationsTest
extends EvictionWithConcurrentOperationsTest {
    public EvictionWithPassivationAndConcurrentOperationsTest() {
        this.passivation = true;
    }

    @Override
    public void testEvictionDuringWrite() throws InterruptedException, ExecutionException, TimeoutException {
        super.testEvictionDuringWrite();
        this.eventuallyEquals(2L, () -> TestingUtil.extractComponent(this.cache, PassivationManager.class).getPassivations());
    }

    @Override
    public void testEvictionDuringRemove() throws InterruptedException, ExecutionException, TimeoutException {
        super.testEvictionDuringRemove();
        this.eventuallyEquals(0L, () -> TestingUtil.extractComponent(this.cache, PassivationManager.class).getPassivations());
    }

    public void testEvictionDuringLoad() throws InterruptedException, ExecutionException, TimeoutException {
        String key = "evicted-key";
        this.cache.put((Object)key, (Object)"loaded");
        this.cache.evict((Object)key);
        this.testEvictionDuring(key, () -> this.cache.get((Object)key), AssertJUnit::assertNotNull, AssertJUnit::assertNotNull, true);
        this.eventuallyEquals(3L, () -> TestingUtil.extractComponent(this.cache, PassivationManager.class).getPassivations());
    }

    public void testEvictionDuringWriteWithConcurrentRead() throws TimeoutException, InterruptedException, ExecutionException {
        String key = "evicted-key";
        String value = "value";
        DataOperationOrderer orderer = TestingUtil.extractComponent(this.cache, DataOperationOrderer.class);
        CompletableFuture<DataOperationOrderer.Operation> delayFuture1 = this.acquireOrderer(orderer, key, null);
        log.tracef("delayFuture1=%s", (Object)delayFuture1.toString());
        Future<Object> putEvictedKeyFuture = this.fork(() -> this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).put((Object)key, (Object)value));
        EvictionWithPassivationAndConcurrentOperationsTest.eventually(() -> orderer.getCurrentStage((Object)key) != delayFuture1);
        CompletionStage putEvictedKeyActivationStage = orderer.getCurrentStage((Object)key);
        CompletableFuture<DataOperationOrderer.Operation> delayFuture2 = this.acquireOrderer(orderer, key, putEvictedKeyActivationStage);
        log.tracef("delayFuture2=%s", (Object)delayFuture2.toString());
        orderer.completeOperation((Object)key, delayFuture1, DataOperationOrderer.Operation.READ);
        putEvictedKeyFuture.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)putEvictedKeyActivationStage.toCompletableFuture().isDone());
        this.cache.put((Object)"other-key", (Object)"other-value");
        CompletionStage putOtherKeyPassivationStage = orderer.getCurrentStage((Object)key);
        AssertJUnit.assertNotSame(delayFuture2, (Object)putOtherKeyPassivationStage);
        CompletableFuture<DataOperationOrderer.Operation> delayFuture3 = this.acquireOrderer(orderer, key, putOtherKeyPassivationStage);
        log.tracef("delayFuture3=%s", (Object)delayFuture3.toString());
        Future<Object> getFuture = this.fork(() -> this.cache.get((Object)key));
        EvictionWithPassivationAndConcurrentOperationsTest.eventually(() -> orderer.getCurrentStage((Object)key) != putOtherKeyPassivationStage);
        CompletionStage getEvictedKeyActivationStage = orderer.getCurrentStage((Object)key);
        AssertJUnit.assertFalse((boolean)getFuture.isDone());
        orderer.completeOperation((Object)key, delayFuture2, (DataOperationOrderer.Operation)putEvictedKeyActivationStage.toCompletableFuture().join());
        TestingUtil.assertNotDone(getFuture);
        orderer.completeOperation((Object)key, delayFuture3, (DataOperationOrderer.Operation)putOtherKeyPassivationStage.toCompletableFuture().join());
        AssertJUnit.assertEquals((Object)value, (Object)getFuture.get(10L, TimeUnit.SECONDS));
        this.eventuallyEquals(null, () -> orderer.getCurrentStage((Object)key));
        AssertJUnit.assertTrue((boolean)getEvictedKeyActivationStage.toCompletableFuture().isDone());
        AssertJUnit.assertEquals((long)2L, (long)TestingUtil.extractComponent(this.cache, PassivationManager.class).getPassivations());
        AssertJUnit.assertEquals((long)0L, (long)TestingUtil.extractComponent(this.cache, ActivationManager.class).getActivationCount());
        AssertJUnit.assertEquals((long)0L, (long)TestingUtil.extractComponent(this.cache, ActivationManager.class).getPendingActivationCount());
    }

    private CompletableFuture<DataOperationOrderer.Operation> acquireOrderer(DataOperationOrderer orderer, String key, CompletionStage<DataOperationOrderer.Operation> oldFuture) {
        CompletableFuture<DataOperationOrderer.Operation> newFuture = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage currentFuture = orderer.orderOn((Object)key, newFuture);
        AssertJUnit.assertSame((Object)currentFuture, oldFuture);
        if (currentFuture != null) {
            AssertJUnit.assertFalse((boolean)currentFuture.toCompletableFuture().isDone());
        }
        return newFuture;
    }

    public void testWriteDuringEviction() throws Exception {
        String key = "evicted-key";
        String initialValue = "value";
        this.cache.put((Object)key, (Object)initialValue);
        DataOperationOrderer orderer = TestingUtil.extractComponent(this.cache, DataOperationOrderer.class);
        CompletableFuture<DataOperationOrderer.Operation> delayFuture1 = this.acquireOrderer(orderer, key, null);
        log.tracef("delayFuture1=%s", (Object)delayFuture1.toString());
        Future<Object> putFuture = this.fork(() -> this.cache.put((Object)"other-key", (Object)"other-value"));
        EvictionWithPassivationAndConcurrentOperationsTest.eventually(() -> orderer.getCurrentStage((Object)key) != delayFuture1);
        CompletionStage putOtherKeyPassivationStage = orderer.getCurrentStage((Object)key);
        String newValue = "value-2";
        Future<Object> evictedKeyPutFuture = this.fork(() -> this.cache.put((Object)key, (Object)newValue));
        TestingUtil.assertNotDone(evictedKeyPutFuture);
        AssertJUnit.assertFalse((boolean)putOtherKeyPassivationStage.toCompletableFuture().isDone());
        orderer.completeOperation((Object)key, delayFuture1, DataOperationOrderer.Operation.READ);
        putFuture.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)initialValue, (Object)evictedKeyPutFuture.get(10L, TimeUnit.SECONDS));
        this.assertInMemory(key, newValue);
        PassivationPersistenceManager ppm = (PassivationPersistenceManager)TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        this.eventuallyEquals(0, () -> ((PassivationPersistenceManager)ppm).pendingPassivations());
        AssertJUnit.assertEquals((long)2L, (long)TestingUtil.extractComponent(this.cache, PassivationManager.class).getPassivations());
    }

    @Override
    protected void configurePersistence(ConfigurationBuilder builder) {
        builder.statistics().enable();
        builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
    }
}

