/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.ReplListener;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.UnicastInvalidationFuncTest")
public class UnicastInvalidationFuncTest
extends BaseDistFunctionalTest<Object, String> {
    public static final String KEY1 = "k1";

    public UnicastInvalidationFuncTest() {
        this.testRetVals = true;
        this.l1Threshold = -1;
    }

    public void testPut() {
        this.initAndTest();
        Cache nonOwner = this.getFirstNonOwner(KEY1);
        Cache owner = this.getOwners(KEY1)[0];
        Cache secondNonOwner = this.getSecondNonOwner(KEY1);
        ArrayList<ReplListener> listeners = new ArrayList<ReplListener>();
        nonOwner.put((Object)KEY1, (Object)"foo");
        AssertJUnit.assertNull((Object)nonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1));
        AssertJUnit.assertEquals((String)((String)owner.getAdvancedCache().getDataContainer().get((Object)KEY1).getValue()), (String)"foo");
        AssertJUnit.assertEquals((String)((String)secondNonOwner.get((Object)KEY1)), (String)"foo");
        AssertJUnit.assertEquals((String)((String)secondNonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1).getValue()), (String)"foo");
        ReplListener rl = new ReplListener(nonOwner);
        rl.expect((Class<? extends VisitableCommand>)InvalidateL1Command.class);
        listeners.add(rl);
        rl = new ReplListener(secondNonOwner);
        rl.expect((Class<? extends VisitableCommand>)InvalidateL1Command.class);
        listeners.add(rl);
        owner.put((Object)KEY1, (Object)"bar");
        for (ReplListener r : listeners) {
            r.waitForRpc();
        }
        Assert.assertNull((Object)secondNonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1));
        Assert.assertNull((Object)nonOwner.getAdvancedCache().getDataContainer().get((Object)KEY1));
    }
}

