/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.ObjectDuplicator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="distribution.DistSyncFuncTest")
public class DistSyncFuncTest
extends BaseDistFunctionalTest<Object, String> {
    public DistSyncFuncTest() {
        this.testRetVals = true;
    }

    public void testLocationConsensus() {
        String[] keys = new String[100];
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            keys[i] = Integer.toHexString(r.nextInt());
        }
        for (String key : keys) {
            ArrayList<Address> owners = new ArrayList<Address>();
            for (Cache c : this.caches) {
                boolean isOwner = this.isOwner(c, key);
                if (isOwner) {
                    owners.add(this.addressOf(c));
                }
                boolean secondCheck = this.getCacheTopology(c).getWriteOwners((Object)key).contains(this.addressOf(c));
                AssertJUnit.assertTrue((String)("Second check failed for key " + key + " on cache " + String.valueOf(this.addressOf(c)) + " isO = " + isOwner + " sC = " + secondCheck), (isOwner == secondCheck ? 1 : 0) != 0);
            }
            this.assertOwnershipConsensus(key);
            AssertJUnit.assertEquals((String)("Expected " + this.numOwners + " owners for key " + key + " but was " + String.valueOf(owners)), (int)this.numOwners, (int)owners.size());
        }
    }

    protected void assertOwnershipConsensus(String key) {
        List l1 = this.getCacheTopology(this.c1).getDistribution((Object)key).writeOwners();
        List l2 = this.getCacheTopology(this.c2).getDistribution((Object)key).writeOwners();
        List l3 = this.getCacheTopology(this.c3).getDistribution((Object)key).writeOwners();
        List l4 = this.getCacheTopology(this.c4).getDistribution((Object)key).writeOwners();
        AssertJUnit.assertEquals((String)("L1 " + String.valueOf(l1) + " and L2 " + String.valueOf(l2) + " don't agree."), (Object)l1, (Object)l2);
        AssertJUnit.assertEquals((String)("L2 " + String.valueOf(l2) + " and L3 " + String.valueOf(l3) + " don't agree."), (Object)l2, (Object)l3);
        AssertJUnit.assertEquals((String)("L3 " + String.valueOf(l3) + " and L4 " + String.valueOf(l4) + " don't agree."), (Object)l3, (Object)l4);
    }

    public void testBasicDistribution() throws Throwable {
        for (Cache c : this.caches) {
            AssertJUnit.assertTrue((boolean)c.isEmpty());
        }
        MagicKey k1 = this.getKeyForCache((Cache)this.caches.get(0));
        this.getOwners(k1)[0].put((Object)k1, (Object)"value");
        this.asyncWait((Object)k1, PutKeyValueCommand.class);
        this.assertOnAllCachesAndOwnership(k1, "value");
        if (this.l1CacheEnabled) {
            for (Cache c : this.caches) {
                if (this.isOwner(c, k1)) {
                    this.assertIsInContainerImmortal(c, k1);
                    continue;
                }
                this.assertIsInL1(c, k1);
            }
        }
    }

    public void testPutFromNonOwner() {
        this.initAndTest();
        Cache nonOwner = this.getFirstNonOwner("k1");
        Object retval = nonOwner.put((Object)"k1", (Object)"value2");
        this.asyncWait((Object)"k1", PutKeyValueCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value", (Object)retval);
        }
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testPutIfAbsentFromNonOwner() {
        this.initAndTest();
        log.trace((Object)"Here it begins");
        Object retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value", (Object)retval);
        }
        this.asyncWaitOnPrimary("k1", PutKeyValueCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class);
        retval = this.getFirstNonOwner("k1").putIfAbsent((Object)"k1", (Object)"value2");
        this.asyncWait((Object)"k1", PutKeyValueCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value2");
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
    }

    public void testRemoveFromNonOwner() {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").remove((Object)"k1");
        this.asyncWait((Object)"k1", RemoveCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value", (Object)retval);
        }
        this.assertRemovedOnAllCaches("k1");
    }

    public void testConditionalRemoveFromNonOwner() {
        this.initAndTest();
        log.trace((Object)"Here we start");
        boolean retval = this.getFirstNonOwner("k1").remove((Object)"k1", (Object)"value2");
        if (this.testRetVals) {
            AssertJUnit.assertFalse((String)"Should not have removed entry", (boolean)retval);
        }
        this.asyncWaitOnPrimary("k1", RemoveCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
        AssertJUnit.assertEquals((String)"value", (String)((String)((Cache)this.caches.get(1)).get((Object)"k1")));
        retval = this.getFirstNonOwner("k1").remove((Object)"k1", (Object)"value");
        this.asyncWait((Object)"k1", RemoveCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertTrue((String)"Should have removed entry", (boolean)retval);
        }
        AssertJUnit.assertNull((String)("expected null but received " + (String)((Cache)this.caches.get(1)).get((Object)"k1")), (Object)((Cache)this.caches.get(1)).get((Object)"k1"));
        this.assertRemovedOnAllCaches("k1");
    }

    public void testReplaceFromNonOwner() {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").replace((Object)"k1", (Object)"value2");
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value", (Object)retval);
        }
        this.asyncWait((Object)"k1", (VisitableCommand cmd) -> Stream.of(ReplaceCommand.class, PutKeyValueCommand.class).anyMatch(clazz -> clazz.isInstance(cmd)));
        this.assertOnAllCachesAndOwnership("k1", "value2");
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class);
        retval = this.getFirstNonOwner("k1").replace((Object)"k1", (Object)"value2");
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("k1");
    }

    public void testConditionalReplaceFromNonOwner() {
        this.initAndTest();
        Cache nonOwner = this.getFirstNonOwner("k1");
        boolean retval = nonOwner.replace((Object)"k1", (Object)"valueX", (Object)"value2");
        if (this.testRetVals) {
            AssertJUnit.assertFalse((String)"Should not have replaced", (boolean)retval);
        }
        this.asyncWaitOnPrimary("k1", ReplaceCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
        AssertJUnit.assertFalse((boolean)TestingUtil.extractComponent(nonOwner, DistributionManager.class).getCacheTopology().isWriteOwner((Object)"k1"));
        retval = nonOwner.replace((Object)"k1", (Object)"value", (Object)"value2");
        this.asyncWait((Object)"k1", (VisitableCommand cmd) -> Stream.of(ReplaceCommand.class, PutKeyValueCommand.class).anyMatch(clazz -> clazz.isInstance(cmd)));
        if (this.testRetVals) {
            AssertJUnit.assertTrue((String)"Should have replaced", (boolean)retval);
        }
        this.assertOnAllCachesAndOwnership("k1", "value2");
    }

    public void testClear() throws InterruptedException {
        int i;
        for (Cache c : this.caches) {
            AssertJUnit.assertTrue((boolean)c.isEmpty());
        }
        for (i = 0; i < 10; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait((Object)("k" + i), PutKeyValueCommand.class);
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (i = 0; i < 10; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            AssertJUnit.assertFalse((boolean)c.isEmpty());
        }
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class);
        for (Cache c : this.caches) {
            AssertJUnit.assertTrue((boolean)c.isEmpty());
        }
    }

    public void testKeyValueEntryCollections() {
        this.c1.put((Object)"1", (Object)"one");
        this.asyncWait((Object)"1", PutKeyValueCommand.class);
        if (this.c2 != null) {
            this.c2.put((Object)"2", (Object)"two");
            this.asyncWait((Object)"2", PutKeyValueCommand.class);
        }
        if (this.c3 != null) {
            this.c3.put((Object)"3", (Object)"three");
            this.asyncWait((Object)"3", PutKeyValueCommand.class);
        }
        if (this.c4 != null) {
            this.c4.put((Object)"4", (Object)"four");
            this.asyncWait((Object)"4", PutKeyValueCommand.class);
        }
        for (Cache c : this.caches) {
            Object key2;
            Set expKeys = TestingUtil.getInternalKeys(c);
            Collection expValues = TestingUtil.getInternalValues(c);
            Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
            Collection expValueEntries = ObjectDuplicator.duplicateCollection(expValues);
            AdvancedCache cacheWithIgnoredOwnership = c.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK});
            CacheSet keys = cacheWithIgnoredOwnership.keySet();
            for (Object key2 : keys) {
                AssertJUnit.assertTrue((boolean)expKeys.remove(key2));
            }
            AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeys) + " in iterator!"), (boolean)expKeys.isEmpty());
            CacheCollection values = cacheWithIgnoredOwnership.values();
            key2 = values.iterator();
            while (key2.hasNext()) {
                Object value = key2.next();
                AssertJUnit.assertTrue((boolean)expValues.remove(value));
            }
            AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValues) + " in iterator!"), (boolean)expValues.isEmpty());
            CacheSet entries = cacheWithIgnoredOwnership.entrySet();
            for (Map.Entry entry : entries) {
                AssertJUnit.assertTrue((boolean)expKeyEntries.remove(entry.getKey()));
                AssertJUnit.assertTrue((boolean)expValueEntries.remove(entry.getValue()));
            }
            AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expKeyEntries) + " in iterator!"), (boolean)expKeyEntries.isEmpty());
            AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expValueEntries) + " in iterator!"), (boolean)expValueEntries.isEmpty());
        }
    }

    public void testLockedStreamSetValue() {
        int i;
        int size = 5;
        for (i = 0; i < size; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait((Object)("k" + i), PutKeyValueCommand.class);
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        this.c1.getAdvancedCache().lockedStream().forEach((SerializableBiConsumer & Serializable)(c, e) -> e.setValue((Object)((String)e.getValue() + "-changed")));
        for (i = 0; i < size; ++i) {
            Cache<K, V>[] caches;
            String key = "k" + i;
            this.asyncWait((Object)key, (VisitableCommand c) -> this.commandIsPutForKey(key, (VisitableCommand)c));
            for (Cache cache : caches = this.getOwners(key)) {
                AssertJUnit.assertEquals((String)("value" + i + "-changed"), (String)((String)cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).get((Object)key)));
            }
        }
    }

    public void testLockedStreamPutValue() {
        int i;
        int size = 5;
        for (i = 0; i < size; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait((Object)("k" + i), PutKeyValueCommand.class);
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        this.c1.getAdvancedCache().lockedStream().forEach((SerializableBiConsumer & Serializable)(c, e) -> c.put(e.getKey(), (Object)((String)e.getValue() + "-changed")));
        for (i = 0; i < size; ++i) {
            Cache<K, V>[] caches;
            String key = "k" + i;
            this.asyncWait((Object)key, (VisitableCommand c) -> this.commandIsPutForKey(key, (VisitableCommand)c));
            for (Cache cache : caches = this.getOwners(key)) {
                AssertJUnit.assertEquals((String)("value" + i + "-changed"), (String)((String)cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).get((Object)key)));
            }
        }
    }

    private boolean commandIsPutForKey(String key, VisitableCommand c) {
        return c instanceof PutKeyValueCommand && key.equals(((PutKeyValueCommand)c).getKey());
    }

    public void testComputeFromNonOwner() throws InterruptedException {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").compute((Object)"k1", (SerializableBiFunction & Serializable)(k, v) -> "computed_" + String.valueOf(k) + "_" + v);
        this.asyncWait((Object)"k1", ComputeCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"computed_k1_value", (Object)retval);
        }
        this.assertOnAllCachesAndOwnership("k1", "computed_k1_value");
        retval = this.getFirstNonOwner("k1").compute((Object)"k1", (SerializableBiFunction & Serializable)(v1, v2) -> null);
        this.asyncWait((Object)"k1", ComputeCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("k1");
        retval = this.getFirstNonOwner("notThere").compute((Object)"notThere", (SerializableBiFunction & Serializable)(k, v) -> "add_" + String.valueOf(k));
        this.asyncWait((Object)"notThere", ComputeCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"add_notThere", (Object)retval);
        }
        this.assertOnAllCachesAndOwnership("notThere", "add_notThere");
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        SerializableBiFunction & Serializable mappingToException = (SerializableBiFunction & Serializable)(k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RemoteException.class, () -> this.getFirstNonOwner("k1").compute((Object)"k1", mappingToException));
    }

    public void testComputeIfPresentFromNonOwner() throws InterruptedException {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").computeIfPresent((Object)"k1", (SerializableBiFunction & Serializable)(k, v) -> "computed_" + String.valueOf(k) + "_" + v);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"computed_k1_value", (Object)retval);
        }
        this.asyncWait((Object)"k1", ComputeCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "computed_k1_value");
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        SerializableBiFunction & Serializable mappingToException = (SerializableBiFunction & Serializable)(k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RemoteException.class, () -> this.getFirstNonOwner("k1").computeIfPresent((Object)"k1", mappingToException));
        retval = this.getFirstNonOwner("k1").computeIfPresent((Object)"k1", (SerializableBiFunction & Serializable)(v1, v2) -> null);
        this.asyncWait((Object)"k1", ComputeCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("k1");
        retval = this.getFirstNonOwner("notThere").computeIfPresent((Object)"notThere", (SerializableBiFunction & Serializable)(k, v) -> "add_" + String.valueOf(k));
        this.asyncWaitOnPrimary("notThere", ComputeCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("notThere");
    }

    public void testComputeIfAbsentFromNonOwner() throws InterruptedException {
        this.initAndTest();
        Object retval = this.getFirstNonOwner("k1").computeIfAbsent((Object)"k1", (SerializableFunction & Serializable)k -> "computed_" + String.valueOf(k));
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value", (Object)retval);
        }
        this.asyncWaitOnPrimary("k1", ComputeIfAbsentCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
        retval = this.getFirstNonOwner("notExists").computeIfAbsent((Object)"notExists", (SerializableFunction & Serializable)k -> "computed_" + String.valueOf(k));
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"computed_notExists", (Object)retval);
        }
        this.asyncWait((Object)"notExists", ComputeIfAbsentCommand.class);
        this.assertOnAllCachesAndOwnership("notExists", "computed_notExists");
        retval = this.getFirstNonOwner("doNothing").computeIfAbsent((Object)"doNothing", (SerializableFunction & Serializable)k -> null);
        this.asyncWaitOnPrimary("doNothing", ComputeIfAbsentCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("doNothing");
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        SerializableFunction & Serializable mappingToException = (SerializableFunction & Serializable)k -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RemoteException.class, () -> this.getFirstNonOwner("somethingWrong").computeIfAbsent((Object)"somethingWrong", mappingToException));
    }

    public void testMergeFromNonOwner() {
        this.initAndTest();
        RuntimeException mergeException = new RuntimeException("hi there");
        Exceptions.expectException(RemoteException.class, () -> this.getFirstNonOwner("k1").merge((Object)"k1", (Object)"ex", (SerializableBiFunction & Serializable)(k, v) -> {
            throw mergeException;
        }));
        this.asyncWaitOnPrimary("k1", ReadWriteKeyCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
        Object retval = this.getFirstNonOwner("k1").merge((Object)"k1", (Object)"value2", (SerializableBiFunction & Serializable)(v1, v2) -> "merged_" + v1 + "_" + v2);
        this.asyncWait((Object)"k1", ReadWriteKeyCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"merged_value_value2", (Object)retval);
        }
        this.assertOnAllCachesAndOwnership("k1", "merged_value_value2");
        retval = this.getFirstNonOwner("k1").merge((Object)"k1", (Object)"valueRem", (SerializableBiFunction & Serializable)(v1, v2) -> null);
        this.asyncWait((Object)"k1", ReadWriteKeyCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertNull((Object)retval);
        }
        this.assertRemovedOnAllCaches("k1");
        retval = this.getFirstNonOwner("notThere").merge((Object)"notThere", (Object)"value2", (SerializableBiFunction & Serializable)(v1, v2) -> "merged_" + v1 + "_" + v2);
        this.asyncWait((Object)"notThere", ReadWriteKeyCommand.class);
        if (this.testRetVals) {
            AssertJUnit.assertEquals((Object)"value2", (Object)retval);
        }
        this.assertOnAllCachesAndOwnership("notThere", "value2");
    }
}

