/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import jakarta.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.groups.KXGrouper;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;

public abstract class BaseDistFunctionalTest<K, V>
extends MultipleCacheManagersTest {
    protected String cacheName;
    protected int INIT_CLUSTER_SIZE = 4;
    protected Cache<K, V> c1 = null;
    protected Cache<K, V> c2 = null;
    protected Cache<K, V> c3 = null;
    protected Cache<K, V> c4 = null;
    protected ConfigurationBuilder configuration;
    protected List<Cache<K, V>> caches;
    protected List<Address> cacheAddresses;
    protected boolean testRetVals = true;
    protected boolean l1CacheEnabled = true;
    protected int l1Threshold = 5;
    protected boolean performRehashing = false;
    protected boolean batchingEnabled = false;
    protected int numOwners = 2;
    protected int lockTimeout = 45;
    protected boolean groupers = false;
    protected boolean onePhaseCommitOptimization = false;

    public BaseDistFunctionalTest() {
        this.cacheMode = CacheMode.DIST_SYNC;
        this.transactional = false;
    }

    public BaseDistFunctionalTest<K, V> numOwners(int numOwners) {
        this.numOwners = numOwners;
        return this;
    }

    public BaseDistFunctionalTest<K, V> l1(boolean l1) {
        this.l1CacheEnabled = l1;
        return this;
    }

    public BaseDistFunctionalTest<K, V> groupers(boolean groupers) {
        this.groupers = groupers;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return BaseDistFunctionalTest.concat(super.parameterNames(), "numOwners", "l1", "groupers");
    }

    @Override
    protected Object[] parameterValues() {
        return BaseDistFunctionalTest.concat(super.parameterValues(), this.numOwners != 2 ? Integer.valueOf(this.numOwners) : null, this.l1CacheEnabled ? null : Boolean.FALSE, this.groupers ? Boolean.TRUE : null);
    }

    protected void createClusteredCache() {
        this.createClusteredCaches(this.INIT_CLUSTER_SIZE, this.cacheName, this.getSerializationContext(), this.configuration, new TransportFlags().withFD(false));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheName = "dist";
        this.configuration = this.buildConfiguration();
        this.createClusteredCache();
        this.caches = this.caches(this.cacheName);
        if (this.INIT_CLUSTER_SIZE > 0) {
            this.c1 = this.caches.get(0);
        }
        if (this.INIT_CLUSTER_SIZE > 1) {
            this.c2 = this.caches.get(1);
        }
        if (this.INIT_CLUSTER_SIZE > 2) {
            this.c3 = this.caches.get(2);
        }
        if (this.INIT_CLUSTER_SIZE > 3) {
            this.c4 = this.caches.get(3);
        }
        this.cacheAddresses = new ArrayList<Address>(this.INIT_CLUSTER_SIZE);
        for (Cache<K, V> cache : this.caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            this.cacheAddresses.add(cacheManager.getAddress());
        }
    }

    protected SerializationContextInitializer getSerializationContext() {
        return TestDataSCI.INSTANCE;
    }

    @Override
    protected void killMember(int cacheIndex, String cacheName, boolean awaitRehash) {
        super.killMember(cacheIndex, cacheName, awaitRehash);
        this.caches.remove(cacheIndex);
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder configuration = BaseDistFunctionalTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        configuration.clustering().stateTransfer().fetchInMemoryState(this.performRehashing);
        if (this.lockingMode != null) {
            configuration.transaction().lockingMode(this.lockingMode);
        }
        configuration.clustering().hash().numOwners(this.numOwners);
        if (!this.testRetVals) {
            configuration.unsafe().unreliableReturnValues(true);
            configuration.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        } else {
            configuration.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        }
        if (this.transactional.booleanValue()) {
            configuration.invocationBatching().enable();
            if (this.onePhaseCommitOptimization) {
                configuration.transaction().use1PcForAutoCommitTransactions(true);
            }
        }
        if (this.cacheMode.isSynchronous()) {
            configuration.clustering().remoteTimeout(60L, TimeUnit.SECONDS);
        }
        configuration.locking().lockAcquisitionTimeout((long)this.lockTimeout, TimeUnit.SECONDS);
        configuration.clustering().l1().enabled(this.l1CacheEnabled);
        if (this.groupers) {
            configuration.clustering().hash().groups().enabled(true);
            configuration.clustering().hash().groups().withGroupers(Collections.singletonList(new KXGrouper()));
        }
        if (this.l1CacheEnabled) {
            configuration.clustering().l1().invalidationThreshold(this.l1Threshold);
        }
        return configuration;
    }

    protected boolean isTriangle() {
        return TestingUtil.isTriangleAlgorithm(this.cacheMode, this.transactional);
    }

    protected void initAndTest() {
        for (Cache<K, V> c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<K, V> firstCache = this.caches.get(0);
        firstCache.put((Object)"k1", (Object)"value");
        this.asyncWait((Object)"k1", PutKeyValueCommand.class);
        this.assertOnAllCachesAndOwnership("k1", "value");
    }

    protected Address addressOf(Cache<?, ?> cache) {
        return DistributionTestHelper.addressOf(cache);
    }

    protected Cache<K, V> getFirstNonOwner(Object key) {
        return DistributionTestHelper.getFirstNonOwner(key, this.caches);
    }

    protected Cache<K, V> getFirstOwner(Object key) {
        return DistributionTestHelper.getFirstOwner(key, this.caches);
    }

    protected Cache<K, V> getSecondNonOwner(String key) {
        return this.getNonOwners(key)[1];
    }

    protected void assertOnAllCachesAndOwnership(Object key, String value) {
        this.assertOwnershipAndNonOwnership(key, this.l1CacheEnabled);
        this.assertOnAllCaches(key, value);
    }

    protected void assertRemovedOnAllCaches(Object key) {
        this.assertOnAllCaches(key, null);
    }

    protected void assertOnAllCaches(Object key, String value) {
        for (Cache<K, V> c : this.caches) {
            Object realVal = c.get(key);
            if (value == null) {
                assert (realVal == null) : "Expecting [" + String.valueOf(key) + "] to equal [" + value + "] on cache [" + String.valueOf(this.addressOf(c)) + "] but was [" + String.valueOf(realVal) + "]. Owners are " + Arrays.toString(this.getOwners(key));
                continue;
            }
            assert (value.equals(realVal)) : "Expecting [" + String.valueOf(key) + "] to equal [" + value + "] on cache [" + String.valueOf(this.addressOf(c)) + "] but was [" + String.valueOf(realVal) + "]";
        }
        TestingUtil.sleepThread(100L);
    }

    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        for (Cache<K, V> c : this.caches) {
            DataContainer dc = c.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dc.get(key);
            if (this.isOwner(c, key)) {
                assert (ice != null && ice.getValue() != null) : "Fail on owner cache " + String.valueOf(this.addressOf(c)) + ": dc.get(" + String.valueOf(key) + ") returned " + String.valueOf(ice);
                assert (ice instanceof ImmortalCacheEntry) : "Fail on owner cache " + String.valueOf(this.addressOf(c)) + ": dc.get(" + String.valueOf(key) + ") returned " + this.safeType(ice);
                continue;
            }
            if (allowL1) {
                assert (ice == null || ice.getValue() == null || ice.isL1Entry()) : "Fail on non-owner cache " + String.valueOf(this.addressOf(c)) + ": dc.get(" + String.valueOf(key) + ") returned " + this.safeType(ice);
                continue;
            }
            this.eventually("Fail on non-owner cache " + String.valueOf(this.addressOf(c)) + ": dc.get(" + String.valueOf(key) + ")", () -> {
                InternalCacheEntry ice2 = dc.get(key);
                return ice2 == null || ice2.getValue() == null;
            });
        }
    }

    protected String safeType(Object o) {
        return DistributionTestHelper.safeType(o);
    }

    protected boolean isInL1(Cache<?, ?> cache, Object key) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(key);
        return ice != null && ice.getValue() != null && !(ice instanceof ImmortalCacheEntry);
    }

    protected void assertIsInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1(cache, key);
    }

    protected void assertIsNotInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsNotInL1(cache, key);
    }

    protected void assertIsInContainerImmortal(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInContainerImmortal(cache, key);
    }

    protected void assertIsInL1OrNull(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1OrNull(cache, key);
    }

    protected boolean isOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isOwner(c, key);
    }

    protected boolean isFirstOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isFirstOwner(c, key);
    }

    protected Cache<K, V>[] getOwners(Object key) {
        Cache[] arr = new Cache[this.numOwners];
        DistributionTestHelper.getOwners(key, this.caches).toArray(arr);
        return arr;
    }

    protected Cache<K, V>[] getOwners(Object key, int expectedNumberOwners) {
        Cache[] arr = new Cache[expectedNumberOwners];
        DistributionTestHelper.getOwners(key, this.caches).toArray(arr);
        return arr;
    }

    protected Cache<K, V>[] getNonOwnersExcludingSelf(Object key, Address self) {
        Cache<K, V>[] nonOwners = this.getNonOwners(key);
        boolean selfInArray = false;
        for (Cache<K, V> c : nonOwners) {
            if (!this.addressOf(c).equals((Object)self)) continue;
            selfInArray = true;
            break;
        }
        if (selfInArray) {
            Cache[] nonOwnersExclSelf = new Cache[nonOwners.length - 1];
            int i = 0;
            for (Cache<K, V> c : nonOwners) {
                if (this.addressOf(c).equals((Object)self)) continue;
                nonOwnersExclSelf[i++] = c;
            }
            return nonOwnersExclSelf;
        }
        return nonOwners;
    }

    protected Cache<K, V>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 2);
    }

    protected Cache<K, V>[] getNonOwners(Object key, int expectedNumberNonOwners) {
        Cache[] nonOwners = new Cache[expectedNumberNonOwners];
        DistributionTestHelper.getNonOwners(key, this.caches).toArray(nonOwners);
        return nonOwners;
    }

    protected DistributionManager getDistributionManager(Cache<?, ?> c) {
        return TestingUtil.extractComponent(c, DistributionManager.class);
    }

    protected LocalizedCacheTopology getCacheTopology(Cache<?, ?> c) {
        return this.getDistributionManager(c).getCacheTopology();
    }

    protected void asyncWait(Object key, Class<? extends VisitableCommand> command) {
        this.asyncWait(key, command::isInstance);
    }

    protected void asyncWait(Object key, Predicate<VisitableCommand> test) {
    }

    protected void asyncWaitOnPrimary(Object key, Class<? extends VisitableCommand> command) {
    }

    protected TransactionManager getTransactionManager(Cache<?, ?> cache) {
        return TestingUtil.getTransactionManager(cache);
    }

    protected static void removeAllBlockingInterceptorsFromCache(Cache<?, ?> cache) {
        AsyncInterceptorChain chain = TestingUtil.extractInterceptorChain(cache);
        BlockingInterceptor blockingInterceptor = (BlockingInterceptor)chain.findInterceptorExtending(BlockingInterceptor.class);
        while (blockingInterceptor != null) {
            blockingInterceptor.suspend(true);
            chain.removeInterceptor(((Object)((Object)blockingInterceptor)).getClass());
            blockingInterceptor = (BlockingInterceptor)chain.findInterceptorExtending(BlockingInterceptor.class);
        }
    }

    protected MagicKey getMagicKey() {
        switch (this.numOwners) {
            case 1: {
                return new MagicKey(this.c1);
            }
            case 2: {
                return new MagicKey(this.c1, this.c2);
            }
        }
        throw new IllegalArgumentException();
    }
}

