/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.dataconversion;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.dataconversion.TestXMLParser;

class ObjectXMLTranscoder
implements Transcoder {
    private final Set<MediaType> supported;
    private final TestXMLParser parser = new TestXMLParser();

    ObjectXMLTranscoder() {
        this.supported = new HashSet<MediaType>();
        this.supported.add(MediaType.APPLICATION_XML);
        this.supported.add(MediaType.APPLICATION_OBJECT);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                return this.parser.parse((String)content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            try {
                return this.parser.serialize((Map)content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supported;
    }
}

