/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.Random;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class KeyGenerator {
    private static final int randomSeed = 17;
    private static final int keySpaceSize = 1000;
    private static final int keyObjectSize = 10;
    private static final int valueSpaceSize = 100;
    private static final int valueObjectSize = 1000;
    private final RandomSequence keySequence;
    private final RandomSequence valueSequence;
    private final Metadata metadata;

    public KeyGenerator() {
        Random random = new Random(17L);
        this.keySequence = new RandomSequence(random, 1000, 10);
        this.valueSequence = new RandomSequence(random, 100, 1000);
        this.metadata = new EmbeddedMetadata.Builder().build();
    }

    public WrappedByteArray getNextKey() {
        return this.keySequence.nextValue();
    }

    public WrappedByteArray getNextValue() {
        return this.valueSequence.nextValue();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private WrappedByteArray toUserObject(byte[] bytes) {
        return new WrappedByteArray(bytes);
    }

    private class RandomSequence {
        private final WrappedByteArray[] list;
        private final int spaceSize;
        private int idx = -1;

        RandomSequence(Random random, int spaceSize, int objectSize) {
            this.list = new WrappedByteArray[spaceSize];
            this.spaceSize = spaceSize;
            for (int i = 0; i < spaceSize; ++i) {
                byte[] bytes = new byte[objectSize];
                random.nextBytes(bytes);
                this.list[i] = KeyGenerator.this.toUserObject(bytes);
            }
        }

        WrappedByteArray nextValue() {
            ++this.idx;
            if (this.idx == this.spaceSize) {
                this.idx = 0;
            }
            return this.list[this.idx];
        }
    }
}

