/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.cache.L1ConfigurationBuilderTest")
public class L1ConfigurationBuilderTest {
    public void testDefaultsWhenEnabledOnly() {
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).l1().enable().build();
        L1Configuration l1Config = config.clustering().l1();
        Assert.assertTrue((boolean)l1Config.enabled());
        Assert.assertEquals((long)l1Config.cleanupTaskFrequency(), (long)TimeUnit.MINUTES.toMillis(1L));
        Assert.assertEquals((int)l1Config.invalidationThreshold(), (int)0);
        Assert.assertEquals((long)l1Config.lifespan(), (long)TimeUnit.MINUTES.toMillis(10L));
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testL1WithExceptionEviction() {
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).l1().enable().memory().evictionStrategy(EvictionStrategy.EXCEPTION).size(10L).transaction().transactionMode(TransactionMode.TRANSACTIONAL).build();
        Assert.assertNotNull((Object)config);
    }
}

