/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.APINonTxTest;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.stats.Stats;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.SimpleCacheTest")
public class SimpleCacheTest
extends APINonTxTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.simpleCache(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cb);
        this.cache = AbstractDelegatingCache.unwrapCache((Cache)cm.getCache());
        AssertJUnit.assertTrue((boolean)(this.cache instanceof SimpleCacheImpl));
        return cm;
    }

    public void testFindInterceptor() {
        AsyncInterceptorChain interceptorChain = TestingUtil.extractInterceptorChain(this.cache());
        AssertJUnit.assertNotNull((Object)interceptorChain);
        AssertJUnit.assertNull((Object)interceptorChain.findInterceptorExtending(InvocationContextInterceptor.class));
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testTransactions() {
        new ConfigurationBuilder().simpleCache(true).transaction().transactionMode(TransactionMode.TRANSACTIONAL).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testBatching() {
        new ConfigurationBuilder().simpleCache(true).invocationBatching().enable(true).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000381: This configuration is not supported for simple cache")
    public void testIndexing() {
        new ConfigurationBuilder().simpleCache(true).indexing().enable().build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testStoreAsBinary() {
        new ConfigurationBuilder().simpleCache(true).memory().storageType(StorageType.BINARY).build();
    }

    @Override
    @Test(dataProvider="lockedStreamActuallyLocks", expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamActuallyLocks(BiConsumer<Cache<Object, Object>, CacheEntry<Object, Object>> consumer, boolean forEachOrInvokeAll) throws Throwable {
        super.testLockedStreamActuallyLocks(consumer, forEachOrInvokeAll);
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamSetValue() {
        super.testLockedStreamSetValue();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamWithinLockedStream() {
        super.testLockedStreamWithinLockedStream();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamInvokeAllFilteredSet() {
        super.testLockedStreamInvokeAllFilteredSet();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamInvokeAllPut() {
        super.testLockedStreamInvokeAllPut();
    }

    public void testStatistics() {
        Configuration cfg = new ConfigurationBuilder().simpleCache(true).statistics().enabled(true).build();
        String name = "statsCache";
        this.cacheManager.defineConfiguration(name, cfg);
        Cache cache = this.cacheManager.getCache(name);
        AssertJUnit.assertEquals((long)0L, (long)cache.getAdvancedCache().getStats().getStores());
        cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((long)1L, (long)cache.getAdvancedCache().getStats().getStores());
    }

    public void testEvictionWithStatistics() {
        int KEY_COUNT = 5;
        Configuration cfg = new ConfigurationBuilder().simpleCache(true).memory().size(1L).statistics().enable().build();
        String name = "evictionCache";
        this.cacheManager.defineConfiguration(name, cfg);
        Cache cache = this.cacheManager.getCache(name);
        for (int i = 0; i < KEY_COUNT; ++i) {
            cache.put((Object)("key" + i), (Object)"value");
        }
        Stats stats = cache.getAdvancedCache().getStats();
        AssertJUnit.assertEquals((int)1, (int)stats.getCurrentNumberOfEntriesInMemory());
        AssertJUnit.assertEquals((long)KEY_COUNT, (long)stats.getStores());
        AssertJUnit.assertEquals((long)(KEY_COUNT - 1), (long)stats.getEvictions());
    }

    public void testPutAsyncEntry() {
        AdvancedCache c = this.cache.getAdvancedCache();
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).lifespan(25000L).maxIdle(30000L).build();
        AssertJUnit.assertNull(FunctionalTestUtils.await(c.putAsync((Object)"k", (Object)"v1", metadata)));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k"));
        Metadata updatedMetadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(2L)).lifespan(35000L).maxIdle(42000L).build();
        CacheEntry previousEntry = (CacheEntry)FunctionalTestUtils.await(c.putAsyncEntry((Object)"k", (Object)"v2", updatedMetadata));
        AssertJUnit.assertEquals((Object)"k", (Object)previousEntry.getKey());
        AssertJUnit.assertEquals((Object)"v1", (Object)previousEntry.getValue());
        AssertJUnit.assertNotNull((Object)previousEntry.getMetadata());
        this.assertMetadata(metadata, previousEntry.getMetadata());
        CacheEntry currentEntry = c.getCacheEntry((Object)"k");
        AssertJUnit.assertEquals((Object)"k", (Object)currentEntry.getKey());
        AssertJUnit.assertEquals((Object)"v2", (Object)currentEntry.getValue());
        AssertJUnit.assertNotNull((Object)currentEntry.getMetadata());
        this.assertMetadata(updatedMetadata, currentEntry.getMetadata());
    }

    public void testPutIfAbsentAsyncEntry() {
        AdvancedCache c = this.cache.getAdvancedCache();
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).lifespan(25000L).maxIdle(30000L).build();
        AssertJUnit.assertNull(FunctionalTestUtils.await(c.putAsync((Object)"k", (Object)"v1", metadata)));
        AssertJUnit.assertEquals((Object)"v1", (Object)c.get((Object)"k"));
        Metadata updatedMetadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(2L)).lifespan(35000L).maxIdle(42000L).build();
        CacheEntry previousEntry = (CacheEntry)FunctionalTestUtils.await(c.putIfAbsentAsyncEntry((Object)"k", (Object)"v2", updatedMetadata));
        AssertJUnit.assertEquals((Object)"k", (Object)previousEntry.getKey());
        AssertJUnit.assertEquals((Object)"v1", (Object)previousEntry.getValue());
        this.assertMetadata(metadata, previousEntry.getMetadata());
        CacheEntry currentEntry = (CacheEntry)FunctionalTestUtils.await(c.getCacheEntryAsync((Object)"k"));
        AssertJUnit.assertEquals((Object)"k", (Object)currentEntry.getKey());
        AssertJUnit.assertEquals((Object)"v1", (Object)currentEntry.getValue());
        AssertJUnit.assertNotNull((Object)currentEntry.getMetadata());
        this.assertMetadata(metadata, currentEntry.getMetadata());
    }

    public void testRemoveAsyncEntry() {
        AdvancedCache c = this.cache.getAdvancedCache();
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).lifespan(25000L).maxIdle(30000L).build();
        AssertJUnit.assertNull(FunctionalTestUtils.await(c.putAsync((Object)"k", (Object)"v", metadata)));
        CacheEntry currentEntry = (CacheEntry)FunctionalTestUtils.await(c.getCacheEntryAsync((Object)"k"));
        AssertJUnit.assertEquals((Object)"k", (Object)currentEntry.getKey());
        AssertJUnit.assertEquals((Object)"v", (Object)currentEntry.getValue());
        AssertJUnit.assertNotNull((Object)currentEntry.getMetadata());
        this.assertMetadata(metadata, currentEntry.getMetadata());
        CacheEntry previousEntry = (CacheEntry)FunctionalTestUtils.await(c.removeAsyncEntry((Object)"k"));
        AssertJUnit.assertEquals((Object)"k", (Object)previousEntry.getKey());
        AssertJUnit.assertEquals((Object)"v", (Object)previousEntry.getValue());
        this.assertMetadata(metadata, previousEntry.getMetadata());
        AssertJUnit.assertNull((Object)c.get((Object)"k"));
        AssertJUnit.assertNull(FunctionalTestUtils.await(c.removeAsyncEntry((Object)"k")));
    }

    public void testReplaceAsyncEntryNonExistingKey() {
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).lifespan(25000L).maxIdle(30000L).build();
        CompletableFuture f = this.cache.getAdvancedCache().replaceAsyncEntry((Object)"k", (Object)"v", metadata);
        AssertJUnit.assertNull(FunctionalTestUtils.await(f));
    }

    public void testComputeWithExistingValue() {
        AssertJUnit.assertNull((Object)this.cache.put((Object)"k", (Object)"v"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.compute((Object)"k", (SerializableBiFunction & Serializable)(key, value) -> value));
    }

    public void testReplaceAsyncEntryExistingKey() {
        AdvancedCache c = this.cache.getAdvancedCache();
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).lifespan(25000L).maxIdle(30000L).build();
        AssertJUnit.assertNull(FunctionalTestUtils.await(c.putAsync((Object)"k", (Object)"v1", metadata)));
        Metadata updatedMetadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(2L)).lifespan(35000L).maxIdle(42000L).build();
        CacheEntry previousEntry = (CacheEntry)FunctionalTestUtils.await(c.replaceAsyncEntry((Object)"k", (Object)"v2", updatedMetadata));
        AssertJUnit.assertEquals((Object)previousEntry.getKey(), (Object)"k");
        AssertJUnit.assertEquals((Object)previousEntry.getValue(), (Object)"v1");
        this.assertMetadata(metadata, previousEntry.getMetadata());
        CacheEntry currentEntry = (CacheEntry)FunctionalTestUtils.await(c.getCacheEntryAsync((Object)"k"));
        AssertJUnit.assertEquals((Object)"k", (Object)currentEntry.getKey());
        AssertJUnit.assertEquals((Object)"v2", (Object)currentEntry.getValue());
        AssertJUnit.assertNotNull((Object)currentEntry.getMetadata());
        this.assertMetadata(updatedMetadata, currentEntry.getMetadata());
    }

    private void assertMetadata(Metadata expected, Metadata actual) {
        AssertJUnit.assertEquals((Object)expected.version(), (Object)actual.version());
        AssertJUnit.assertEquals((long)expected.lifespan(), (long)actual.lifespan());
        AssertJUnit.assertEquals((long)expected.maxIdle(), (long)actual.maxIdle());
    }
}

