/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.CacheClusterJoinTest")
public class CacheClusterJoinTest
extends MultipleCacheManagersTest {
    private EmbeddedCacheManager cm1;
    private EmbeddedCacheManager cm2;
    private ConfigurationBuilder cfg;

    public CacheClusterJoinTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cm1 = this.addClusterEnabledCacheManager();
        this.cfg = new ConfigurationBuilder();
        this.cfg.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        this.cm1.defineConfiguration("cache", this.cfg.build());
    }

    public void testGetMembers() throws Exception {
        this.cm1.getCache("cache");
        List memb1 = this.cm1.getMembers();
        assert (1 == memb1.size()) : "Expected 1 member; was " + String.valueOf(memb1);
        Object coord = memb1.get(0);
        this.cm2 = this.addClusterEnabledCacheManager();
        this.cm2.defineConfiguration("cache", this.cfg.build());
        this.cm2.getCache("cache");
        TestingUtil.blockUntilViewsReceived(50000L, true, new CacheContainer[]{this.cm1, this.cm2});
        memb1 = this.cm1.getMembers();
        List memb2 = this.cm2.getMembers();
        assert (2 == memb1.size());
        assert (memb1.equals(memb2));
        TestingUtil.killCacheManagers(this.cm1);
        TestingUtil.blockUntilViewsReceived(50000L, false, new CacheContainer[]{this.cm2});
        memb2 = this.cm2.getMembers();
        assert (1 == memb2.size());
        assert (!coord.equals(memb2.get(0)));
    }

    public void testIsCoordinator() throws Exception {
        this.cm1.getCache("cache");
        assert (this.cm1.isCoordinator()) : "Should be coordinator!";
        this.cm2 = this.addClusterEnabledCacheManager();
        this.cm2.defineConfiguration("cache", this.cfg.build());
        this.cm2.getCache("cache");
        assert (this.cm1.isCoordinator());
        assert (!this.cm2.isCoordinator());
        TestingUtil.killCacheManagers(this.cm1);
        TestingUtil.blockUntilViewsReceived(50000L, false, new CacheContainer[]{this.cm2});
        assert (this.cm2.isCoordinator());
    }
}

