/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.commons.lambda.NamedLambdas;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.ObjectDuplicator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.APINonTxTest")
public class APINonTxTest
extends SingleCacheManagerTest {
    protected void configure(ConfigurationBuilder builder) {
    }

    @AfterMethod
    public void checkForLeakedTransactions() {
        TransactionTable txTable = TestingUtil.getTransactionTable(this.cache);
        if (txTable != null) {
            AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTxCount());
            AssertJUnit.assertEquals((int)0, (int)txTable.getLocalTransactions().size());
        }
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(false);
        this.configure(c);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(true, TestDataSCI.INSTANCE);
        cm.defineConfiguration("test", c.build());
        this.cache = cm.getCache("test");
        return cm;
    }

    public void testConvenienceMethods() {
        String key = "key";
        String value = "value";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.assertCacheIsEmpty();
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        this.assertCacheSize(1);
        this.cache.remove((Object)key);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.assertCacheIsEmpty();
        this.cache.putAll(data);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        this.assertCacheSize(1);
    }

    public void testStopClearsData() {
        String key = "key";
        String value = "value";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        this.assertCacheSize(1);
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        this.cache.stop();
        AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)this.cache.getStatus());
        this.cache.start();
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertFalse((boolean)this.cache.values().contains((Object)value));
        this.assertCacheIsEmpty();
    }

    public void testEvict() {
        String key1 = "keyOne";
        String key2 = "keyTwo";
        String value = "value";
        this.cache.put((Object)key1, (Object)value);
        this.cache.put((Object)key2, (Object)value);
        Assert.assertTrue((boolean)this.cache.containsKey((Object)key1));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)key2));
        this.assertCacheSize(2);
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key1));
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key2));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        this.cache.evict((Object)key2);
        Assert.assertTrue((boolean)this.cache.containsKey((Object)key1));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key2));
        this.assertCacheSize(1);
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key1));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key2));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        this.cache.evict((Object)key1);
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key1));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key2));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key1));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key2));
        Assert.assertFalse((boolean)this.cache.values().contains((Object)value));
        this.assertCacheIsEmpty();
        this.cache.evict((Object)key1);
    }

    public void testUnsupportedKeyValueCollectionOperationsAddMethod() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet keys = this.cache.keySet();
        CacheCollection values = this.cache.values();
        Collection[] collections = new Collection[]{keys, values};
        String newObj = "4";
        ArrayList<String> newObjCol = new ArrayList<String>();
        newObjCol.add(newObj);
        for (Collection col : collections) {
            Exceptions.expectException(UnsupportedOperationException.class, () -> col.add(newObj));
            Exceptions.expectException(UnsupportedOperationException.class, () -> col.addAll(newObjCol));
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddMethodsForEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet entries = this.cache.entrySet();
        entries.add(TestingUtil.createMapEntry("4", "four"));
    }

    public void testRemoveMethodOfKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet keys = this.cache.keySet();
        keys.remove("1");
        this.assertCacheSize(2);
        CacheCollection values = this.cache.values();
        values.remove("two");
        this.assertCacheSize(1);
        CacheSet entries = this.cache.entrySet();
        entries.remove(TestingUtil.createMapEntry("3", "three"));
        this.assertCacheIsEmpty();
    }

    public void testClearMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet keys = this.cache.keySet();
        keys.clear();
        this.assertCacheIsEmpty();
    }

    public void testClearMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheCollection values = this.cache.values();
        values.clear();
        this.assertCacheIsEmpty();
    }

    public void testClearMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet entries = this.cache.entrySet();
        entries.clear();
        this.assertCacheIsEmpty();
    }

    public void testRemoveAllMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<String> keyCollection = new ArrayList<String>(2);
        keyCollection.add("2");
        keyCollection.add("3");
        CacheSet keys = this.cache.keySet();
        keys.removeAll(keyCollection);
        this.assertCacheSize(1);
    }

    public void testRemoveAllMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<String> valueCollection = new ArrayList<String>(2);
        valueCollection.add("one");
        valueCollection.add("two");
        CacheCollection values = this.cache.values();
        values.removeAll(valueCollection);
        this.assertCacheSize(1);
    }

    public void testRemoveAllMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<Map.Entry<String, String>> entryCollection = new ArrayList<Map.Entry<String, String>>(2);
        entryCollection.add(TestingUtil.createMapEntry("1", "one"));
        entryCollection.add(TestingUtil.createMapEntry("3", "three"));
        CacheSet entries = this.cache.entrySet();
        entries.removeAll(entryCollection);
        this.assertCacheSize(1);
    }

    public void testRetainAllMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<String> keyCollection = new ArrayList<String>(2);
        keyCollection.add("2");
        keyCollection.add("3");
        keyCollection.add("6");
        CacheSet keys = this.cache.keySet();
        keys.retainAll(keyCollection);
        this.assertCacheSize(2);
    }

    public void testRetainAllMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<String> valueCollection = new ArrayList<String>(2);
        valueCollection.add("one");
        valueCollection.add("two");
        valueCollection.add("5");
        CacheCollection values = this.cache.values();
        values.retainAll(valueCollection);
        this.assertCacheSize(2);
    }

    public void testRetainAllMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        ArrayList<Map.Entry<String, String>> entryCollection = new ArrayList<Map.Entry<String, String>>(3);
        entryCollection.add(TestingUtil.createMapEntry("1", "one"));
        entryCollection.add(TestingUtil.createMapEntry("3", "three"));
        entryCollection.add(TestingUtil.createMapEntry("4", "5"));
        CacheSet entries = this.cache.entrySet();
        entries.retainAll(entryCollection);
        this.assertCacheSize(2);
    }

    public void testRemoveIfMethodOfKeyCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet keys = this.cache.keySet();
        keys.removeIf(k -> k.equals("2"));
        this.assertCacheSize(2);
    }

    public void testRemoveIfMethodOfValuesCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheCollection values = this.cache.values();
        values.removeIf(v -> ((String)v).startsWith("t"));
        this.assertCacheSize(1);
    }

    public void testRemoveIfMethodOfEntryCollection() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet entries = this.cache.entrySet();
        entries.removeIf(e -> ((String)e.getValue()).startsWith("t"));
        this.assertCacheSize(1);
    }

    public void testEntrySetValueFromEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet entries = this.cache.entrySet();
        String newObj = "something-else";
        for (Map.Entry entry : entries) {
            entry.setValue(newObj);
        }
        this.assertCacheSize(3);
        AssertJUnit.assertEquals((Object)newObj, (Object)this.cache.get((Object)"1"));
        AssertJUnit.assertEquals((Object)newObj, (Object)this.cache.get((Object)"2"));
        AssertJUnit.assertEquals((Object)newObj, (Object)this.cache.get((Object)"3"));
    }

    public void testKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key1, value1);
        m.put(key2, value2);
        m.put(key3, value3);
        this.cache.putAll(m);
        this.assertCacheSize(3);
        HashSet<String> expKeys = new HashSet<String>();
        expKeys.add(key1);
        expKeys.add(key2);
        expKeys.add(key3);
        HashSet<String> expValues = new HashSet<String>();
        expValues.add(value1);
        expValues.add(value2);
        expValues.add(value3);
        Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
        Set expValueEntries = ObjectDuplicator.duplicateSet(expValues);
        CacheSet keys = this.cache.keySet();
        for (Object key : keys) {
            Assert.assertTrue((boolean)expKeys.remove(key));
        }
        Assert.assertTrue((boolean)expKeys.isEmpty(), (String)("Did not see keys " + String.valueOf(expKeys) + " in iterator!"));
        CacheCollection values = this.cache.values();
        for (Object value : values) {
            Assert.assertTrue((boolean)expValues.remove(value));
        }
        Assert.assertTrue((boolean)expValues.isEmpty(), (String)("Did not see keys " + String.valueOf(expValues) + " in iterator!"));
        CacheSet entries = this.cache.entrySet();
        for (Map.Entry entry : entries) {
            Assert.assertTrue((boolean)expKeyEntries.remove(entry.getKey()));
            Assert.assertTrue((boolean)expValueEntries.remove(entry.getValue()));
        }
        Assert.assertTrue((boolean)expKeyEntries.isEmpty(), (String)("Did not see keys " + String.valueOf(expKeyEntries) + " in iterator!"));
        Assert.assertTrue((boolean)expValueEntries.isEmpty(), (String)("Did not see keys " + String.valueOf(expValueEntries) + " in iterator!"));
    }

    public void testSizeAndContents() {
        String key = "key";
        String value = "value";
        this.assertCacheIsEmpty();
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertFalse((boolean)this.cache.values().contains((Object)value));
        this.cache.put((Object)key, (Object)value);
        this.assertCacheSize(1);
        Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
        Assert.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertTrue((boolean)this.cache.values().contains((Object)value));
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.remove((Object)key));
        Assert.assertTrue((boolean)this.cache.isEmpty());
        this.assertCacheIsEmpty();
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        Assert.assertFalse((boolean)this.cache.keySet().contains((Object)key));
        Assert.assertFalse((boolean)this.cache.values().contains((Object)value));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        AssertJUnit.assertEquals((Object)"one", (Object)this.cache.get((Object)"1"));
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache.get((Object)"2"));
        AssertJUnit.assertEquals((Object)"three", (Object)this.cache.get((Object)"3"));
        this.assertCacheSize(3);
        m = new HashMap();
        m.put("1", "newvalue");
        m.put("4", "four");
        this.cache.putAll(m);
        AssertJUnit.assertEquals((Object)"newvalue", (Object)this.cache.get((Object)"1"));
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache.get((Object)"2"));
        AssertJUnit.assertEquals((Object)"three", (Object)this.cache.get((Object)"3"));
        AssertJUnit.assertEquals((Object)"four", (Object)this.cache.get((Object)"4"));
        this.assertCacheSize(4);
    }

    public void testConcurrentMapMethods() {
        AssertJUnit.assertNull((Object)this.cache.putIfAbsent((Object)"A", (Object)"B"));
        AssertJUnit.assertEquals((Object)"B", (Object)this.cache.putIfAbsent((Object)"A", (Object)"C"));
        AssertJUnit.assertEquals((Object)"B", (Object)this.cache.get((Object)"A"));
        Assert.assertFalse((boolean)this.cache.remove((Object)"A", (Object)"C"));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)"A"));
        Assert.assertTrue((boolean)this.cache.remove((Object)"A", (Object)"B"));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)"A"));
        this.cache.put((Object)"A", (Object)"B");
        Assert.assertFalse((boolean)this.cache.replace((Object)"A", (Object)"D", (Object)"C"));
        AssertJUnit.assertEquals((Object)"B", (Object)this.cache.get((Object)"A"));
        Assert.assertTrue((boolean)this.cache.replace((Object)"A", (Object)"B", (Object)"C"));
        AssertJUnit.assertEquals((Object)"C", (Object)this.cache.get((Object)"A"));
        AssertJUnit.assertEquals((Object)"C", (Object)this.cache.replace((Object)"A", (Object)"X"));
        AssertJUnit.assertNull((Object)this.cache.replace((Object)"X", (Object)"A"));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)"X"));
    }

    public void testPutNullParameters() {
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.put(null, null));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.put((Object)"k", null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.put(null, (Object)"v"));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.putIfAbsent(null, null));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.putIfAbsent((Object)"k", null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.putIfAbsent(null, (Object)"v"));
    }

    public void testReplaceNullParameters() {
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.replace(null, null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.replace(null, (Object)"X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.replace(null, (Object)"X", (Object)"Y"));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.replace((Object)"hello", null, (Object)"X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.replace((Object)"hello", (Object)"X", null));
    }

    public void testRemoveNullParameters() {
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.remove(null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.remove(null, (Object)"X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.remove((Object)"k", null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.remove(null, null));
    }

    public void testComputeNullParameters() {
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.compute(null, (SerializableBiFunction & Serializable)(o, o2) -> "X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null functions are not supported!", () -> this.cache.compute((Object)"k", null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.computeIfAbsent(null, (SerializableFunction & Serializable)o -> "X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null functions are not supported!", () -> this.cache.computeIfAbsent((Object)"k", null));
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.computeIfPresent(null, (SerializableBiFunction & Serializable)(o, o2) -> "X"));
        Exceptions.expectException(NullPointerException.class, (String)"Null functions are not supported!", () -> this.cache.computeIfPresent((Object)"k", null));
    }

    public void testMergeNullParameters() {
        Exceptions.expectException(NullPointerException.class, (String)"Null keys are not supported!", () -> this.cache.merge(null, (Object)"X", (SerializableBiFunction & Serializable)(o, o2) -> "Y"));
        Exceptions.expectException(NullPointerException.class, (String)"Null values are not supported!", () -> this.cache.merge((Object)"k", null, (SerializableBiFunction & Serializable)(o, o2) -> "Y"));
        Exceptions.expectException(NullPointerException.class, (String)"Null functions are not supported!", () -> this.cache.merge((Object)"k", (Object)"X", null));
    }

    public void testPutIfAbsentLockCleanup() {
        TestingUtil.assertNoLocks(this.cache);
        this.cache.put((Object)"key", (Object)"value");
        TestingUtil.assertNoLocks(this.cache);
        this.cache.putForExternalRead((Object)"key", (Object)"value2");
        TestingUtil.assertNoLocks(this.cache);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get((Object)"key"));
    }

    private void assertCacheIsEmpty() {
        this.assertCacheSize(0);
    }

    private void assertCacheSize(int expectedSize) {
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.entrySet().size());
        boolean isEmpty = expectedSize == 0;
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.keySet().isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.values().isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.entrySet().isEmpty());
    }

    public void testGetOrDefault() {
        this.cache.put((Object)"A", (Object)"B");
        AssertJUnit.assertEquals((Object)"K", (Object)this.cache.getOrDefault((Object)"Not there", (Object)"K"));
    }

    public void testMerge() throws Exception {
        this.cache.put((Object)"A", (Object)"B");
        this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(oldValue, newValue) -> String.valueOf(oldValue) + String.valueOf(newValue));
        AssertJUnit.assertEquals((Object)"BC", (Object)this.cache.get((Object)"A"));
        this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(oldValue, newValue) -> null);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)"A"));
        this.cache.merge((Object)"F", (Object)"42", (SerializableBiFunction & Serializable)(oldValue, newValue) -> String.valueOf(oldValue) + String.valueOf(newValue));
        AssertJUnit.assertEquals((Object)"42", (Object)this.cache.get((Object)"F"));
        this.cache.put((Object)"A", (Object)"B");
        RuntimeException mergeRaisedException = new RuntimeException("hi there");
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(k, v) -> {
            throw mergeRaisedException;
        }));
    }

    public void testMergeWithExpirationParameters() {
        BiFunction<Object, Object, String> mappingFunction = (v1, v2) -> String.valueOf(v1) + " " + String.valueOf(v2);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hola guy", (Object)this.cache.merge((Object)"es", (Object)"guy", mappingFunction, 1000000L, TimeUnit.SECONDS));
        CacheEntry entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hola guy", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1000000000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((Object)"hola guy and good bye", (Object)this.cache.merge((Object)"es", (Object)"and good bye", mappingFunction, 1100000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hola guy and good bye", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1100000000L, (long)entry.getLifespan());
    }

    public void testForEach() {
        this.cache.put((Object)"A", (Object)"B");
        this.cache.put((Object)"C", (Object)"D");
        HashSet values = new HashSet();
        BiConsumer<Object, Object> collectKeyValues = (k, v) -> values.add("hello_" + k.toString() + v.toString());
        this.cache.forEach(collectKeyValues);
        AssertJUnit.assertEquals(TestingUtil.setOf("hello_AB", "hello_CD"), values);
    }

    public void testComputeIfAbsent() {
        Function<Object, String> mappingFunction = k -> String.valueOf(k) + " world";
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.computeIfAbsent((Object)"hello", mappingFunction));
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.get((Object)"hello"));
        Function<Object, String> functionAfterPut = k -> String.valueOf(k) + " happy";
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.computeIfAbsent((Object)"hello", functionAfterPut));
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.get((Object)"hello"));
        int cacheSizeBeforeNullValueCompute = this.cache.size();
        Function<Object, String> functionMapsToNull = k -> null;
        AssertJUnit.assertNull((String)"with function mapping to null returns null", (Object)this.cache.computeIfAbsent((Object)"kaixo", functionMapsToNull));
        AssertJUnit.assertNull((String)"the key does not exist", (Object)this.cache.get((Object)"kaixo"));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)this.cache.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        Function<Object, String> functionMapsToException = k -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.computeIfAbsent((Object)"es", functionMapsToException));
    }

    public void testComputeIfAbsentWithExpirationParameters() {
        Function<Object, String> mappingFunction = k -> String.valueOf(k) + " world";
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.computeIfAbsent((Object)"hello", mappingFunction, 1000000L, TimeUnit.SECONDS));
        CacheEntry entry = this.cache.getAdvancedCache().getCacheEntry((Object)"hello");
        AssertJUnit.assertEquals((Object)"hello world", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1000000000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((Object)"hello world", (Object)this.cache.computeIfAbsent((Object)"hello", mappingFunction, 1100000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        entry = this.cache.getAdvancedCache().getCacheEntry((Object)"hello");
        AssertJUnit.assertEquals((Object)"hello world", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1000000000L, (long)entry.getLifespan());
    }

    public void testComputeIfPresent() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.computeIfPresent((Object)"es", mappingFunction));
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, String> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.computeIfPresent((Object)"es", mappingToException));
        BiFunction<Object, Object, String> mappingForNotPresentKey = (k, v) -> "absent_" + String.valueOf(k) + ":" + String.valueOf(v);
        AssertJUnit.assertNull((String)"unexisting key should return null", (Object)this.cache.computeIfPresent((Object)"fr", mappingForNotPresentKey));
        AssertJUnit.assertNull((String)"unexisting key should return null", (Object)this.cache.get((Object)"fr"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)this.cache.computeIfPresent((Object)"es", mappingToNull));
        AssertJUnit.assertNull((String)"the key is removed", (Object)this.cache.get((Object)"es"));
    }

    public void testComputeIfPresentWithExpirationParameters() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.computeIfPresent((Object)"es", mappingFunction, 1000000L, TimeUnit.SECONDS));
        CacheEntry entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1000000000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((Object)"hello_es:hello_es:hola", (Object)this.cache.computeIfPresent((Object)"es", mappingFunction, 1100000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hello_es:hello_es:hola", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1100000000L, (long)entry.getLifespan());
    }

    public void testCompute() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.compute((Object)"es", mappingFunction));
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        BiFunction<Object, Object, String> mappingForNotPresentKey = (k, v) -> "absent_" + String.valueOf(k) + ":" + String.valueOf(v);
        AssertJUnit.assertEquals((Object)"absent_fr:null", (Object)this.cache.compute((Object)"fr", mappingForNotPresentKey));
        AssertJUnit.assertEquals((Object)"absent_fr:null", (Object)this.cache.get((Object)"fr"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)this.cache.compute((Object)"es", mappingToNull));
        AssertJUnit.assertNull((String)"the key is removed", (Object)this.cache.get((Object)"es"));
        int cacheSizeBeforeNullValueCompute = this.cache.size();
        AssertJUnit.assertNull((String)"mapping to null returns null", (Object)this.cache.compute((Object)"eus", mappingToNull));
        AssertJUnit.assertNull((String)"the key does not exist", (Object)this.cache.get((Object)"eus"));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)this.cache.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, String> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.compute((Object)"es", mappingToException));
    }

    public void testComputeWithExpirationParameters() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.compute((Object)"es", mappingFunction, 1000000L, TimeUnit.SECONDS));
        CacheEntry entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1000000000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((Object)"hello_es:hello_es:hola", (Object)this.cache.compute((Object)"es", mappingFunction, 1100000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        entry = this.cache.getAdvancedCache().getCacheEntry((Object)"es");
        AssertJUnit.assertEquals((Object)"hello_es:hello_es:hola", (Object)entry.getValue());
        AssertJUnit.assertEquals((long)1100000000L, (long)entry.getLifespan());
    }

    public void testReplaceAll() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        this.cache.put((Object)"cz", (Object)"ahoj");
        this.cache.replaceAll(mappingFunction);
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        AssertJUnit.assertEquals((Object)"hello_cz:ahoj", (Object)this.cache.get((Object)"cz"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        Exceptions.expectException(NullPointerException.class, () -> this.cache.replaceAll(mappingToNull));
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        AssertJUnit.assertEquals((Object)"hello_cz:ahoj", (Object)this.cache.get((Object)"cz"));
    }

    @DataProvider(name="lockedStreamActuallyLocks")
    public Object[][] lockStreamActuallyLocks() {
        List<BiConsumer> biConsumers = Arrays.asList(NamedLambdas.of((String)"put", (c, e) -> AssertJUnit.assertEquals((Object)("value" + String.valueOf(e.getKey())), (Object)c.put(e.getKey(), (Object)String.valueOf(String.valueOf(e.getValue()) + "-other")))), NamedLambdas.of((String)"functional-command", (c, e) -> {
            FunctionalMap.ReadWriteMap rwMap = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create((AdvancedCache)c.getAdvancedCache()));
            try {
                AssertJUnit.assertEquals((Object)("value" + String.valueOf(e.getKey())), rwMap.eval(e.getKey(), (SerializableFunction & Serializable)view -> {
                    Object prev = view.get();
                    view.set((Object)(String.valueOf(prev) + "-other"), new MetaParam.Writable[0]);
                    return prev;
                }).get());
            }
            catch (InterruptedException | ExecutionException e1) {
                throw new AssertionError((Object)e1);
            }
        }), NamedLambdas.of((String)"put-all", (c, e) -> c.putAll(Collections.singletonMap(e.getKey(), String.valueOf(e.getValue()) + "-other"))), NamedLambdas.of((String)"put-async", (c, e) -> {
            try {
                c.putAsync(e.getKey(), (Object)(String.valueOf(e.getValue()) + "-other")).get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e1) {
                throw new AssertionError((Object)e1);
            }
        }), NamedLambdas.of((String)"compute", (c, e) -> c.compute(e.getKey(), (SerializableBiFunction & Serializable)(k, v) -> String.valueOf(v) + "-other")), NamedLambdas.of((String)"compute-if-present", (c, e) -> c.computeIfPresent(e.getKey(), (SerializableBiFunction & Serializable)(k, v) -> String.valueOf(v) + "-other")), NamedLambdas.of((String)"merge", (c, e) -> c.merge(e.getKey(), (Object)"-other", (SerializableBiFunction & Serializable)(v1, v2) -> String.valueOf(v1) + String.valueOf(v2))));
        return (Object[][])biConsumers.stream().flatMap(consumer -> Stream.of(Boolean.TRUE, Boolean.FALSE).map(bool -> new Object[]{consumer, bool})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="lockedStreamActuallyLocks")
    public void testLockedStreamActuallyLocks(BiConsumer<Cache<Object, Object>, CacheEntry<Object, Object>> consumer, boolean forEachOrInvokeAll) throws Throwable {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)i, (Object)("value" + i));
        }
        CyclicBarrier barrier = new CyclicBarrier(2);
        int key = 4;
        LockedStream stream = this.cache.getAdvancedCache().lockedStream();
        SerializableBiConsumer & Serializable serConsumer = (SerializableBiConsumer & Serializable)(c, e) -> {
            Object innerKey = e.getKey();
            if (innerKey.equals(key)) {
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                    consumer.accept((Cache<Object, Object>)c, (CacheEntry<Object, Object>)e);
                    InfinispanLock lock = TestingUtil.extractComponent(c, LockManager.class).getLock(innerKey);
                    Assert.assertNotNull((Object)lock);
                    AssertJUnit.assertEquals((Object)innerKey, (Object)lock.getLockOwner());
                    barrier.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | BrokenBarrierException | TimeoutException e1) {
                    throw new RuntimeException(e1);
                }
            }
        };
        Future<Void> forEachFuture = this.fork(() -> {
            if (forEachOrInvokeAll) {
                stream.forEach(serConsumer);
            } else {
                stream.invokeAll((SerializableBiFunction & Serializable)(c, e) -> {
                    serConsumer.accept(c, e);
                    return null;
                });
            }
        });
        barrier.await(10L, TimeUnit.SECONDS);
        Future<Object> putFuture = this.fork(() -> this.cache.put((Object)key, (Object)("value" + key + "-new")));
        TestingUtil.assertNotDone(putFuture);
        barrier.await(10L, TimeUnit.SECONDS);
        forEachFuture.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)("value" + key + "-other"), (Object)putFuture.get(10L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((Object)("value" + key + "-new"), (Object)this.cache.get((Object)key));
        LockManager lockManager = TestingUtil.extractComponent(this.cache, LockManager.class);
        AssertJUnit.assertEquals((int)0, (int)lockManager.getNumberOfLocksHeld());
    }

    public void testLockedStreamSetValue() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.cache.put((Object)i, (Object)("value" + i));
        }
        this.cache.getAdvancedCache().lockedStream().forEach((SerializableBiConsumer & Serializable)(c, e) -> e.setValue((Object)(String.valueOf(e.getValue()) + "-changed")));
        for (i = 0; i < 5; ++i) {
            AssertJUnit.assertEquals((Object)("value" + i + "-changed"), (Object)this.cache.get((Object)i));
        }
    }

    public void testLockedStreamWithinLockedStream() {
        this.cache.getAdvancedCache().lockedStream().forEach((SerializableBiConsumer & Serializable)(c, e) -> Exceptions.expectException(IllegalArgumentException.class, () -> c.getAdvancedCache().lockedStream()));
    }

    private <R> void assertLockStreamInvokeAll(LockedStream<Object, Object> lockedStream, SerializableBiFunction<Cache<Object, Object>, CacheEntry<Object, Object>, R> biFunction, Map<Object, R> expectedResults) {
        Map results = lockedStream.invokeAll(biFunction);
        AssertJUnit.assertEquals(expectedResults, (Object)results);
    }

    public void testLockedStreamInvokeAllPut() {
        int i;
        HashMap<CallSite, CallSite> original = new HashMap<CallSite, CallSite>();
        int insertedAmount = 5;
        for (i = 0; i < insertedAmount; ++i) {
            original.put((CallSite)((Object)("key-" + i)), (CallSite)((Object)("value-" + i)));
        }
        this.cache.putAll(original);
        this.assertLockStreamInvokeAll((LockedStream<Object, Object>)this.cache.getAdvancedCache().lockedStream(), (SerializableBiFunction & Serializable)(c, e) -> c.put(e.getKey(), (Object)(String.valueOf(e.getValue()) + "-updated")), original);
        for (i = 0; i < insertedAmount; ++i) {
            AssertJUnit.assertEquals((Object)("value-" + i + "-updated"), (Object)this.cache.get((Object)("key-" + i)));
        }
    }

    public void testLockedStreamInvokeAllFilteredSet() {
        int i;
        HashMap<CallSite, CallSite> original = new HashMap<CallSite, CallSite>();
        int insertedAmount = 5;
        for (i = 0; i < insertedAmount; ++i) {
            original.put((CallSite)((Object)("key-" + i)), (CallSite)((Object)("value-" + i)));
        }
        this.cache.putAll(original);
        this.assertLockStreamInvokeAll((LockedStream<Object, Object>)this.cache.getAdvancedCache().lockedStream().filter((SerializablePredicate & Serializable)e -> e.getKey().toString().contains("3")), (SerializableBiFunction & Serializable)(c, e) -> c.put(e.getKey(), (Object)(String.valueOf(e.getValue()) + "-updated")), Collections.singletonMap("key-3", "value-3"));
        for (i = 0; i < insertedAmount; ++i) {
            AssertJUnit.assertEquals((Object)("value-" + i + (i == 3 ? "-updated" : "")), (Object)this.cache.get((Object)("key-" + i)));
        }
    }
}

