/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.irac.ControlledExponentialBackOff;
import org.infinispan.xsite.irac.ControlledTransport;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyChangedState;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.jgroups.UnreachableException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.Irac3SitesExponentialBackOffTest")
public class Irac3SitesExponentialBackOffTest
extends AbstractMultipleSitesTest {
    private static final int N_SITES = 3;
    private static final int CLUSTER_SIZE = 1;
    private static final Supplier<Throwable> NO_EXCEPTION = () -> null;
    private final Map<String, ControlledExponentialBackOff> backOffMap = new ConcurrentHashMap<String, ControlledExponentialBackOff>();
    private volatile ControlledTransport transport;

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = Irac3SitesExponentialBackOffTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        for (int i = 0; i < 3; ++i) {
            if (i == siteIndex) continue;
            builder.sites().addBackup().site(this.siteName(i)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        return builder;
    }

    @Override
    protected int defaultNumberOfSites() {
        return 3;
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected void afterSitesCreated() {
        Cache c = this.cache(this.siteName(0), 0);
        List<String> connected = Arrays.asList(this.siteName(0), this.siteName(1));
        List<String> disconnected = Collections.singletonList(this.siteName(2));
        this.transport = TestingUtil.wrapGlobalComponent((CacheContainer)this.manager(c), Transport.class, actual -> new ControlledTransport((Transport)actual, this.siteName(0), (Collection<String>)connected, (Collection<String>)disconnected), true);
        DefaultIracManager iracManager = (DefaultIracManager)TestingUtil.extractComponent(c, IracManager.class);
        iracManager.setBackOff(backup -> this.backOffMap.computeIfAbsent(backup.getSiteName(), ControlledExponentialBackOff::new));
    }

    @AfterMethod(alwaysRun=true)
    public void resetStateAfterTest() {
        this.backOffMap.values().forEach(ControlledExponentialBackOff::release);
        Cache c = this.cache(this.siteName(0), 0);
        DefaultIracManager iracManager = (DefaultIracManager)TestingUtil.extractComponent(c, IracManager.class);
        Irac3SitesExponentialBackOffTest.eventually(() -> ((DefaultIracManager)iracManager).isEmpty());
        this.backOffMap.values().forEach(ControlledExponentialBackOff::cleanupEvents);
        this.backOffMap.values().forEach(ControlledExponentialBackOff::assertNoEvents);
    }

    public void testSimulatedTimeout(Method method) {
        this.doTest(method, () -> log.requestTimedOut(1L, this.siteName(2), "some time"));
    }

    public void testSimulatedUnreachableException(Method method) {
        this.doTest(method, () -> new UnreachableException(null));
    }

    public void testSiteUnreachable(Method method) {
        this.doTest(method, () -> log.remoteNodeSuspected(null));
    }

    public void testNoBackoffOnOtherException(Method method) {
        this.transport.throwableSupplier = CacheException::new;
        Cache c = this.cache(this.siteName(0), 0);
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        c.put((Object)key, (Object)value);
        this.backOffMap.get(this.siteName(1)).eventually("Both reset with CacheException.", ControlledExponentialBackOff.Event.RESET);
        this.backOffMap.get(this.siteName(2)).eventually("Both reset with CacheException.", ControlledExponentialBackOff.Event.RESET);
        this.transport.throwableSupplier = NO_EXCEPTION;
        DefaultIracManager iracManager = (DefaultIracManager)TestingUtil.extractComponent(c, IracManager.class);
        Irac3SitesExponentialBackOffTest.eventually(() -> ((DefaultIracManager)iracManager).isEmpty());
        this.backOffMap.get(this.siteName(1)).assertNoEvents();
        this.backOffMap.get(this.siteName(2)).containsOnly("Only one that failed reset.", ControlledExponentialBackOff.Event.RESET);
        this.backOffMap.values().forEach(ControlledExponentialBackOff::assertNoEvents);
    }

    private void doTest(Method method, Supplier<Throwable> throwableSupplier) {
        Cache c = this.cache(this.siteName(0), 0);
        this.transport.throwableSupplier = throwableSupplier;
        String key = TestingUtil.k(method);
        String value = TestingUtil.v(method);
        c.put((Object)key, (Object)value);
        this.backOffMap.get(this.siteName(1)).eventually("Backoff event on first try.", ControlledExponentialBackOff.Event.RESET);
        this.backOffMap.get(this.siteName(2)).eventually("Backoff event on first try.", ControlledExponentialBackOff.Event.BACK_OFF);
        this.backOffMap.get(this.siteName(2)).release();
        this.backOffMap.get(this.siteName(1)).assertNoEvents();
        this.backOffMap.get(this.siteName(2)).eventually("Backoff event after release.", ControlledExponentialBackOff.Event.BACK_OFF);
        this.backOffMap.get(this.siteName(2)).assertNoEvents();
        this.assertKeysEnterRetry(c);
        this.transport.throwableSupplier = NO_EXCEPTION;
        this.backOffMap.get(this.siteName(2)).release();
        this.backOffMap.get(this.siteName(2)).eventually("All operations should succeed.", ControlledExponentialBackOff.Event.RESET);
        this.backOffMap.values().forEach(ControlledExponentialBackOff::assertNoEvents);
    }

    private void assertKeysEnterRetry(Cache<?, ?> c) {
        DefaultIracManager dim = (DefaultIracManager)TestingUtil.extractComponent(c, IracManager.class);
        Map keys = (Map)TestingUtil.extractField(dim, "updatedKeys");
        ((MapAssert)Assertions.assertThat((Map)keys).withFailMessage("Wrong size: " + String.valueOf(keys), new Object[0])).hasSize(1);
        Predicate<IracManagerKeyState> predicate = state -> {
            IracManagerKeyChangedState.Status status = (IracManagerKeyChangedState.Status)TestingUtil.extractField(state, "status");
            return status == IracManagerKeyChangedState.Status.READY;
        };
        Irac3SitesExponentialBackOffTest.eventually(() -> keys.values().stream().allMatch(predicate));
    }
}

