/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NotifierLatch {
    private static final Log log = LogFactory.getLog(NotifierLatch.class);
    private final String name;
    private boolean enabled = false;
    private boolean blocked = false;
    private int disableOnUnblock = 0;

    public NotifierLatch(String name) {
        this.name = name;
    }

    public final synchronized void startBlocking() {
        log.tracef("Start blocking %s", (Object)this.name);
        this.enabled = true;
    }

    public final synchronized void stopBlocking() {
        log.tracef("Stop blocking %s", (Object)this.name);
        this.enabled = false;
        this.disableOnUnblock = 0;
        this.notifyAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void blockIfNeeded() {
        log.tracef("Blocking on %s", (Object)this.name);
        this.blocked = true;
        this.notifyAll();
        try {
            while (this.enabled) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.blocked = false;
                    if (this.disableOnUnblock > 0 && --this.disableOnUnblock == 0) {
                        this.enabled = true;
                    }
                    log.tracef("Resuming on %s", (Object)this.name);
                    return;
                }
            }
        }
        finally {
            this.blocked = false;
            if (this.disableOnUnblock > 0 && --this.disableOnUnblock == 0) {
                this.enabled = true;
            }
            log.tracef("Resuming on %s", (Object)this.name);
        }
    }

    public final synchronized void waitToBlock() throws InterruptedException {
        log.tracef("Waiting for another thread to block on %s", (Object)this.name);
        while (!this.blocked) {
            this.wait();
        }
    }

    public synchronized void unblockOnce() {
        log.tracef("Unblocking once %s", (Object)this.name);
        this.enabled = false;
        ++this.disableOnUnblock;
        this.notifyAll();
    }

    public void waitToBlockAndUnblockOnce() throws InterruptedException {
        this.waitToBlock();
        this.unblockOnce();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NotifierLatch{");
        sb.append("enabled=").append(this.enabled);
        sb.append(", blocked=").append(this.blocked);
        sb.append(", disableOnUnblock=").append(this.disableOnUnblock);
        sb.append('}');
        return sb.toString();
    }
}

