/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.EmbeddedTimeService;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="util.EmbeddedTimeServiceTest")
public class EmbeddedTimeServiceTest {
    public void testMonotonicIncrement() {
        TimeService timeService = AbstractInfinispanTest.TIME_SERVICE;
        Assert.assertTrue((timeService.time() <= timeService.time() ? 1 : 0) != 0);
        Assert.assertTrue((timeService.wallClockTime() <= timeService.wallClockTime() ? 1 : 0) != 0);
    }

    public void testDuration() {
        EmbeddedTimeService timeService = new EmbeddedTimeService(){

            public long time() {
                return 10L;
            }

            public long wallClockTime() {
                return 10L;
            }
        };
        Assert.assertEquals((long)timeService.timeDuration(0L, TimeUnit.NANOSECONDS), (long)10L);
        Assert.assertEquals((long)timeService.timeDuration(-1L, TimeUnit.NANOSECONDS), (long)11L);
        Assert.assertEquals((long)timeService.timeDuration(10L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(11L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(9L, TimeUnit.NANOSECONDS), (long)1L);
        Assert.assertEquals((long)timeService.timeDuration(9L, TimeUnit.MICROSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(9L, TimeUnit.MILLISECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(0L, 1L, TimeUnit.NANOSECONDS), (long)1L);
        Assert.assertEquals((long)timeService.timeDuration(0L, -1L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(1L, 0L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(1L, -1L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(-1L, -1L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(0L, 0L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.timeDuration(0L, 1000L, TimeUnit.MICROSECONDS), (long)1L);
        Assert.assertEquals((long)timeService.timeDuration(0L, 1000000L, TimeUnit.MILLISECONDS), (long)1L);
    }

    public void testExpired() {
        EmbeddedTimeService timeService = new EmbeddedTimeService(){

            public long time() {
                return 10L;
            }
        };
        Assert.assertTrue((boolean)timeService.isTimeExpired(-1L));
        Assert.assertTrue((boolean)timeService.isTimeExpired(0L));
        Assert.assertTrue((boolean)timeService.isTimeExpired(9L));
        Assert.assertTrue((boolean)timeService.isTimeExpired(10L));
        Assert.assertFalse((boolean)timeService.isTimeExpired(11L));
    }

    public void testRemainingTime() {
        EmbeddedTimeService timeService = new EmbeddedTimeService(){

            public long time() {
                return 10L;
            }
        };
        Assert.assertEquals((long)timeService.remainingTime(-1L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.remainingTime(0L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.remainingTime(9L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.remainingTime(10L, TimeUnit.NANOSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.remainingTime(11L, TimeUnit.NANOSECONDS), (long)1L);
        Assert.assertEquals((long)timeService.remainingTime(11L, TimeUnit.MICROSECONDS), (long)0L);
        Assert.assertEquals((long)timeService.remainingTime(11L, TimeUnit.MILLISECONDS), (long)0L);
    }

    public void testExpectedTime() {
        EmbeddedTimeService timeService = new EmbeddedTimeService(){

            public long time() {
                return 10L;
            }

            public long wallClockTime() {
                return 10L;
            }
        };
        Assert.assertEquals((long)timeService.expectedEndTime(-1L, TimeUnit.NANOSECONDS), (long)10L);
        Assert.assertEquals((long)timeService.expectedEndTime(0L, TimeUnit.NANOSECONDS), (long)10L);
        Assert.assertEquals((long)timeService.expectedEndTime(1L, TimeUnit.NANOSECONDS), (long)11L);
        Assert.assertEquals((long)timeService.expectedEndTime(9L, TimeUnit.NANOSECONDS), (long)19L);
        Assert.assertEquals((long)timeService.expectedEndTime(10L, TimeUnit.NANOSECONDS), (long)20L);
        Assert.assertEquals((long)timeService.expectedEndTime(11L, TimeUnit.NANOSECONDS), (long)21L);
        Assert.assertEquals((long)timeService.expectedEndTime(11L, TimeUnit.MICROSECONDS), (long)11010L);
        Assert.assertEquals((long)timeService.expectedEndTime(11L, TimeUnit.MILLISECONDS), (long)11000010L);
    }
}

