/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tx.recovery.RecoveryWithDefaultCacheDistTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryWithCustomCacheDistTest")
public class RecoveryWithCustomCacheDistTest
extends RecoveryWithDefaultCacheDistTest {
    private static final String CUSTOM_CACHE = "customCache";
    private ConfigurationBuilder recoveryCacheConfig;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configuration = super.configure();
        this.configuration.transaction().recovery().recoveryInfoCacheName(CUSTOM_CACHE);
        this.recoveryCacheConfig = RecoveryWithCustomCacheDistTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        this.recoveryCacheConfig.transaction().transactionManagerLookup(null);
        this.recoveryCacheConfig.transaction().recovery().disable();
        this.startCacheManager();
        this.startCacheManager();
        this.manager(0).startCaches(new String[]{this.getDefaultCacheName(), CUSTOM_CACHE});
        this.manager(1).startCaches(new String[]{this.getDefaultCacheName(), CUSTOM_CACHE});
        this.waitForClusterToForm(CUSTOM_CACHE);
        assert (this.manager(0).getCacheNames().contains(CUSTOM_CACHE));
        assert (this.manager(1).getCacheNames().contains(CUSTOM_CACHE));
    }

    @Override
    protected String getRecoveryCacheName() {
        return CUSTOM_CACHE;
    }

    @Override
    protected void startCacheManager() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().clusteredDefault().defaultCacheName(this.getDefaultCacheName());
        holder.getNamedConfigurationBuilders().put(this.getDefaultCacheName(), this.configuration);
        holder.getNamedConfigurationBuilders().put(CUSTOM_CACHE, this.recoveryCacheConfig);
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(holder)});
    }
}

