/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TxListenerInvocationSequenceTest")
public class TxListenerInvocationSequenceTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheConfig = TxListenerInvocationSequenceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.createClusteredCaches(2, cacheConfig);
        this.waitForClusterToForm();
    }

    public void testSameInvokingSequence() {
        TxListener l0 = new TxListener(0);
        this.cache(0).addListener((Object)l0);
        TxListener l1 = new TxListener(1);
        this.cache(1).addListener((Object)l1);
        this.cache(0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals(l0.log, l1.log);
        AssertJUnit.assertEquals(l0.log, Arrays.asList(TxEvent.STARTED, TxEvent.CREATED, TxEvent.COMPLETED));
    }

    @Listener
    public static class TxListener {
        int cacheIndex;
        List<TxEvent> log = new ArrayList<TxEvent>(3);

        public TxListener(int cacheIndex) {
            this.cacheIndex = cacheIndex;
        }

        @TransactionRegistered
        public void startTx(TransactionRegisteredEvent tre) {
            if (!tre.isPre()) {
                this.log.add(TxEvent.STARTED);
            }
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryCreatedEvent cec) {
            if (cec.isPre()) {
                this.log.add(TxEvent.CREATED);
            }
        }

        @TransactionCompleted
        public void txCompleted(TransactionCompletedEvent tce) {
            if (!tce.isPre()) {
                this.log.add(TxEvent.COMPLETED);
            }
        }
    }

    static enum TxEvent {
        STARTED,
        CREATED,
        COMPLETED;

    }
}

