/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import io.reactivex.rxjava3.core.Flowable;
import jakarta.transaction.TransactionManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.jdkspecific.CallerId;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.TestComponentAccessors;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.marshall.persistence.impl.PersistenceMarshallerImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.support.DelegatingNonBlockingStore;
import org.infinispan.persistence.support.DelegatingPersistenceManager;
import org.infinispan.persistence.support.NonBlockingStoreAdapter;
import org.infinispan.persistence.support.SegmentPublisherWrapper;
import org.infinispan.persistence.support.SingleSegmentPublisher;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GroupPrincipal;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.SecureCacheImpl;
import org.infinispan.statetransfer.StateTransferManagerImpl;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.DELAY;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;

public class TestingUtil {
    private static final Log log = LogFactory.getLog(TestingUtil.class);
    private static final Random random = new Random();
    private static final int SHORT_TIMEOUT_MILLIS = Integer.getInteger("infinispan.test.shortTimeoutMillis", 500);
    private static final ScheduledExecutorService timeoutExecutor;

    public static void assertNotDone(CompletionStage<?> completionStage) {
        TestingUtil.sleepThread(50L);
        AssertJUnit.assertFalse((boolean)completionStage.toCompletableFuture().isDone());
    }

    public static void assertNotDone(Future<?> completionStage) {
        TestingUtil.sleepThread(50L);
        AssertJUnit.assertFalse((boolean)completionStage.isDone());
    }

    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> f, long timeout, TimeUnit timeUnit, Executor executor) {
        ScheduledFuture<?> scheduled = timeoutExecutor.schedule(() -> executor.execute(() -> f.completeExceptionally(new TimeoutException("Timed out!"))), timeout, timeUnit);
        f.whenComplete((v, t) -> scheduled.cancel(false));
        return f;
    }

    public static <T> CompletionStage<T> startAsync(Callable<CompletionStage<T>> action, Executor executor) {
        return CompletableFutures.completedNull().thenComposeAsync(ignored -> (CompletionStage)Exceptions.unchecked((Callable)action), executor);
    }

    public static <T> CompletionStage<T> sequence(CompletionStage<?> first, Callable<CompletionStage<T>> second) {
        return first.thenCompose(ignored -> (CompletionStage)Exceptions.unchecked((Callable)second));
    }

    public static <T> CompletionStage<T> sequenceAsync(CompletionStage<?> first, Callable<CompletionStage<T>> second, Executor executor) {
        return first.thenComposeAsync(ignored -> (CompletionStage)Exceptions.unchecked((Callable)second), executor);
    }

    public static <T> T join(CompletionStage<? extends T> stage) throws ExecutionException, InterruptedException, java.util.concurrent.TimeoutException {
        return stage.toCompletableFuture().get(10L, TimeUnit.SECONDS);
    }

    public static long shortTimeoutMillis() {
        return SHORT_TIMEOUT_MILLIS;
    }

    public static void crashCacheManagers(EmbeddedCacheManager ... cacheManagers) {
        for (EmbeddedCacheManager cm : cacheManagers) {
            JChannel channel = TestingUtil.extractJChannel(cm);
            try {
                DISCARD discard = new DISCARD();
                discard.discardAll(true);
                channel.getProtocolStack().insertProtocol((Protocol)discard, ProtocolStack.Position.ABOVE, TP.class);
            }
            catch (Exception e) {
                log.warn((Object)"Problems inserting discard", (Throwable)e);
                throw new RuntimeException(e);
            }
            View view = View.create((Address)channel.getAddress(), (long)100L, (Address[])new Address[]{channel.getAddress()});
            ((GMS)channel.getProtocolStack().findProtocol(GMS.class)).installView(view);
        }
        TestingUtil.killCacheManagers(cacheManagers);
    }

    public static void installNewView(EmbeddedCacheManager ... members) {
        TestingUtil.installNewView(Stream.of(members).map(EmbeddedCacheManager::getAddress), members);
    }

    public static void installNewView(Function<EmbeddedCacheManager, JChannel> channelRetriever, EmbeddedCacheManager ... members) {
        TestingUtil.installNewView(Stream.of(members).map(EmbeddedCacheManager::getAddress), channelRetriever, members);
    }

    public static void installNewView(Stream<org.infinispan.remoting.transport.Address> members, EmbeddedCacheManager ... where) {
        TestingUtil.installNewView(members, TestingUtil::extractJChannel, where);
    }

    public static JChannel extractJChannel(EmbeddedCacheManager ecm) {
        Transport transport = TestingUtil.extractGlobalComponent((CacheContainer)ecm, Transport.class);
        while (!(transport instanceof JGroupsTransport)) {
            if (Proxy.isProxyClass(transport.getClass())) {
                transport = (Transport)TestingUtil.extractField(TestingUtil.extractField(transport, "h"), "wrappedInstance");
                continue;
            }
            if (transport instanceof AbstractDelegatingTransport) {
                transport = ((AbstractDelegatingTransport)transport).getDelegate();
                continue;
            }
            throw new IllegalStateException("Unable to obtain a JGroupsTransport instance from " + String.valueOf(transport) + " on " + String.valueOf(ecm.getAddress()));
        }
        return ((JGroupsTransport)transport).getChannel();
    }

    public static void installNewView(Stream<org.infinispan.remoting.transport.Address> members, Function<EmbeddedCacheManager, JChannel> channelRetriever, EmbeddedCacheManager ... where) {
        List<Address> viewMembers = members.map(a -> ((JGroupsAddress)a).getJGroupsAddress()).collect(Collectors.toList());
        ArrayList<View> previousViews = new ArrayList<View>(where.length);
        MutableDigest digest = new MutableDigest(viewMembers.toArray(new Address[0]));
        for (EmbeddedCacheManager ecm : where) {
            GMS gms = (GMS)channelRetriever.apply(ecm).getProtocolStack().findProtocol(GMS.class);
            previousViews.add(gms.view());
            digest.merge(gms.getDigest());
        }
        long viewId = previousViews.stream().mapToLong(view -> view.getViewId().getId()).max().orElse(0L) + 1L;
        Object newView = previousViews.stream().allMatch(view -> view.getMembers().containsAll(viewMembers)) ? View.create((Address)((Address)viewMembers.get(0)), (long)viewId, (Address[])viewMembers.toArray(new Address[0])) : new MergeView(new ViewId((Address)viewMembers.get(0), viewId), viewMembers, previousViews);
        log.trace((Object)("Before installing new view:" + String.valueOf(viewMembers)));
        for (EmbeddedCacheManager ecm : where) {
            ((GMS)channelRetriever.apply(ecm).getProtocolStack().findProtocol(GMS.class)).installView(newView, (Digest)digest);
        }
    }

    public static String wrapXMLWithSchema(String schema, String xml) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<infinispan xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("xsi:schemaLocation=\"urn:infinispan:config:");
        sb.append(schema);
        sb.append(" https://infinispan.org/schemas/infinispan-config-");
        sb.append(schema);
        sb.append(".xsd\" xmlns=\"urn:infinispan:config:");
        sb.append(schema);
        sb.append("\">\n");
        sb.append(xml);
        sb.append("</infinispan>");
        return sb.toString();
    }

    public static String wrapXMLWithSchema(String xml) {
        return TestingUtil.wrapXMLWithSchema(Version.getSchemaVersion(), xml);
    }

    public static String wrapXMLWithoutSchema(String xml) {
        StringBuilder sb = new StringBuilder();
        sb.append("<infinispan>\n");
        sb.append(xml);
        sb.append("</infinispan>");
        return sb.toString();
    }

    public static <T> T extractField(Object target, String fieldName) {
        return TestingUtil.extractField(target.getClass(), target, fieldName);
    }

    public static void replaceField(Object newValue, String fieldName, Object owner, Class<?> baseType) {
        try {
            Field field = baseType.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(owner, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void replaceField(Object owner, String fieldName, Function<T, T> func) {
        TestingUtil.replaceField(owner.getClass(), owner, fieldName, func);
    }

    public static <T> void replaceField(Class<?> baseType, Object owner, String fieldName, Function<T, T> func) {
        try {
            Field field = baseType.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object prevValue = field.get(owner);
            T newValue = func.apply(prevValue);
            field.set(owner, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T extractField(Class<?> type, Object target, String fieldName) {
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(target);
            }
            catch (Exception e) {
                if (type == Object.class) {
                    throw new RuntimeException(e);
                }
                type = type.getSuperclass();
                continue;
            }
            break;
        }
    }

    public static <T extends AsyncInterceptor> T findInterceptor(Cache<?, ?> cache, Class<T> interceptorToFind) {
        return (T)TestingUtil.extractInterceptorChain(cache).findInterceptorExtending(interceptorToFind);
    }

    public static int getSegmentForKey(Object key, Cache<?, ?> cache) {
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        return keyPartitioner.getSegment(key);
    }

    public static void waitForNoRebalance(Cache ... caches) {
        int REBALANCE_TIMEOUT_SECONDS = 60;
        long giveup = System.nanoTime() + TimeUnit.SECONDS.toNanos(60L);
        int zeroCapacityCaches = 0;
        for (Cache cache : caches) {
            if (cache.getCacheConfiguration().clustering().hash().capacityFactor() != 0.0f && !cache.getCacheManager().getCacheManagerConfiguration().isZeroCapacityNode()) continue;
            ++zeroCapacityCaches;
        }
        for (Cache cache : caches) {
            LocalizedCacheTopology cacheTopology;
            Cache<?, ?> cache2 = TestingUtil.unwrapSecureCache(cache);
            int numOwners = cache2.getCacheConfiguration().clustering().hash().numOwners();
            DistributionManager distributionManager = cache2.getAdvancedCache().getDistributionManager();
            org.infinispan.remoting.transport.Address cacheAddress = cache2.getAdvancedCache().getRpcManager().getAddress();
            while (true) {
                boolean currentChIsBalanced;
                boolean chContainsAllMembers;
                boolean rebalanceInProgress;
                if ((cacheTopology = distributionManager.getCacheTopology()) != null) {
                    rebalanceInProgress = cacheTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE;
                    ConsistentHash currentCH = cacheTopology.getCurrentCH();
                    ConsistentHashFactory chf = StateTransferManagerImpl.pickConsistentHashFactory((GlobalConfiguration)TestingUtil.extractGlobalConfiguration(cache2.getCacheManager()), (Configuration)cache2.getCacheConfiguration());
                    chContainsAllMembers = currentCH.getMembers().size() == caches.length;
                    currentChIsBalanced = true;
                    int actualNumOwners = Math.min(numOwners, currentCH.getMembers().size() - zeroCapacityCaches);
                    for (int i = 0; i < currentCH.getNumSegments(); ++i) {
                        if (currentCH.locateOwnersForSegment(i).size() >= actualNumOwners) continue;
                        currentChIsBalanced = false;
                        break;
                    }
                    if (chContainsAllMembers && !rebalanceInProgress && cacheTopology.getTopologyId() > 1) {
                        boolean bl = rebalanceInProgress = !chf.rebalance(currentCH).equals((Object)currentCH);
                    }
                    if (chContainsAllMembers && !rebalanceInProgress && currentChIsBalanced) {
                        break;
                    }
                } else {
                    rebalanceInProgress = false;
                    chContainsAllMembers = false;
                    currentChIsBalanced = true;
                }
                if (System.nanoTime() - giveup > 0L) {
                    String message;
                    if (!chContainsAllMembers) {
                        Object[] addresses = new org.infinispan.remoting.transport.Address[caches.length];
                        for (int i = 0; i < caches.length; ++i) {
                            addresses[i] = caches[i].getCacheManager().getAddress();
                        }
                        message = String.format("Cache %s timed out waiting for rebalancing to complete on node %s, expected member list is %s, current member list is %s!", cache2.getName(), cacheAddress, Arrays.toString(addresses), cacheTopology == null ? "N/A" : cacheTopology.getCurrentCH().getMembers());
                    } else {
                        message = String.format("Cache %s timed out waiting for rebalancing to complete on node %s, current topology is %s. rebalanceInProgress=%s, currentChIsBalanced=%s", cache2.getName(), cache2.getCacheManager().getAddress(), cacheTopology, rebalanceInProgress, currentChIsBalanced);
                    }
                    log.error((Object)message);
                    throw new RuntimeException(message);
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
            log.trace((Object)("Node " + String.valueOf(cacheAddress) + " finished state transfer, has topology " + String.valueOf(cacheTopology)));
        }
    }

    public static void waitForNoRebalanceAcrossManagers(EmbeddedCacheManager ... managers) {
        int numberOfManagers = managers.length;
        assert (numberOfManagers > 0);
        Set<String> testCaches = TestingUtil.getInternalAndUserCacheNames(managers[0]);
        log.debugf("waitForNoRebalance with managers %s, for caches %s", (Object)Arrays.toString(managers), testCaches);
        for (String cacheName : testCaches) {
            ArrayList<Cache> caches = new ArrayList<Cache>(numberOfManagers);
            for (EmbeddedCacheManager manager : managers) {
                Cache cache = manager.getCache(cacheName, false);
                if (cache == null) continue;
                caches.add(cache);
            }
            TestingUtil.waitForNoRebalance(caches.toArray(new Cache[0]));
        }
    }

    public static Set<String> getInternalAndUserCacheNames(EmbeddedCacheManager cacheManager) {
        HashSet<String> testCaches = new HashSet<String>(cacheManager.getCacheNames());
        testCaches.addAll(TestingUtil.getInternalCacheNames((CacheContainer)cacheManager));
        return testCaches;
    }

    public static Set<String> getInternalCacheNames(CacheContainer container) {
        return ((InternalCacheRegistry)TestingUtil.extractGlobalComponentRegistry(container).getComponent(InternalCacheRegistry.class)).getInternalCacheNames();
    }

    public static void waitForTopologyPhase(List<org.infinispan.remoting.transport.Address> expectedMembers, CacheTopology.Phase phase, Cache<?, ?> ... caches) {
        int TOPOLOGY_TIMEOUT_SECONDS = 60;
        long giveup = System.nanoTime() + TimeUnit.SECONDS.toNanos(60L);
        block0: for (Cache<?, ?> c : caches) {
            c = TestingUtil.unwrapSecureCache(c);
            DistributionManager distributionManager = c.getAdvancedCache().getDistributionManager();
            while (true) {
                boolean isCorrectPhase;
                LocalizedCacheTopology cacheTopology;
                boolean allMembersExist = (cacheTopology = distributionManager.getCacheTopology()) != null && cacheTopology.getMembers().containsAll(expectedMembers);
                boolean bl = isCorrectPhase = cacheTopology != null && cacheTopology.getPhase() == phase;
                if (allMembersExist && isCorrectPhase) continue block0;
                if (System.nanoTime() - giveup > 0L) {
                    String message = String.format("Timed out waiting for a CacheTopology to be installed with members %s and phase %s. Current topology=%s", expectedMembers, phase, cacheTopology);
                    log.error((Object)message);
                    throw new RuntimeException(message);
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
        }
    }

    private static Cache<?, ?> unwrapSecureCache(Cache<?, ?> c) {
        if (c instanceof SecureCacheImpl) {
            c = (Cache)TestingUtil.extractField(SecureCacheImpl.class, c, "delegate");
        }
        return c;
    }

    public static void waitForNoRebalance(Collection<? extends Cache> caches) {
        TestingUtil.waitForNoRebalance(caches.toArray(new Cache[0]));
    }

    public static void blockUntilViewsReceived(Cache<?, ?>[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    private static void viewsTimedOut(Cache<?, ?>[] caches) {
        CacheContainer[] cacheContainers = new CacheContainer[caches.length];
        for (int i = 0; i < caches.length; ++i) {
            cacheContainers[i] = caches[i].getCacheManager();
        }
        TestingUtil.viewsTimedOut(cacheContainers);
    }

    private static void viewsTimedOut(CacheContainer[] cacheContainers) {
        int length = cacheContainers.length;
        ArrayList<View> incompleteViews = new ArrayList<View>(length);
        for (CacheContainer cacheContainer : cacheContainers) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)cacheContainer;
            if (cm.getMembers().size() == cacheContainers.length) continue;
            incompleteViews.add(TestingUtil.extractJChannel(cm).getView());
            log.warnf("Manager %s has an incomplete view: %s", (Object)cm.getAddress(), (Object)cm.getMembers());
        }
        throw new TimeoutException(String.format("Timed out before caches had complete views.  Expected %d members in each view.  Views are as follows: %s", cacheContainers.length, incompleteViews));
    }

    public static void blockUntilViewsReceivedInt(Cache<?, ?>[] caches, long timeout) throws InterruptedException {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThreadInt(100L, null);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    public static void blockUntilViewsReceived(long timeout, Cache<?, ?> ... caches) {
        TestingUtil.blockUntilViewsReceived(caches, timeout);
    }

    public static void blockUntilViewsReceivedInt(long timeout, Cache<?, ?> ... caches) throws InterruptedException {
        TestingUtil.blockUntilViewsReceivedInt(caches, timeout);
    }

    public static void blockUntilViewsReceived(long timeout, CacheContainer ... cacheContainers) {
        TestingUtil.blockUntilViewsReceived(timeout, true, cacheContainers);
    }

    public static void blockForMemberToFail(long timeout, CacheContainer ... cacheContainers) {
        TestingUtil.blockUntilViewsReceived(timeout, false, cacheContainers);
        TestingUtil.areCacheViewsComplete(true, cacheContainers);
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, CacheContainer ... cacheContainers) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            if (TestingUtil.areCacheViewsComplete(barfIfTooManyMembers, cacheContainers)) {
                return;
            }
            TestingUtil.sleepThread(100L);
        }
        TestingUtil.viewsTimedOut(cacheContainers);
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, Cache<?, ?> ... caches) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches, barfIfTooManyMembers)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    public static void blockUntilViewReceived(Cache<?, ?> cache, int groupSize, long timeout) {
        TestingUtil.blockUntilViewReceived(cache, groupSize, timeout, true);
    }

    public static void blockUntilViewReceived(Cache<?, ?> cache, int groupSize) {
        TestingUtil.blockUntilViewReceived(cache, groupSize, 10000L, true);
    }

    public static void blockUntilViewReceived(Cache<?, ?> cache, int groupSize, long timeout, boolean barfIfTooManyMembersInView) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            if (!TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), groupSize, barfIfTooManyMembersInView)) continue;
            return;
        }
        throw new RuntimeException(String.format("Timed out before cache had %d members.  View is %s", groupSize, cache.getCacheManager().getMembers()));
    }

    public static boolean areCacheViewsComplete(Cache<?, ?>[] caches) {
        return TestingUtil.areCacheViewsComplete(caches, true);
    }

    public static boolean areCacheViewsComplete(Cache<?, ?>[] caches, boolean barfIfTooManyMembers) {
        int memberCount = caches.length;
        for (Cache<?, ?> cache : caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            if (TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean areCacheViewsComplete(boolean barfIfTooManyMembers, CacheContainer ... cacheContainers) {
        if (cacheContainers == null) {
            throw new NullPointerException("Cache Manager array is null");
        }
        int memberCount = cacheContainers.length;
        for (CacheContainer cacheContainer : cacheContainers) {
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cacheContainer;
            if (TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheViewComplete(Cache<?, ?> c, int memberCount) {
        EmbeddedCacheManager cacheManager = c.getCacheManager();
        return TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, true);
    }

    public static boolean isCacheViewComplete(List<org.infinispan.remoting.transport.Address> members, org.infinispan.remoting.transport.Address address, int memberCount, boolean barfIfTooManyMembers) {
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            if (barfIfTooManyMembers) {
                StringBuilder sb = new StringBuilder("Cache at address ");
                sb.append(address);
                sb.append(" had ");
                sb.append(members.size());
                sb.append(" members; expecting ");
                sb.append(memberCount);
                sb.append(". Members were (");
                for (int j = 0; j < members.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(members.get(j));
                }
                sb.append(')');
                throw new IllegalStateException(sb.toString());
            }
            return false;
        }
        return true;
    }

    public static void blockUntilViewsChanged(long timeout, int finalViewSize, Cache<?, ?> ... caches) {
        TestingUtil.blockUntilViewsChanged(caches, timeout, finalViewSize);
    }

    private static void blockUntilViewsChanged(Cache<?, ?>[] caches, long timeout, int finalViewSize) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsChanged(caches, finalViewSize)) continue;
            return;
        }
        ArrayList<List> allViews = new ArrayList<List>(caches.length);
        for (Cache<?, ?> cache : caches) {
            allViews.add(cache.getCacheManager().getMembers());
        }
        throw new RuntimeException(String.format("Timed out before caches had changed views (%s) to contain %d members", allViews, finalViewSize));
    }

    private static boolean areCacheViewsChanged(Cache<?, ?>[] caches, int finalViewSize) {
        for (Cache<?, ?> cache : caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            if (TestingUtil.isCacheViewChanged(cacheManager.getMembers(), finalViewSize)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCacheViewChanged(List<org.infinispan.remoting.transport.Address> members, int finalViewSize) {
        return members != null && finalViewSize == members.size();
    }

    public static void sleepThread(long sleeptime) {
        TestingUtil.sleepThread(sleeptime, null);
    }

    public static void sleepThread(long sleeptime, String messageOnInterrupt) {
        block2: {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException ie) {
                if (messageOnInterrupt == null) break block2;
                log.error((Object)messageOnInterrupt);
            }
        }
    }

    private static void sleepThreadInt(long sleeptime, String messageOnInterrupt) throws InterruptedException {
        try {
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException ie) {
            if (messageOnInterrupt != null) {
                log.error((Object)messageOnInterrupt);
            }
            throw ie;
        }
    }

    public static void sleepRandom(int maxTime) {
        TestingUtil.sleepThread(random.nextInt(maxTime));
    }

    public static void killCacheManagers(CacheContainer ... cacheContainers) {
        EmbeddedCacheManager[] cms = new EmbeddedCacheManager[cacheContainers.length];
        for (int i = 0; i < cacheContainers.length; ++i) {
            cms[i] = (EmbeddedCacheManager)cacheContainers[i];
        }
        TestingUtil.killCacheManagers(cms);
    }

    public static void killCacheManagers(EmbeddedCacheManager ... cacheManagers) {
        TestingUtil.killCacheManagers(Arrays.asList(cacheManagers));
    }

    public static void killCacheManagers(List<? extends EmbeddedCacheManager> cacheManagers) {
        if (cacheManagers != null) {
            for (int i = cacheManagers.size() - 1; i >= 0; --i) {
                EmbeddedCacheManager cm = cacheManagers.get(i);
                try {
                    if (cm == null) continue;
                    SecurityActions.stopManager((EmbeddedCacheManager)cm);
                    continue;
                }
                catch (Throwable e) {
                    log.warn((Object)("Problems killing cache manager " + String.valueOf(cm)), e);
                }
            }
        }
    }

    public static void clearContent(EmbeddedCacheManager ... cacheManagers) {
        TestingUtil.clearContent(Arrays.asList(cacheManagers));
    }

    public static void clearContent(List<? extends EmbeddedCacheManager> cacheManagers) {
        if (cacheManagers != null) {
            for (EmbeddedCacheManager embeddedCacheManager : cacheManagers) {
                try {
                    TestingUtil.clearContent(embeddedCacheManager);
                }
                catch (Throwable e) {
                    log.warn((Object)("Problems clearing cache manager " + String.valueOf(embeddedCacheManager)), e);
                }
            }
        }
    }

    public static void clearContent(EmbeddedCacheManager cacheContainer) {
        if (cacheContainer != null && cacheContainer.getStatus().allowInvocations()) {
            Set<Cache<?, ?>> runningCaches = TestingUtil.getRunningCaches(cacheContainer);
            for (Cache<?, ?> cache : runningCaches) {
                TestingUtil.clearRunningTx(cache);
            }
            if (!cacheContainer.getStatus().allowInvocations()) {
                return;
            }
            for (Cache<?, ?> cache : runningCaches) {
                try {
                    TestingUtil.clearCacheLoader(cache);
                    TestingUtil.removeInMemoryData(cache);
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "Failed to clear cache %s after test", cache);
                }
            }
        }
    }

    private static Set<String> getOrderedCacheNames(EmbeddedCacheManager cacheContainer) {
        LinkedHashSet<String> caches = new LinkedHashSet<String>();
        try {
            DependencyGraph graph = TestingUtil.extractGlobalComponent((CacheContainer)cacheContainer, DependencyGraph.class, "org.infinispan.CacheDependencyGraph");
            caches.addAll(graph.topologicalSort());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return caches;
    }

    private static Set<Cache<?, ?>> getRunningCaches(EmbeddedCacheManager cacheContainer) {
        if (cacheContainer == null || !cacheContainer.getStatus().allowInvocations()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> running = new LinkedHashSet<String>(TestingUtil.getOrderedCacheNames(cacheContainer));
        TestingUtil.extractGlobalComponent((CacheContainer)cacheContainer, InternalCacheRegistry.class).filterPrivateCaches(running);
        running.addAll(cacheContainer.getCacheNames());
        TestingUtil.extractGlobalConfiguration(cacheContainer).defaultCacheName().ifPresent(running::add);
        LinkedHashSet runningCaches = new LinkedHashSet();
        for (String cacheName : running) {
            Cache cache;
            try {
                cache = cacheContainer.getCache(cacheName, false);
            }
            catch (CacheException ignoreCache) {
                continue;
            }
            if (cache == null || !cache.getStatus().allowInvocations()) continue;
            runningCaches.add(cache);
        }
        return runningCaches;
    }

    public static GlobalConfiguration extractGlobalConfiguration(EmbeddedCacheManager cacheContainer) {
        return SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cacheContainer);
    }

    private static void clearRunningTx(Cache<?, ?> cache) {
        if (cache != null) {
            TransactionManager txm = TestingUtil.getTransactionManager(cache);
            TestingUtil.killTransaction(txm);
        }
    }

    public static void clearCacheLoader(Cache<?, ?> cache) {
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
        CompletionStages.join((CompletionStage)persistenceManager.clearAllStores((Predicate)PersistenceManager.AccessMode.BOTH));
    }

    public static <K, V> List<DummyInMemoryStore<K, V>> cachestores(List<Cache<K, V>> caches) {
        LinkedList<DummyInMemoryStore<K, V>> l = new LinkedList<DummyInMemoryStore<K, V>>();
        for (Cache<K, V> c : caches) {
            l.add((DummyInMemoryStore)TestingUtil.getFirstStore(c));
        }
        return l;
    }

    private static void removeInMemoryData(Cache<?, ?> cache) {
        log.debugf("Cleaning data for cache %s", cache);
        InternalDataContainer dataContainer = TestingUtil.extractComponent(cache, InternalDataContainer.class);
        if (log.isDebugEnabled()) {
            log.debugf("Data container size before clear: %d", dataContainer.sizeIncludingExpired());
        }
        dataContainer.clear();
    }

    public static void killCaches(Cache<?, ?> ... caches) {
        TestingUtil.killCaches(Arrays.asList(caches));
    }

    public static void killCaches(Collection<? extends Cache<?, ?>> caches) {
        for (Cache<?, ?> c : caches) {
            try {
                long size;
                if (c == null || c.getStatus() != ComponentStatus.RUNNING) continue;
                TransactionManager tm = c.getAdvancedCache().getTransactionManager();
                if (tm != null) {
                    try {
                        tm.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                long l = size = log.isTraceEnabled() ? (long)c.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).size() : 0L;
                if (c.getAdvancedCache().getRpcManager() != null) {
                    log.tracef("Local size on %s before stopping: %d", (Object)c.getAdvancedCache().getRpcManager().getAddress(), (Object)size);
                } else {
                    log.tracef("Local size before stopping: %d", size);
                }
                c.stop();
            }
            catch (Throwable t) {
                log.errorf(t, "Error killing cache %s", (Object)c.getName());
            }
        }
    }

    public static void killTransaction(TransactionManager txManager) {
        if (txManager != null) {
            try {
                if (txManager.getTransaction() != null) {
                    txManager.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void killTransactions(Cache<?, ?> ... caches) {
        for (Cache<?, ?> c : caches) {
            TransactionManager tm;
            if (c == null || c.getStatus() != ComponentStatus.RUNNING || (tm = TestingUtil.getTransactionManager(c)) == null) continue;
            try {
                tm.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ComponentRegistry extractComponentRegistry(Cache<?, ?> cache) {
        return SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache());
    }

    public static GlobalComponentRegistry extractGlobalComponentRegistry(CacheContainer cacheContainer) {
        return SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)((EmbeddedCacheManager)cacheContainer));
    }

    public static LockManager extractLockManager(Cache<?, ?> cache) {
        return (LockManager)TestingUtil.extractComponentRegistry(cache).getComponent(LockManager.class);
    }

    public static GlobalMarshaller extractGlobalMarshaller(EmbeddedCacheManager cm) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm);
        return (GlobalMarshaller)gcr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.internal");
    }

    public static PersistenceMarshallerImpl extractPersistenceMarshaller(EmbeddedCacheManager cm) {
        return (PersistenceMarshallerImpl)TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm).getComponent(PersistenceMarshallerImpl.class, "org.infinispan.marshaller.persistence");
    }

    public static AsyncInterceptorChain extractInterceptorChain(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, AsyncInterceptorChain.class);
    }

    public static <K> LocalizedCacheTopology extractCacheTopology(Cache<K, ?> cache) {
        return cache.getAdvancedCache().getDistributionManager().getCacheTopology();
    }

    public static void addCacheStartingHook(EmbeddedCacheManager cacheContainer, final BiConsumer<String, ComponentRegistry> consumer) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cacheContainer);
        TestingUtil.extractField(gcr, "moduleLifecycles");
        TestingUtil.replaceField(gcr, "moduleLifecycles", moduleLifecycles -> {
            ArrayList<1> copy = new ArrayList<1>((Collection<1>)moduleLifecycles);
            copy.add(new ModuleLifecycle(){

                public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
                    consumer.accept(cacheName, cr);
                }
            });
            return copy;
        });
    }

    public static boolean replaceInterceptor(Cache<?, ?> cache, AsyncInterceptor replacingInterceptor, Class<? extends AsyncInterceptor> toBeReplacedInterceptorType) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        cr.wireDependencies((Object)replacingInterceptor);
        AsyncInterceptorChain inch = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return inch.replaceInterceptor(replacingInterceptor, toBeReplacedInterceptorType);
    }

    public static void blockUntilCacheStatusAchieved(Cache<?, ?> cache, ComponentStatus cacheStatus, long timeout) {
        AdvancedCache spi = cache.getAdvancedCache();
        long killTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < killTime) {
            if (spi.getStatus() == cacheStatus) {
                return;
            }
            TestingUtil.sleepThread(50L);
        }
        throw new RuntimeException("Timed out waiting for condition");
    }

    public static void blockUntilViewsReceived(int timeout, Collection<?> caches) {
        Object first = caches.iterator().next();
        if (first instanceof Cache) {
            TestingUtil.blockUntilViewsReceived((long)timeout, caches.toArray(new Cache[0]));
        } else {
            TestingUtil.blockUntilViewsReceived((long)timeout, caches.toArray(new CacheContainer[0]));
        }
    }

    public static void blockUntilViewsReceived(int timeout, boolean barfIfTooManyMembers, Collection<?> caches) {
        Object first = caches.iterator().next();
        if (first instanceof Cache) {
            TestingUtil.blockUntilViewsReceived((long)timeout, barfIfTooManyMembers, caches.toArray(new Cache[0]));
        } else {
            TestingUtil.blockUntilViewsReceived((long)timeout, barfIfTooManyMembers, caches.toArray(new CacheContainer[0]));
        }
    }

    public static CommandsFactory extractCommandsFactory(Cache<?, ?> cache) {
        if (cache instanceof AbstractDelegatingCache) {
            return TestingUtil.extractCommandsFactory((Cache)TestingUtil.extractField(cache, "cache"));
        }
        return (CommandsFactory)TestingUtil.extractField(cache, "commandsFactory");
    }

    public static void dumpCacheContents(List<Cache<?, ?>> caches) {
        System.out.println("**** START: Cache Contents ****");
        int count = 1;
        for (Cache<?, ?> c : caches) {
            if (c == null) {
                System.out.println("  ** Cache " + count + " is null!");
            } else {
                EmbeddedCacheManager cacheManager = c.getCacheManager();
                System.out.println("  ** Cache " + count + " is " + String.valueOf(cacheManager.getAddress()));
            }
            ++count;
        }
        System.out.println("**** END: Cache Contents ****");
    }

    public static void dumpCacheContents(Cache<?, ?> ... caches) {
        TestingUtil.dumpCacheContents(Arrays.asList(caches));
    }

    public static <T> T extractComponent(Cache<?, ?> cache, Class<T> componentType) {
        if (componentType == DataContainer.class) {
            throw new UnsupportedOperationException("Should extract InternalDataContainer");
        }
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache.getAdvancedCache());
        return (T)cr.getComponent(componentType);
    }

    public static <T> T extractGlobalComponent(CacheContainer cacheContainer, Class<T> componentType) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry(cacheContainer);
        return (T)gcr.getComponent(componentType);
    }

    public static <T> T extractGlobalComponent(CacheContainer cacheContainer, Class<T> componentType, String componentName) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry(cacheContainer);
        return (T)gcr.getComponent(componentType, componentName);
    }

    public static TransactionManager getTransactionManager(Cache<?, ?> cache) {
        return cache == null ? null : cache.getAdvancedCache().getTransactionManager();
    }

    public static <T> T replaceComponent(Cache<?, ?> cache, Class<? extends T> componentType, T replacementComponent, boolean rewire) {
        if (componentType == DataContainer.class) {
            throw new UnsupportedOperationException();
        }
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ComponentRef old = bcr.getComponent(componentType);
        bcr.replaceComponent(componentType.getName(), replacementComponent, true);
        cr.cacheComponents();
        if (rewire) {
            cr.rewire();
        }
        return (T)(old != null ? old.wired() : null);
    }

    public static <T extends Lifecycle> T replaceComponent(Cache<?, ?> cache, Class<T> componentType, T replacementComponent, boolean rewire, boolean stopBeforeWire) {
        if (stopBeforeWire) {
            replacementComponent.stop();
        }
        return (T)((Lifecycle)TestingUtil.replaceComponent(cache, componentType, replacementComponent, rewire));
    }

    public static <T> T replaceComponent(CacheContainer cacheContainer, Class<T> componentType, T replacementComponent, boolean rewire) {
        return TestingUtil.replaceComponent(cacheContainer, componentType, componentType.getName(), replacementComponent, rewire);
    }

    public static <T> T replaceComponent(CacheContainer cacheContainer, Class<T> componentType, String name, T replacementComponent, boolean rewire) {
        GlobalComponentRegistry cr = TestingUtil.extractGlobalComponentRegistry(cacheContainer);
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ComponentRef old = bcr.getComponent(componentType);
        bcr.replaceComponent(name, replacementComponent, true);
        if (rewire) {
            cr.rewire();
            cr.rewireNamedRegistries();
        }
        return (T)(old != null ? old.wired() : null);
    }

    public static <K, V> CacheLoader<K, V> getCacheLoader(Cache<K, V> cache) {
        if (cache.getCacheConfiguration().persistence().usingStores()) {
            return TestingUtil.getFirstLoader(cache);
        }
        return null;
    }

    public static String printCache(Cache<?, ?> cache) {
        DataContainer dataContainer = (DataContainer)TestingUtil.extractComponent(cache, InternalDataContainer.class);
        Iterator it = dataContainer.iterator();
        StringBuilder builder = new StringBuilder(cache.getName() + "[");
        while (it.hasNext()) {
            InternalCacheEntry ce = (InternalCacheEntry)it.next();
            builder.append(ce.getKey()).append("=").append(ce.getValue()).append(",l=").append(ce.getLifespan()).append("; ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static <K> Set<K> getInternalKeys(Cache<K, ?> cache) {
        DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
        HashSet<Object> keys = new HashSet<Object>();
        for (CacheEntry entry : dataContainer) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static <V> Collection<V> getInternalValues(Cache<?, V> cache) {
        DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
        ArrayList<Object> values = new ArrayList<Object>();
        for (CacheEntry entry : dataContainer) {
            values.add(entry.getValue());
        }
        return values;
    }

    public static DISCARD getDiscardForCache(EmbeddedCacheManager cacheManager) throws Exception {
        JGroupsTransport jgt = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, Transport.class);
        JChannel ch = jgt.getChannel();
        ProtocolStack ps = ch.getProtocolStack();
        DISCARD discard = new DISCARD();
        discard.excludeItself(false);
        ps.insertProtocol((Protocol)discard, ProtocolStack.Position.ABOVE, TP.class);
        return discard;
    }

    public static DELAY setDelayForCache(Cache<?, ?> cache, int in_delay_millis, int out_delay_millis) throws Exception {
        JGroupsTransport jgt = (JGroupsTransport)TestingUtil.extractComponent(cache, Transport.class);
        JChannel ch = jgt.getChannel();
        ProtocolStack ps = ch.getProtocolStack();
        DELAY delay = (DELAY)ps.findProtocol(DELAY.class);
        if (delay == null) {
            delay = new DELAY();
            ps.insertProtocol((Protocol)delay, ProtocolStack.Position.ABOVE, TP.class);
        }
        delay.setInDelay(in_delay_millis);
        delay.setOutDelay(out_delay_millis);
        return delay;
    }

    public static String k() {
        return TestingUtil.k(0);
    }

    public static String k(int index) {
        return TestingUtil.k(CallerId.getCallerMethodName((int)2), index);
    }

    public static String k(int index, String prefix) {
        return String.format("%s-k%d-%s", prefix, index, CallerId.getCallerMethodName((int)2));
    }

    public static String v() {
        return TestingUtil.v(0);
    }

    public static String v(int index) {
        return TestingUtil.v(CallerId.getCallerMethodName((int)2), index);
    }

    public static String v(int index, String prefix) {
        return String.format("%s-v%d-%s", prefix, index, CallerId.getCallerMethodName((int)2));
    }

    public static String k(Method method, int index) {
        return "k" + index + "-" + method.getName();
    }

    public static String k(String method, int index) {
        return "k" + index + "-" + method;
    }

    public static String v(Method method, int index) {
        return "v" + index + "-" + method.getName();
    }

    public static String v(String method, int index) {
        return "v" + index + "-" + method;
    }

    public static String k(Method method) {
        return TestingUtil.k(method, 0);
    }

    public static String v(Method method) {
        return TestingUtil.v(method, 0);
    }

    public static String k(Method m, String prefix) {
        return prefix + m.getName();
    }

    public static String v(Method m, String prefix) {
        return prefix + m.getName();
    }

    public static String v(Method m, String prefix, int index) {
        return String.format("%s-v%d-%s", prefix, index, m.getName());
    }

    public static TransactionTable getTransactionTable(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, TransactionTable.class);
    }

    public static ObjectName getCacheManagerObjectName(String jmxDomain) {
        return TestingUtil.getCacheManagerObjectName(jmxDomain, "DefaultCacheManager");
    }

    public static ObjectName getCacheManagerObjectName(String jmxDomain, String cacheManagerName) {
        return TestingUtil.getCacheManagerObjectName(jmxDomain, cacheManagerName, "CacheManager");
    }

    public static ObjectName getCacheManagerObjectName(String jmxDomain, String cacheManagerName, String component) {
        try {
            return new ObjectName(jmxDomain + ":type=CacheManager,name=" + ObjectName.quote(cacheManagerName) + ",component=" + component);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName) {
        return TestingUtil.getCacheObjectName(jmxDomain, cacheName, "Cache");
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName, String component) {
        return TestingUtil.getCacheObjectName(jmxDomain, cacheName, component, "DefaultCacheManager");
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName, String component, String cacheManagerName) {
        if (!cacheName.contains("(") || !cacheName.endsWith(")")) {
            throw new IllegalArgumentException("Cache name does not appear to include a cache mode suffix: " + cacheName);
        }
        try {
            return new ObjectName(jmxDomain + ":type=Cache,manager=" + ObjectName.quote(cacheManagerName) + ",name=" + ObjectName.quote(cacheName) + ",component=" + component);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getJGroupsChannelObjectName(EmbeddedCacheManager cacheManager) {
        GlobalConfiguration cfg = cacheManager.getCacheManagerConfiguration();
        try {
            return new ObjectName(String.format("%s:type=channel,cluster=%s,manager=%s", cfg.jmx().domain(), ObjectName.quote(cacheManager.getClusterName()), ObjectName.quote(cfg.cacheManagerName())));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean existsDomain(MBeanServer mBeanServer, String domain) {
        for (String d : mBeanServer.getDomains()) {
            if (!domain.equals(d)) continue;
            return true;
        }
        return false;
    }

    public static void checkMBeanOperationParameterNaming(MBeanServer mBeanServer, ObjectName objectName) throws JMException {
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo op : mBeanInfo.getOperations()) {
            for (MBeanParameterInfo param : op.getSignature()) {
                AssertJUnit.assertFalse((boolean)param.getName().matches("p[0-9]+"));
            }
        }
    }

    public static String generateRandomString(int numberOfChars) {
        return TestingUtil.generateRandomString(numberOfChars, new Random(System.currentTimeMillis()));
    }

    public static String generateRandomString(int numberOfChars, Random r) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfChars; ++i) {
            sb.append((char)(64 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public static void assertNoLocks(Cache<?, ?> cache) {
        LockManager lm = TestingUtil.extractLockManager(cache);
        if (lm != null) {
            for (Object key : cache.keySet()) {
                assert (!lm.isLocked(key));
            }
        }
    }

    public static <T> T withTx(TransactionManager tm, Callable<T> c) throws Exception {
        return (T)((Callable<Object>)() -> {
            tm.begin();
            try {
                Object v = c.call();
                return v;
            }
            catch (Exception e) {
                tm.setRollbackOnly();
                throw e;
            }
            finally {
                if (tm.getStatus() == 0) {
                    tm.commit();
                } else {
                    tm.rollback();
                }
            }
        }).call();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void withCacheManager(CacheManagerCallable c) {
        try {
            c.call();
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (c.clearBeforeKill()) {
                    TestingUtil.clearContent(c.cm);
                }
                TestingUtil.killCacheManagers(c.cm);
                throw throwable;
            }
        }
        if (c.clearBeforeKill()) {
            TestingUtil.clearContent(c.cm);
        }
        TestingUtil.killCacheManagers(c.cm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withCacheManager(Supplier<EmbeddedCacheManager> s, Consumer<EmbeddedCacheManager> c) {
        EmbeddedCacheManager cm = null;
        try {
            cm = s.get();
            c.accept(cm);
            if (cm == null) return;
        }
        catch (Throwable throwable) {
            if (cm == null) throw throwable;
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public static void withCacheManager(EmbeddedCacheManager cm, Consumer<EmbeddedCacheManager> c) {
        try {
            c.accept(cm);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public static void withCacheManagers(MultiCacheManagerCallable c) {
        try {
            c.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            TestingUtil.killCacheManagers(c.cms);
        }
    }

    public static String getDefaultCacheName(EmbeddedCacheManager cm) {
        return (String)TestingUtil.extractGlobalConfiguration(cm).defaultCacheName().get();
    }

    public static boolean moreThanDurationElapsed(long start, long duration) {
        return TestingUtil.now() - duration >= start;
    }

    public static long now() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static Metadata metadata(Long lifespan, Long maxIdle) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan != null ? lifespan : -1L).maxIdle(maxIdle != null ? maxIdle : -1L).build();
    }

    public static Metadata metadata(Integer lifespan, Integer maxIdle) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan != null ? (long)lifespan.intValue() : -1L).maxIdle(maxIdle != null ? (long)maxIdle.intValue() : -1L).build();
    }

    public static <T extends NonBlockingStore<K, V>, K, V> T getFirstStore(Cache<K, V> cache) {
        return TestingUtil.getStore(cache, 0, true);
    }

    public static <T extends NonBlockingStore<K, V>, K, V> T getStore(Cache<K, V> cache, int position, boolean unwrapped) {
        PersistenceManagerImpl persistenceManager = TestingUtil.getActualPersistenceManager(cache);
        NonBlockingStore nonBlockingStore = (NonBlockingStore)persistenceManager.getAllStores(characteristics -> !characteristics.contains(NonBlockingStore.Characteristic.WRITE_ONLY)).get(position);
        if (unwrapped && nonBlockingStore instanceof DelegatingNonBlockingStore) {
            nonBlockingStore = ((DelegatingNonBlockingStore)nonBlockingStore).delegate();
        }
        return (T)nonBlockingStore;
    }

    public static <K, V> WaitDelegatingNonBlockingStore<K, V> getFirstStoreWait(Cache<K, V> cache) {
        return TestingUtil.getStoreWait(cache, 0, true);
    }

    public static <K, V> WaitDelegatingNonBlockingStore<K, V> getStoreWait(Cache<K, V> cache, int position, boolean unwrapped) {
        Object nonBlockingStore = TestingUtil.getStore(cache, position, unwrapped);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        return new WaitDelegatingNonBlockingStore(nonBlockingStore, keyPartitioner);
    }

    public static <T extends CacheLoader<K, V>, K, V> T getFirstLoader(Cache<K, V> cache) {
        PersistenceManagerImpl persistenceManager = TestingUtil.getActualPersistenceManager(cache);
        NonBlockingStore nonBlockingStore = (NonBlockingStore)persistenceManager.getAllStores(characteristics -> !characteristics.contains(NonBlockingStore.Characteristic.WRITE_ONLY)).get(0);
        return (T)((NonBlockingStoreAdapter)nonBlockingStore).loader();
    }

    public static <T extends CacheWriter<K, V>, K, V> T getFirstWriter(Cache<K, V> cache) {
        return TestingUtil.getWriter(cache, 0);
    }

    public static <T extends CacheWriter<K, V>, K, V> T getWriter(Cache<K, V> cache, int position) {
        PersistenceManagerImpl persistenceManager = TestingUtil.getActualPersistenceManager(cache);
        NonBlockingStore nonBlockingStore = (NonBlockingStore)persistenceManager.getAllStores(characteristics -> !characteristics.contains(NonBlockingStore.Characteristic.READ_ONLY)).get(position);
        return (T)((NonBlockingStoreAdapter)nonBlockingStore).writer();
    }

    public static <T extends CacheWriter<K, V>, K, V> T getFirstTxWriter(Cache<K, V> cache) {
        PersistenceManagerImpl persistenceManager = TestingUtil.getActualPersistenceManager(cache);
        NonBlockingStore nonBlockingStore = (NonBlockingStore)persistenceManager.getAllStores(characteristics -> characteristics.contains(NonBlockingStore.Characteristic.TRANSACTIONAL)).get(0);
        return (T)((NonBlockingStoreAdapter)nonBlockingStore).transactionalStore();
    }

    private static PersistenceManagerImpl getActualPersistenceManager(Cache<?, ?> cache) {
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
        if (persistenceManager instanceof DelegatingPersistenceManager) {
            return (PersistenceManagerImpl)((DelegatingPersistenceManager)persistenceManager).getActual();
        }
        return (PersistenceManagerImpl)persistenceManager;
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(AdvancedLoadWriteStore<K, V> cl, Predicate<K> filter) {
        return (Set)Flowable.fromPublisher((Publisher)cl.entryPublisher(filter, true, true)).collectInto(new HashSet(), Set::add).blockingGet();
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(AdvancedLoadWriteStore<K, V> cl) {
        return TestingUtil.allEntries(cl, null);
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(NonBlockingStore<K, V> store) {
        return TestingUtil.allEntries(store, IntSets.immutableSet((int)0), null);
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(NonBlockingStore<K, V> store, Predicate<? super K> filter) {
        return TestingUtil.allEntries(store, IntSets.immutableSet((int)0), filter);
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(NonBlockingStore<K, V> store, IntSet segments) {
        return TestingUtil.allEntries(store, segments, null);
    }

    public static <K, V> Set<MarshallableEntry<K, V>> allEntries(NonBlockingStore<K, V> store, IntSet segments, Predicate<? super K> filter) {
        return (Set)Flowable.fromPublisher((Publisher)store.publishEntries(segments, filter, true)).collectInto(new HashSet(), Set::add).blockingGet();
    }

    public static void outputPropertiesToXML(String outputFile, Properties properties) throws IOException {
        Properties sorted = new Properties(){

            @Override
            public Set<Object> keySet() {
                return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
            }

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }

            @Override
            public Set<String> stringPropertyNames() {
                return Collections.unmodifiableSet(new TreeSet<String>(super.stringPropertyNames()));
            }
        };
        sorted.putAll((Map<?, ?>)properties);
        try (FileOutputStream stream = new FileOutputStream(outputFile);){
            sorted.storeToXML(stream, null);
        }
    }

    public static <K, V> void writeToAllStores(K key, V value, Cache<K, V> cache) {
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        CompletionStages.join((CompletionStage)pm.writeToAllNonTxStores(MarshalledEntryUtil.create(key, value, cache), keyPartitioner.getSegment(key), (Predicate)PersistenceManager.AccessMode.BOTH));
    }

    public static <K, V> boolean deleteFromAllStores(K key, Cache<K, V> cache) {
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        KeyPartitioner keyPartitioner = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        return (Boolean)CompletionStages.join((CompletionStage)pm.deleteFromAllStores(key, keyPartitioner.getSegment(key), (Predicate)PersistenceManager.AccessMode.BOTH));
    }

    public static Subject makeSubject(String ... principals) {
        LinkedHashSet<TestPrincipal> set = new LinkedHashSet<TestPrincipal>();
        if (principals.length > 0) {
            set.add(new TestPrincipal(principals[0]));
            for (int i = 1; i < principals.length; ++i) {
                set.add((TestPrincipal)new GroupPrincipal(principals[i]));
            }
        }
        return new Subject(true, set, Collections.emptySet(), Collections.emptySet());
    }

    public static Map<AuthorizationPermission, Subject> makeAllSubjects() {
        HashMap<AuthorizationPermission, Subject> subjects = new HashMap<AuthorizationPermission, Subject>(AuthorizationPermission.values().length);
        for (AuthorizationPermission perm : AuthorizationPermission.values()) {
            subjects.put(perm, TestingUtil.makeSubject(perm.toString() + "_user", perm.toString()));
        }
        return subjects;
    }

    public static void assertAnyEquals(Object expected, Object actual) {
        if (expected instanceof byte[] && actual instanceof byte[]) {
            AssertJUnit.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])actual));
        } else {
            AssertJUnit.assertEquals((Object)expected, (Object)actual);
        }
    }

    public static void assertBetween(double lowerBound, double upperBound, double actual) {
        if (actual < lowerBound || upperBound < actual) {
            AssertJUnit.fail((String)("Expected between:<" + lowerBound + "> and:<" + upperBound + "> but was:<" + actual + ">"));
        }
    }

    public static void assertBetween(long lowerBound, long upperBound, long actual) {
        if (actual < lowerBound || upperBound < actual) {
            AssertJUnit.fail((String)("Expected between:<" + lowerBound + "> and:<" + upperBound + "> but was:<" + actual + ">"));
        }
    }

    public static MBeanServer getMBeanServer(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, CacheJmxRegistration.class).getMBeanServer();
    }

    public static MBeanServer getMBeanServer(EmbeddedCacheManager cacheManager) {
        return TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, CacheManagerJmxRegistration.class).getMBeanServer();
    }

    public static <T, W extends T> W wrapGlobalComponent(CacheContainer cacheContainer, Class<T> tClass, WrapFactory<T, W, CacheContainer> factory, boolean rewire) {
        T current = TestingUtil.extractGlobalComponent(cacheContainer, tClass);
        W wrap = factory.wrap(cacheContainer, current);
        TestingUtil.replaceComponent(cacheContainer, tClass, wrap, rewire);
        return wrap;
    }

    public static <T, W extends T> W wrapGlobalComponent(CacheContainer cacheContainer, Class<T> tClass, Function<T, W> ctor, boolean rewire) {
        T current = TestingUtil.extractGlobalComponent(cacheContainer, tClass);
        W wrap = ctor.apply(current);
        TestingUtil.replaceComponent(cacheContainer, tClass, wrap, rewire);
        return wrap;
    }

    public static <T, W extends T> W wrapComponent(Cache<?, ?> cache, Class<T> tClass, WrapFactory<T, W, Cache<?, ?>> factory, boolean rewire) {
        T current = TestingUtil.extractComponent(cache, tClass);
        W wrap = factory.wrap(cache, current);
        TestingUtil.replaceComponent(cache, tClass, wrap, rewire);
        return wrap;
    }

    public static <T, W extends T> W wrapComponent(Cache<?, ?> cache, Class<T> tClass, Function<T, W> ctor) {
        T current = TestingUtil.extractComponent(cache, tClass);
        W wrap = ctor.apply(current);
        TestingUtil.replaceComponent(cache, tClass, wrap, true);
        return wrap;
    }

    public static <T extends PerCacheInboundInvocationHandler> T wrapInboundInvocationHandler(Cache<?, ?> cache, Function<PerCacheInboundInvocationHandler, T> ctor) {
        PerCacheInboundInvocationHandler current = TestingUtil.extractComponent(cache, PerCacheInboundInvocationHandler.class);
        PerCacheInboundInvocationHandler wrap = (PerCacheInboundInvocationHandler)ctor.apply(current);
        TestingUtil.replaceComponent(cache, PerCacheInboundInvocationHandler.class, wrap, true);
        return (T)wrap;
    }

    public static void expectCause(Throwable t, Class<? extends Throwable> c, String messageRegex) {
        while (true) {
            if (c.isAssignableFrom(t.getClass())) {
                if (messageRegex != null && !Pattern.matches(messageRegex, t.getMessage())) {
                    throw new RuntimeException(String.format("Exception message '%s' does not match regex '%s'", t.getMessage(), messageRegex), t);
                }
                return;
            }
            Throwable cause = t.getCause();
            if (cause == null || cause == t) {
                throw new RuntimeException("Cannot find a cause of type " + c.getName(), cause);
            }
            t = cause;
        }
    }

    public static boolean isTriangleAlgorithm(CacheMode cacheMode, boolean transactional) {
        return cacheMode.isDistributed() && !transactional;
    }

    public static <K, V> Map.Entry<K, V> createMapEntry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <T, U> Map<T, U> mapOf(Object ... keyValueKeyValueKeyValue) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        while (i < keyValueKeyValueKeyValue.length) {
            map.put(keyValueKeyValueKeyValue[i++], keyValueKeyValueKeyValue[i++]);
        }
        return map;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... elements) {
        if (elements == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static void inject(Object instance, Object ... components) {
        TestComponentAccessors.wire(instance, components);
    }

    public static void startComponent(Object component) {
        try {
            TestComponentAccessors.start(component);
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    public static void stopComponent(Object component) {
        try {
            TestComponentAccessors.stop(component);
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    public static Object named(String name, Object instance) {
        return new TestComponentAccessors.NamedComponent(name, instance);
    }

    public static void cleanUpDataContainerForCache(Cache<?, ?> cache) {
        InternalDataContainer dataContainer = TestingUtil.extractComponent(cache, InternalDataContainer.class);
        dataContainer.cleanUp();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
    }

    public static ProtoStreamMarshaller createProtoStreamMarshaller(SerializationContextInitializer sci) {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
        return new ProtoStreamMarshaller(ctx);
    }

    public static <E> Publisher<NonBlockingStore.SegmentedPublisher<E>> singleSegmentPublisher(Publisher<E> flowable) {
        return Flowable.just((Object)SingleSegmentPublisher.singleSegment(flowable));
    }

    public static <E> Publisher<NonBlockingStore.SegmentedPublisher<E>> multipleSegmentPublisher(Publisher<E> flowable, Function<E, Object> toKeyFunction, KeyPartitioner keyPartitioner) {
        return Flowable.fromPublisher(flowable).groupBy(e -> keyPartitioner.getSegment(toKeyFunction.apply(e))).map(SegmentPublisherWrapper::wrap);
    }

    public static void defineConfiguration(EmbeddedCacheManager cacheManager, String cacheName, Configuration configuration) {
        SecurityActions.defineConfiguration((EmbeddedCacheManager)cacheManager, (String)cacheName, (Configuration)configuration);
    }

    public static Set<Object> getListeners(Cache<?, ?> cache) {
        CacheNotifierImpl notifier = (CacheNotifierImpl)TestingUtil.extractComponent(cache, CacheNotifier.class);
        return notifier.getListeners();
    }

    public static Set<Object> getListeners(EmbeddedCacheManager cacheManager) {
        CacheManagerNotifierImpl notifier = (CacheManagerNotifierImpl)TestingUtil.extractGlobalComponent((CacheContainer)cacheManager, CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    static {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("test-timeout-thread");
            return t;
        });
        executor.setRemoveOnCancelPolicy(true);
        timeoutExecutor = executor;
    }

    public static class TestPrincipal
    implements Principal,
    Serializable {
        String name;

        public TestPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return "TestPrincipal [name=" + this.name + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestPrincipal other = (TestPrincipal)obj;
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }
    }

    public static interface WrapFactory<T, W, C> {
        public W wrap(C var1, T var2);
    }
}

