/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class PerCacheExecutorThread
extends Thread {
    private static final Log log = LogFactory.getLog(PerCacheExecutorThread.class);
    private final Cache<Object, Object> cache;
    private BlockingQueue<Object> toExecute = new ArrayBlockingQueue<Object>(1);
    private volatile Object response;
    private CountDownLatch responseLatch = new CountDownLatch(1);
    private volatile Transaction ongoingTransaction;
    private volatile Object key;
    private volatile Object value;

    public void setKeyValue(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public PerCacheExecutorThread(Cache<Object, Object> cache, int index) {
        super("PerCacheExecutorThread-" + index + "," + String.valueOf(cache.getCacheManager().getAddress()));
        this.cache = cache;
        this.start();
    }

    public Object execute(Operations op) {
        try {
            this.responseLatch = new CountDownLatch(1);
            this.toExecute.put((Object)op);
            this.responseLatch.await();
            return this.response;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public void executeNoResponse(Operations op) {
        try {
            this.responseLatch = null;
            this.response = null;
            this.toExecute.put((Object)op);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    @Override
    public void run() {
        boolean run = true;
        while (run) {
            Operations operation;
            try {
                operation = (Operations)((Object)this.toExecute.take());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.tracef("about to process operation %s", (Object)operation);
            switch (operation.ordinal()) {
                case 0: {
                    TransactionManager txManager = TestingUtil.getTransactionManager(this.cache);
                    try {
                        txManager.begin();
                        this.ongoingTransaction = txManager.getTransaction();
                        this.setResponse((Object)OperationsResult.BEGIN_TX_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)"Failure on beginning tx", (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 1: {
                    TransactionManager txManager = TestingUtil.getTransactionManager(this.cache);
                    try {
                        txManager.commit();
                        this.ongoingTransaction = null;
                        this.setResponse((Object)OperationsResult.COMMIT_TX_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)"Exception while committing tx", (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 2: {
                    try {
                        this.cache.put(this.key, this.value);
                        log.trace((Object)("Successfully executed putKeyValue(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")"));
                        this.setResponse((Object)OperationsResult.PUT_KEY_VALUE_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)("Exception while executing putKeyValue(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")"), (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 3: {
                    try {
                        this.cache.remove(this.key);
                        log.trace((Object)("Successfully executed remove(" + String.valueOf(this.key) + ")"));
                        this.setResponse((Object)OperationsResult.REMOVE_KEY_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)("Exception while executing remove(" + String.valueOf(this.key) + ")"), (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 4: {
                    try {
                        this.cache.replace(this.key, this.value);
                        log.trace((Object)("Successfully executed replace(" + String.valueOf(this.key) + "," + String.valueOf(this.value) + ")"));
                        this.setResponse((Object)OperationsResult.REPLACE_KEY_VALUE_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)("Exception while executing replace(" + String.valueOf(this.key) + "," + String.valueOf(this.value) + ")"), (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 6: {
                    TransactionManager txManager;
                    try {
                        txManager = TestingUtil.getTransactionManager(this.cache);
                        txManager.getTransaction().enlistResource((XAResource)new XAResourceAdapter());
                        this.setResponse((Object)OperationsResult.FORCE2PC_OK);
                    }
                    catch (Exception e) {
                        log.trace((Object)("Exception while executing replace(" + String.valueOf(this.key) + "," + String.valueOf(this.value) + ")"), (Throwable)e);
                        this.setResponse(e);
                    }
                    break;
                }
                case 5: {
                    log.trace((Object)"Exiting...");
                    this.toExecute = null;
                    run = false;
                    break;
                }
                default: {
                    this.setResponse(new IllegalStateException("Unknown operation!" + String.valueOf((Object)operation)));
                }
            }
            if (this.responseLatch == null) continue;
            this.responseLatch.countDown();
        }
    }

    private void setResponse(Object e) {
        log.tracef("setResponse to %s", e);
        this.response = e;
    }

    public void stopThread() {
        this.execute(Operations.STOP_THREAD);
        while (!this.getState().equals((Object)Thread.State.TERMINATED)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Object lastResponse() {
        return this.response;
    }

    public void clearResponse() {
        this.response = null;
    }

    public Object waitForResponse() {
        while (this.response == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.response;
    }

    public Transaction getOngoingTransaction() {
        return this.ongoingTransaction;
    }

    public static enum Operations {
        BEGIN_TX,
        COMMIT_TX,
        PUT_KEY_VALUE,
        REMOVE_KEY,
        REPLACE_KEY_VALUE,
        STOP_THREAD,
        FORCE2PC;


        public OperationsResult getCorrespondingOkResult() {
            switch (this.ordinal()) {
                case 0: {
                    return OperationsResult.BEGIN_TX_OK;
                }
                case 1: {
                    return OperationsResult.COMMIT_TX_OK;
                }
                case 2: {
                    return OperationsResult.PUT_KEY_VALUE_OK;
                }
                case 3: {
                    return OperationsResult.REMOVE_KEY_OK;
                }
                case 4: {
                    return OperationsResult.REPLACE_KEY_VALUE_OK;
                }
                case 5: {
                    return OperationsResult.STOP_THREAD_OK;
                }
                case 6: {
                    return OperationsResult.FORCE2PC_OK;
                }
            }
            throw new IllegalStateException("Unrecognized operation: " + String.valueOf((Object)this));
        }
    }

    public static enum OperationsResult {
        BEGIN_TX_OK,
        COMMIT_TX_OK,
        PUT_KEY_VALUE_OK,
        REMOVE_KEY_OK,
        REPLACE_KEY_VALUE_OK,
        STOP_THREAD_OK,
        FORCE2PC_OK;

    }
}

