/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.stream.IntStream;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.CacheContainer;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.StatsMinNodeTest")
public class StatsMinNodeTest
extends MultipleCacheManagersTest {
    private static final int MAX_SIZE = 10;
    private static final int NUM_NODES = 5;
    private static final int NUM_OWNERS = 3;
    protected StorageType storageType;
    protected EvictionStrategy evictionStrategy;
    protected ControlledTimeService timeService;

    @Override
    protected void createCacheManagers() throws Throwable {
        int i;
        ConfigurationBuilder cfg = StatsMinNodeTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        this.configure(cfg);
        for (i = 0; i < 5; ++i) {
            this.addClusterEnabledCacheManager(cfg);
        }
        this.waitForClusterToForm();
        this.timeService = new ControlledTimeService();
        for (i = 0; i < 5; ++i) {
            TestingUtil.replaceComponent((CacheContainer)this.manager(i), TimeService.class, this.timeService, true);
        }
    }

    @AfterMethod
    public void cleanCache() {
        this.cache(0).clear();
        ClusterCacheStats stats = TestingUtil.extractComponent(this.cache(0), ClusterCacheStats.class);
        stats.reset();
        this.timeService.advance(stats.getStaleStatsThreshold() + 1L);
    }

    protected void configure(ConfigurationBuilder cfg) {
        cfg.statistics().enable().clustering().hash().numOwners(3).memory().storageType(this.storageType).evictionType(EvictionType.COUNT).size(10L).evictionStrategy(this.evictionStrategy);
        if (this.evictionStrategy == EvictionStrategy.EXCEPTION) {
            cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
    }

    public StatsMinNodeTest withStorage(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public StatsMinNodeTest withEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.evictionStrategy = evictionStrategy;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new StatsMinNodeTest().withStorage(StorageType.OBJECT).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.OBJECT).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.OBJECT).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.REPL_SYNC), new StatsMinNodeTest().withStorage(StorageType.OBJECT).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.REPL_SYNC), new StatsMinNodeTest().withStorage(StorageType.BINARY).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.BINARY).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.BINARY).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.REPL_SYNC), new StatsMinNodeTest().withStorage(StorageType.BINARY).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.REPL_SYNC), new StatsMinNodeTest().withStorage(StorageType.OFF_HEAP).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.OFF_HEAP).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.DIST_SYNC), new StatsMinNodeTest().withStorage(StorageType.OFF_HEAP).withEvictionStrategy(EvictionStrategy.REMOVE).cacheMode(CacheMode.REPL_SYNC), new StatsMinNodeTest().withStorage(StorageType.OFF_HEAP).withEvictionStrategy(EvictionStrategy.EXCEPTION).cacheMode(CacheMode.REPL_SYNC)};
    }

    @Override
    protected String[] parameterNames() {
        return StatsMinNodeTest.concat(super.parameterNames(), "StorageType", "EvictionStrategy");
    }

    @Override
    protected Object[] parameterValues() {
        return StatsMinNodeTest.concat(super.parameterValues(), this.storageType, this.evictionStrategy);
    }

    @Override
    protected String parameters() {
        return "[" + String.valueOf(this.cacheMode) + ", " + String.valueOf(this.storageType) + "," + String.valueOf(this.evictionStrategy) + "]";
    }

    private int handleModeEstimate(int desired, CacheMode mode) {
        if (mode.isReplicated()) {
            return 1;
        }
        return desired;
    }

    @DataProvider(name="capacityTest")
    public static Object[][] capacityArguments() {
        int numOwnerMin = 3;
        int cutOff = 6;
        return (Object[][])IntStream.rangeClosed(0, 10).mapToObj(i -> {
            if (i <= cutOff) {
                return new Object[]{i, numOwnerMin};
            }
            int totalData = i * 3;
            boolean needExtra = totalData % 10 != 0;
            return new Object[]{i, Math.min(5, totalData / 10 + (needExtra ? 1 : 0))};
        }).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="capacityTest")
    public void testCapacity(int inserts, int nodeExpected) {
        this.caches().forEach(c -> {
            DataContainer container = c.getAdvancedCache().getDataContainer();
            Object value = c.getAdvancedCache().getValueDataConversion().toStorage((Object)"foo");
            Metadata metadata = new EmbeddedMetadata.Builder().build();
            for (int i = 0; i < inserts; ++i) {
                Object key = c.getAdvancedCache().getKeyDataConversion().toStorage((Object)i);
                container.put(key, value, metadata);
            }
        });
        ClusterCacheStats stats = TestingUtil.extractComponent(this.cache(0), ClusterCacheStats.class);
        AssertJUnit.assertEquals((int)this.handleModeEstimate(nodeExpected, this.cacheMode), (int)stats.getRequiredMinimumNumberOfNodes());
    }
}

