/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.ReplicatedControlledConsistentHashFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(testName="replication.ForceSyncAsyncFlagsTest", groups={"functional"})
@CleanupAfterMethod
public class ForceSyncAsyncFlagsTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
    }

    public void testForceAsyncFlagUsage() throws Exception {
        ConfigurationBuilder builder = ForceSyncAsyncFlagsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
        this.createClusteredCaches(2, "replSync", builder);
        AdvancedCache cache1 = this.cache(0, "replSync").getAdvancedCache();
        this.cache(1, "replSync").getAdvancedCache();
        Transport originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport mockTransport = (Transport)Mockito.spy((Object)originalTransport);
        rpcManager.setTransport(mockTransport);
        cache1.put((Object)"k", (Object)"v");
        ((Transport)Mockito.verify((Object)mockTransport)).invokeCommandOnAll((Collection)Mockito.any(), (ReplicableCommand)Mockito.any(), (ResponseCollector)Mockito.any(), (DeliverOrder)Mockito.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any()));
        Mockito.reset((Object[])new Transport[]{mockTransport});
        cache1.withFlags(Flag.FORCE_ASYNCHRONOUS).put((Object)"k", (Object)"v");
        ((Transport)Mockito.verify((Object)mockTransport)).sendToAll((ReplicableCommand)Mockito.any(ReplicableCommand.class), (DeliverOrder)Mockito.any(DeliverOrder.class));
    }

    public void testForceSyncFlagUsage() throws Exception {
        ConfigurationBuilder builder = ForceSyncAsyncFlagsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_ASYNC, false);
        builder.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ReplicatedControlledConsistentHashFactory(0, new int[0]));
        this.createClusteredCaches(2, "replAsync", builder);
        AdvancedCache cache1 = this.cache(0, "replAsync").getAdvancedCache();
        this.cache(1, "replAsync").getAdvancedCache();
        Transport originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport mockTransport = (Transport)Mockito.spy((Object)originalTransport);
        rpcManager.setTransport(mockTransport);
        cache1.put((Object)"k", (Object)"v");
        ((Transport)Mockito.verify((Object)mockTransport)).sendToAll((ReplicableCommand)Mockito.any(ReplicableCommand.class), (DeliverOrder)Mockito.any(DeliverOrder.class));
        Mockito.reset((Object[])new Transport[]{mockTransport});
        cache1.withFlags(Flag.FORCE_SYNCHRONOUS).put((Object)"k", (Object)"v");
        ((Transport)Mockito.verify((Object)mockTransport)).invokeCommandOnAll((Collection)Mockito.any(), (ReplicableCommand)Mockito.any(), (ResponseCollector)Mockito.any(), (DeliverOrder)Mockito.any(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any()));
    }
}

