/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.jgroups;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.JChannel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.jgroups.MissingUpHandlerTest")
@CleanupAfterMethod
public class MissingUpHandlerTest
extends MultipleCacheManagersTest {
    protected String cacheName = "replSync";
    protected CacheMode cacheMode = CacheMode.REPL_SYNC;

    @Override
    protected void createCacheManagers() throws Exception {
        ConfigurationBuilder c = MissingUpHandlerTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        c.clustering().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(1, this.cacheName, c);
    }

    public void testExtraChannelWithoutRpcDispatcher() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName);
        cache1.put((Object)"k1", (Object)"v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache1.get((Object)"k1")));
        try (JChannel channel2 = this.createJGroupsChannel(this.manager(0).getCacheManagerConfiguration());){
            cache1.put((Object)"k2", (Object)"v2");
            AssertJUnit.assertEquals((String)"v2", (String)((String)cache1.get((Object)"k2")));
            ConfigurationBuilder c = MissingUpHandlerTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
            c.clustering().stateTransfer().fetchInMemoryState(true);
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(new TransportFlags());
            cm.defineConfiguration(this.cacheName, c.build());
            Cache cache2 = cm.getCache(this.cacheName);
            AssertJUnit.assertEquals((int)2, (int)cache2.getAdvancedCache().getRpcManager().getTransport().getMembers().size());
            AssertJUnit.assertEquals((String)"v1", (String)((String)cache1.get((Object)"k1")));
            AssertJUnit.assertEquals((String)"v2", (String)((String)cache1.get((Object)"k2")));
            cache1.put((Object)"k1", (Object)"v1_2");
            cache2.put((Object)"k2", (Object)"v2_2");
            AssertJUnit.assertEquals((String)"v1_2", (String)((String)cache1.get((Object)"k1")));
            AssertJUnit.assertEquals((String)"v2_2", (String)((String)cache1.get((Object)"k2")));
        }
    }

    private JChannel createJGroupsChannel(GlobalConfiguration oldGC) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().read(oldGC);
        TestCacheManagerFactory.amendTransport(builder);
        GlobalConfiguration gc = builder.build();
        TypedProperties p = gc.transport().properties();
        String jgroupsCfg = p.getProperty("configurationString");
        try {
            JChannel channel = new JChannel((InputStream)new ByteArrayInputStream(jgroupsCfg.getBytes()));
            channel.setName(gc.transport().nodeName());
            channel.connect(gc.transport().clusterName());
            return channel;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

