/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.persistence.sifs.SoftIndexFileStoreTestUtils;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreLockingTest")
public class SoftIndexFileStoreLockingTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "locking-test-cache";
    protected String tmpDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true, dependsOnMethods={"destroyAfterClass"})
    protected void clearTempDir() throws IOException {
        try {
            SoftIndexFileStoreTestUtils.StatsValue statsValue = SoftIndexFileStoreTestUtils.readStatsFile(this.tmpDirectory, CACHE_NAME, log);
            long dataDirectorySize = SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, CACHE_NAME);
            AssertJUnit.assertEquals((long)dataDirectorySize, (long)statsValue.getStatsSize());
        }
        finally {
            Util.recursiveFileRemove((String)this.tmpDirectory);
        }
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.cacheContainer().security().authorization().enable();
        EmbeddedCacheManager ecm = TestCacheManagerFactory.newDefaultCacheManager(false, global, new ConfigurationBuilder());
        TestingUtil.defineConfiguration(ecm, CACHE_NAME, this.createCacheConfiguration().build());
        return ecm;
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)persistence.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString()).maxFileSize(1000).async().enabled(true).purgeOnStartup(false)).preload(preload)).expiration().wakeUpInterval(Long.MAX_VALUE);
        return persistence;
    }

    private ConfigurationBuilder createCacheConfiguration() {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        this.createCacheStoreConfig(cb.persistence(), CACHE_NAME, false);
        return cb;
    }

    public void testOverlappingCacheManagers() throws Throwable {
        Cache c1 = this.cacheManager.getCache(CACHE_NAME);
        c1.put((Object)"key", (Object)"value");
        EmbeddedCacheManager ecm = this.createCacheManager();
        Exceptions.expectException((String)"ISPN029025: Failed acquiring lock .*", () -> ecm.getCache(CACHE_NAME), (Class[])new Class[]{EmbeddedCacheManagerStartupException.class, PersistenceException.class});
        TestingUtil.killCacheManagers(ecm);
        Assertions.assertThat((Object)c1.get((Object)"key")).isEqualTo((Object)"value");
    }

    public void testStartStopDifferentCacheManagers() throws Throwable {
        Cache c1 = this.cacheManager.getCache(CACHE_NAME);
        c1.put((Object)"key", (Object)"value");
        TestingUtil.killCacheManagers(this.cacheManager);
        EmbeddedCacheManager ecm = this.createCacheManager();
        c1 = ecm.getCache(CACHE_NAME);
        Assertions.assertThat((Object)c1.get((Object)"key")).isEqualTo((Object)"value");
        TestingUtil.killCacheManagers(ecm);
    }
}

