/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.globalstate.AbstractGlobalStateRestartTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="globalstate.ThreeNodeGlobalStatePartialRestartTest", groups={"functional"})
public class ThreeNodeGlobalStatePartialRestartTest
extends AbstractGlobalStateRestartTest {
    private PartitionHandling handling;
    private CacheMode cacheMode;
    private boolean purge;

    @Override
    protected int getClusterSize() {
        return 3;
    }

    @Override
    protected void applyCacheManagerClusteringConfiguration(ConfigurationBuilder config) {
        config.clustering().cacheMode(this.cacheMode).hash().numOwners(this.getClusterSize() - 1);
        config.clustering().partitionHandling().whenSplit(this.handling);
    }

    @Override
    protected void applyCacheManagerClusteringConfiguration(String id, ConfigurationBuilder config) {
        this.applyCacheManagerClusteringConfiguration(config);
        SoftIndexFileStoreConfigurationBuilder scb = config.persistence().addSoftIndexFileStore().dataLocation(CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id, "data"})).indexLocation(CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id, "index"}));
        scb.purgeOnStartup(this.purge);
    }

    public void testClusterDelayedJoiners() throws Exception {
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        this.cache(0, "testCache").shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize(); ++i) {
            String persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            Object[] listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        for (i = 0; i < this.getClusterSize() - 1; ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
        }
        TestingUtil.blockUntilViewsReceived(30000, this.getCaches("testCache"));
        this.assertOperationsFail();
        this.createStatefulCacheManager(Character.toString((char)(65 + this.getClusterSize() - 1)), false);
        this.waitForClusterToForm("testCache");
        this.checkClusterRestartedCorrectly(addressMappings);
        this.checkData();
        ConsistentHash newConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        PersistentUUIDManager persistentUUIDManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), PersistentUUIDManager.class);
        this.assertEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager);
    }

    public void testConnectAndDisconnectDuringRestart() throws Exception {
        Object[] listFiles;
        String persistentLocation;
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        this.cache(0, "testCache").shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize(); ++i) {
            persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        for (i = 0; i < this.getClusterSize() - 1; ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
        }
        TestingUtil.blockUntilViewsReceived(30000, this.getCaches("testCache"));
        this.assertOperationsFail();
        EmbeddedCacheManager left = (EmbeddedCacheManager)this.cacheManagers.remove(1);
        TestingUtil.killCacheManagers(left);
        persistentLocation = left.getCacheManagerConfiguration().globalState().persistentLocation();
        listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
        AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        this.assertOperationsFail();
        this.createStatefulCacheManager(Character.toString((char)(65 + this.getClusterSize() - 1)), false);
        TestingUtil.blockUntilViewsReceived(30000, this.getCaches("testCache"));
        this.assertOperationsFail();
        this.createStatefulCacheManager(Character.toString('B'), false);
        this.waitForClusterToForm("testCache");
        this.checkClusterRestartedCorrectly(addressMappings);
        this.checkData();
        ConsistentHash newConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        PersistentUUIDManager persistentUUIDManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), PersistentUUIDManager.class);
        this.assertEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager);
    }

    public void testClusterWithRestartsDuringPartitioning() throws Exception {
        Object[] listFiles;
        String persistentLocation;
        int i;
        Map<JGroupsAddress, PersistentUUID> addressMappings = this.createInitialCluster();
        ConsistentHash oldConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        this.cache(0, "testCache").shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize(); ++i) {
            persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)Arrays.toString(listFiles), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        for (i = 0; i < this.getClusterSize() - 1; ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
        }
        TestingUtil.blockUntilViewsReceived(30000, this.getCaches("testCache"));
        this.assertOperationsFail();
        this.cache(0, "testCache").shutdown();
        TestingUtil.killCacheManagers(this.cacheManagers);
        for (i = 0; i < this.getClusterSize() - 1; ++i) {
            persistentLocation = this.manager(i).getCacheManagerConfiguration().globalState().persistentLocation();
            listFiles = new File(persistentLocation).listFiles((dir, name) -> name.equals("testCache.state"));
            AssertJUnit.assertEquals((String)("Node " + i + " wrong files: " + Arrays.toString(listFiles)), (int)1, (int)listFiles.length);
        }
        this.cacheManagers.clear();
        for (i = 0; i < this.getClusterSize(); ++i) {
            this.createStatefulCacheManager(Character.toString((char)(65 + i)), false);
        }
        this.waitForClusterToForm("testCache");
        this.checkClusterRestartedCorrectly(addressMappings);
        this.checkData();
        ConsistentHash newConsistentHash = this.advancedCache(0, "testCache").getDistributionManager().getWriteConsistentHash();
        PersistentUUIDManager persistentUUIDManager = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), PersistentUUIDManager.class);
        this.assertEquivalent(addressMappings, oldConsistentHash, newConsistentHash, persistentUUIDManager);
    }

    private void assertOperationsFail() {
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            for (int v = 0; v < 100; ++v) {
                Cache cache = this.cache(i, "testCache");
                String key = String.valueOf(v);
                Exceptions.expectException(MissingMembersException.class, (String)"ISPN000689: Recovering cache 'testCache' but there are missing members, known members \\[.*\\] of a total of 3$", () -> cache.get((Object)key));
            }
        }
    }

    public ThreeNodeGlobalStatePartialRestartTest withPartitionHandling(PartitionHandling handling) {
        this.handling = handling;
        return this;
    }

    public ThreeNodeGlobalStatePartialRestartTest withCacheMode(CacheMode mode) {
        this.cacheMode = mode;
        return this;
    }

    public ThreeNodeGlobalStatePartialRestartTest purgeOnStartup(boolean purge) {
        this.purge = purge;
        return this;
    }

    @Override
    public Object[] factory() {
        return Arrays.stream(PartitionHandling.values()).flatMap(ph -> Arrays.stream(new Object[]{new ThreeNodeGlobalStatePartialRestartTest().withCacheMode(CacheMode.DIST_SYNC).withPartitionHandling((PartitionHandling)ph), new ThreeNodeGlobalStatePartialRestartTest().withCacheMode(CacheMode.DIST_SYNC).withPartitionHandling((PartitionHandling)ph).purgeOnStartup(true), new ThreeNodeGlobalStatePartialRestartTest().withCacheMode(CacheMode.REPL_SYNC).withPartitionHandling((PartitionHandling)ph).purgeOnStartup(true), new ThreeNodeGlobalStatePartialRestartTest().withCacheMode(CacheMode.REPL_SYNC).withPartitionHandling((PartitionHandling)ph)})).toArray();
    }

    @Override
    protected String parameters() {
        return String.format("[cacheMode=%s, ph=%s, purge=%b]", this.cacheMode, this.handling, this.purge);
    }
}

