/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadOnlyMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalSimpleTutorialTest")
public class FunctionalSimpleTutorialTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
    }

    public void testSimpleTutorial() throws Exception {
        AdvancedCache cache = this.cacheManager.getCache().getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)cache);
        FunctionalMap.WriteOnlyMap writeOnlyMap = WriteOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        FunctionalMap.ReadOnlyMap readOnlyMap = ReadOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        CompletableFuture writeFuture1 = writeOnlyMap.eval((Object)"key1", (Object)"value1", (SerializableBiConsumer & Serializable)(v, writeView) -> writeView.set(v, new MetaParam.Writable[0]));
        CompletableFuture writeFuture2 = writeOnlyMap.eval((Object)"key2", (Object)"value2", (SerializableBiConsumer & Serializable)(v, writeView) -> writeView.set(v, new MetaParam.Writable[0]));
        CompletionStage readFuture1 = writeFuture1.thenCompose(r -> readOnlyMap.eval((Object)"key1", EntryView.ReadEntryView::get));
        CompletionStage readFuture2 = writeFuture2.thenCompose(r -> readOnlyMap.eval((Object)"key2", EntryView.ReadEntryView::get));
        this.printf("Created entries: %n", new Object[0]);
        CompletionStage end = ((CompletableFuture)readFuture1).thenAcceptBoth(readFuture2, (v1, v2) -> this.printf("key1 = %s%nkey2 = %s%n", v1, v2));
        ((CompletableFuture)end).get();
        FunctionalMap.ReadWriteMap readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key1", "newValue1");
        data.put("key2", "newValue2");
        Traversable previousValues = readWriteMap.evalMany(data, (SerializableBiFunction & Serializable)(v, readWriteView) -> {
            String prev = readWriteView.find().orElse(null);
            readWriteView.set(v, new MetaParam.Writable[]{new MetaParam.MetaLifespan(Duration.ofHours(1L).toMillis())});
            return prev;
        });
        Traversable entryViews = readOnlyMap.evalMany(data.keySet(), (SerializableFunction & Serializable)readOnlyView -> readOnlyView);
        this.printf("Updated entries: %n", new Object[0]);
        entryViews.forEach(view -> this.printf("%s%n", view));
        this.printf("Previous entry values: %n", new Object[0]);
        previousValues.forEach(prev -> this.printf("%s%n", prev));
    }

    private void printf(String format, Object ... args) {
        log.infof(format, args);
    }
}

