/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import jakarta.transaction.RollbackException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.OptimisticPrimaryOwnerCrashDuringPrepareTest")
@CleanupAfterMethod
public class OptimisticPrimaryOwnerCrashDuringPrepareTest
extends MultipleCacheManagersTest {
    public void testPrimaryOwnerCrash() throws Exception {
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "block_prepare", "crash_primary", "resume_prepare");
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v1");
        EmbeddedTransaction tx1 = (EmbeddedTransaction)this.tm(0).suspend();
        tx1.runPrepare();
        StateSequencerUtil.advanceOnInboundRpc(ss, this.cache(1), StateSequencerUtil.matchCommand(VersionedPrepareCommand.class).build()).before("block_prepare", "resume_prepare");
        Future<EmbeddedTransaction> tx2Future = this.fork(() -> {
            this.tm(0).begin();
            this.cache(0).put((Object)"k", (Object)"v2");
            EmbeddedTransaction tx2 = (EmbeddedTransaction)this.tm(0).suspend();
            tx2.runPrepare();
            return tx2;
        });
        ss.enter("crash_primary");
        this.killMember(1);
        ss.exit("crash_primary");
        EmbeddedTransaction tx2 = tx2Future.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)1, (int)tx2.getStatus());
        Exceptions.expectException(RollbackException.class, XAException.class, TimeoutException.class, () -> tx2.runCommit(false));
        tx1.runCommit(false);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.clustering().cacheMode(CacheMode.DIST_SYNC);
        config.transaction().lockingMode(LockingMode.OPTIMISTIC);
        config.clustering().locking().lockAcquisitionTimeout(2L, TimeUnit.SECONDS);
        config.clustering().hash().numSegments(1).consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory.Default(1, 0));
        config.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).cacheStopTimeout(1L, TimeUnit.SECONDS);
        this.createCluster(config, 2);
        this.waitForClusterToForm();
    }
}

