/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.PutMapReturnValueTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class PutMapReturnValueTest
extends MultipleCacheManagersTest {
    private AdvancedCache<Object, String> c1;
    private AdvancedCache<Object, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, PutMapReturnValueTest.getDefaultClusteredCacheConfig(this.cacheMode), 2);
        this.c1 = this.cache(0).getAdvancedCache();
        this.c2 = this.cache(1).getAdvancedCache();
    }

    public void testGetAndPutAll() {
        MagicKey k1 = new MagicKey((Cache<?, ?>)this.c1);
        MagicKey k2 = new MagicKey((Cache<?, ?>)this.c1);
        MagicKey k3 = new MagicKey((Cache<?, ?>)this.c2);
        MagicKey k4 = new MagicKey((Cache<?, ?>)this.c2);
        this.c1.put((Object)k1, (Object)"v1-0");
        this.c2.put((Object)k3, (Object)"v3-0");
        HashMap<MagicKey, String> map = new HashMap<MagicKey, String>();
        map.put(k1, "v1-1");
        map.put(k2, "v2-1");
        map.put(k3, "v3-1");
        map.put(k4, "v4-1");
        Map result = this.c1.getAndPutAll(map);
        Assert.assertNotNull((Object)result);
        AssertJUnit.assertEquals((int)2, (int)result.size());
        AssertJUnit.assertEquals((String)"v1-0", (String)((String)result.get(k1)));
        AssertJUnit.assertEquals((String)"v3-0", (String)((String)result.get(k3)));
        map.put(k1, "v1-2");
        map.put(k2, "v2-2");
        map.put(k3, "v3-2");
        map.put(k4, "v4-2");
        result = this.c1.getAndPutAll(map);
        Assert.assertNotNull((Object)result);
        AssertJUnit.assertEquals((int)4, (int)result.size());
        AssertJUnit.assertEquals((String)"v1-1", (String)((String)result.get(k1)));
        AssertJUnit.assertEquals((String)"v2-1", (String)((String)result.get(k2)));
        AssertJUnit.assertEquals((String)"v3-1", (String)((String)result.get(k3)));
        AssertJUnit.assertEquals((String)"v4-1", (String)((String)result.get(k4)));
        result = this.c1.getAll(map.keySet());
        AssertJUnit.assertEquals((int)4, (int)result.size());
        AssertJUnit.assertEquals((String)"v1-2", (String)((String)result.get(k1)));
        AssertJUnit.assertEquals((String)"v2-2", (String)((String)result.get(k2)));
        AssertJUnit.assertEquals((String)"v3-2", (String)((String)result.get(k3)));
        AssertJUnit.assertEquals((String)"v4-2", (String)((String)result.get(k4)));
    }
}

