/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.TransactionalCacheConfigTest")
public class TransactionalCacheConfigTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneCacheConfig(true));
    }

    public void test() {
        ConfigurationBuilder c = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        assert (!c.build().transaction().transactionMode().isTransactional());
        c.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        assert (c.build().transaction().transactionMode().isTransactional());
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        assert (!c.build().transaction().transactionMode().isTransactional());
    }

    public void testTransactionModeOverride() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        Assert.assertEquals((Object)TransactionMode.TRANSACTIONAL, (Object)this.cacheManager.getCache().getCacheConfiguration().transaction().transactionMode());
        this.cacheManager.defineConfiguration("nonTx", c.build());
        Assert.assertEquals((Object)TransactionMode.NON_TRANSACTIONAL, (Object)this.cacheManager.getCache("nonTx").getCacheConfiguration().transaction().transactionMode());
    }

    public void testDefaults() {
        Configuration c = new ConfigurationBuilder().build();
        assert (!c.transaction().transactionMode().isTransactional());
        c = TestCacheManagerFactory.getDefaultCacheConfiguration(false).build();
        assert (!c.transaction().transactionMode().isTransactional());
        c = TestCacheManagerFactory.getDefaultCacheConfiguration(true).build();
        assert (c.transaction().transactionMode().isTransactional());
        c = TransactionalCacheConfigTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false).build();
        assert (!c.transaction().transactionMode().isTransactional());
        c = TransactionalCacheConfigTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true).build();
        assert (c.transaction().transactionMode().isTransactional());
    }

    public void testTransactionalityInduced() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        Configuration c = cb.build();
        assert (!c.transaction().transactionMode().isTransactional());
        c = cb.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).build();
        assert (c.transaction().transactionMode().isTransactional());
        cb = new ConfigurationBuilder();
        cb.invocationBatching().enable();
        assert (cb.build().transaction().transactionMode().isTransactional());
    }

    public void testInvocationBatchingAndInducedTm() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.invocationBatching().enable();
        assert (cb.build().transaction().transactionMode().isTransactional());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(cb)){

            @Override
            public void call() {
                assert (this.cm.getCache().getAdvancedCache().getTransactionManager() != null);
            }
        });
    }

    public void testOverride() {
        final ConfigurationBuilder c = new ConfigurationBuilder();
        c.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                this.cm.defineConfiguration("transactional", c.build());
                Cache cache = this.cm.getCache("transactional");
                assert (cache.getCacheConfiguration().transaction().transactionMode().isTransactional());
            }
        });
    }

    public void testBatchingAndTransactionalCache() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.invocationBatching().enable();
        final Configuration c = cb.build();
        assert (c.invocationBatching().enabled());
        assert (c.transaction().transactionMode().isTransactional());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder())){

            @Override
            public void call() {
                assert (!this.cm.getCache().getCacheConfiguration().transaction().transactionMode().isTransactional());
                this.cm.defineConfiguration("a", c);
                Cache a = this.cm.getCache("a");
                assert (a.getCacheConfiguration().invocationBatching().enabled());
                assert (a.getCacheConfiguration().transaction().transactionMode().isTransactional());
            }
        });
    }
}

