/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.GetOnRemovedKeyTest")
@InCacheMode(value={CacheMode.REPL_SYNC, CacheMode.DIST_SYNC})
public class GetOnRemovedKeyTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(TestDataSCI.INSTANCE, GetOnRemovedKeyTest.getDefaultClusteredCacheConfig(this.cacheMode, true), 2);
        this.waitForClusterToForm();
    }

    public void testRemoveSeenCorrectly1() throws Throwable {
        Object k = this.getKey();
        this.cache(0).put(k, (Object)"v");
        this.tm(0).begin();
        this.cache(0).remove(k);
        AssertJUnit.assertNull((Object)this.cache(0).get(k));
        this.tm(0).commit();
        AssertJUnit.assertNull((Object)this.cache(0).get(k));
    }

    public void testRemoveSeenCorrectly2() throws Throwable {
        Object k = this.getKey();
        this.cache(0).put(k, (Object)"v");
        this.tm(0).begin();
        this.cache(0).remove(k);
        AssertJUnit.assertNull((Object)this.cache(0).get(k));
        this.tm(0).rollback();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0).get(k));
    }

    protected Object getKey() {
        return this.cacheMode.isDistributed() ? this.getKeyForCache(0) : "k";
    }
}

