/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valuecontext;

import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ValueContext<T, V> {
    protected final ValueContext<?, ?> parentContext;
    private final ExecutableParameterNameProvider parameterNameProvider;
    protected Object currentBean;
    protected MutablePath propertyPath;
    protected Class<?> currentGroup;
    protected Class<?> previousGroup;
    private V currentValue;
    protected Validatable currentValidatable;
    private ConstraintLocation.ConstraintLocationKind constraintLocationKind;

    ValueContext(ValueContext<?, ?> parentContext, ExecutableParameterNameProvider parameterNameProvider, T currentBean, Validatable validatable, MutablePath propertyPath) {
        this.parentContext = parentContext;
        this.parameterNameProvider = parameterNameProvider;
        this.currentBean = currentBean;
        this.currentValidatable = validatable;
        this.propertyPath = propertyPath;
    }

    public final MutablePath getPropertyPath() {
        return this.propertyPath;
    }

    public final Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public final T getCurrentBean() {
        return (T)this.currentBean;
    }

    public Validatable getCurrentValidatable() {
        return this.currentValidatable;
    }

    public final Object getCurrentValidatedValue() {
        return this.currentValue;
    }

    public final void appendNode(Cascadable node) {
        MutablePath newPath = MutablePath.createCopy(this.propertyPath);
        node.appendTo(newPath);
        this.propertyPath = newPath;
    }

    public final void appendNode(ConstraintLocation location) {
        MutablePath newPath = MutablePath.createCopy(this.propertyPath);
        location.appendTo(this.parameterNameProvider, newPath);
        this.propertyPath = newPath;
    }

    public final void appendTypeParameterNode(String nodeName) {
        if (this.propertyPath.needToAddContainerElementNode(nodeName)) {
            MutablePath newPath = MutablePath.createCopy(this.propertyPath);
            newPath.addContainerElementNode(nodeName);
            this.propertyPath = newPath;
        }
    }

    public void appendEmptyNode() {
        MutablePath newPath = MutablePath.createCopy(this.propertyPath);
        newPath.addEmptyNode();
        this.propertyPath = newPath;
    }

    public final void updateNode(ConstraintLocation location) {
        location.applyTo(this.parameterNameProvider, this.propertyPath);
    }

    public final void markCurrentPropertyAsIterable() {
        this.propertyPath.makeLeafNodeIterable();
    }

    public final void markCurrentPropertyAsIterableAndSetKey(Object key) {
        this.propertyPath.makeLeafNodeIterableAndSetMapKey(key);
    }

    public final void markCurrentPropertyAsIterableAndSetIndex(Integer index) {
        this.propertyPath.makeLeafNodeIterableAndSetIndex(index);
    }

    public final void setTypeParameter(Class<?> containerClass, Integer typeParameterIndex) {
        if (containerClass == null) {
            return;
        }
        this.propertyPath.setLeafNodeTypeParameter(containerClass, typeParameterIndex);
    }

    public final void setCurrentGroup(Class<?> currentGroup) {
        if (this.previousGroup != this.currentGroup) {
            this.previousGroup = this.currentGroup;
        }
        this.currentGroup = currentGroup;
    }

    public abstract void markCurrentGroupAsProcessed();

    protected abstract boolean isProcessedForGroup(Class<?> var1);

    public abstract void markConstraintProcessed(MetaConstraint<?> var1);

    public abstract boolean hasMetaConstraintBeenProcessed(MetaConstraint<?> var1);

    public final void setCurrentValidatedValue(V currentValue) {
        this.propertyPath.setLeafNodeValueIfRequired(currentValue);
        this.currentValue = currentValue;
    }

    public final boolean validatingDefault() {
        return this.getCurrentGroup() != null && Group.isDefaultGroup(this.getCurrentGroup());
    }

    public final ConstraintLocation.ConstraintLocationKind getConstraintLocationKind() {
        return this.constraintLocationKind;
    }

    public final void setConstraintLocationKind(ConstraintLocation.ConstraintLocationKind constraintLocationKind) {
        this.constraintLocationKind = constraintLocationKind;
    }

    public final ValueState<V> getCurrentValueState() {
        return new ValueState<V>(this.propertyPath, this.currentValue);
    }

    public final void resetValueState(ValueState<V> valueState) {
        this.propertyPath = valueState.getPropertyPath();
        this.currentValue = valueState.getCurrentValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueContext");
        sb.append("{currentBean=").append(this.currentBean);
        sb.append(", propertyPath=").append(this.propertyPath);
        sb.append(", currentGroup=").append(this.currentGroup);
        sb.append(", currentValue=").append(this.currentValue);
        sb.append(", constraintLocationKind=").append((Object)this.constraintLocationKind);
        sb.append('}');
        return sb.toString();
    }

    public Object getValue(Object parent, ConstraintLocation location) {
        return location.getValue(parent);
    }

    public abstract boolean isBeanAlreadyValidated(Object var1, Class<?> var2);

    public static class ValueState<V> {
        private final MutablePath propertyPath;
        private final V currentValue;

        ValueState(MutablePath propertyPath, V currentValue) {
            this.propertyPath = propertyPath;
            this.currentValue = currentValue;
        }

        public MutablePath getPropertyPath() {
            return this.propertyPath;
        }

        public V getCurrentValue() {
            return this.currentValue;
        }
    }
}

