/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.QueryTimeoutException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmNonEntityIdPropertyEntityLoader<E>
implements HibernateOrmComposableEntityLoader<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String DOCUMENT_ID_SOURCE_PROPERTY_PARAMETER_NAME = "docId";
    private final EntityPersister entityPersister;
    private final String documentIdSourcePropertyName;
    private final ValueReadHandle<?> documentIdSourceHandle;
    private final SessionImplementor session;
    private final MutableEntityLoadingOptions loadingOptions;

    public static EntityLoaderFactory factory(EntityPersister entityPersister, String documentIdSourcePropertyName, ValueReadHandle<?> documentIdSourceHandle) {
        return new Factory(entityPersister, documentIdSourcePropertyName, documentIdSourceHandle);
    }

    private HibernateOrmNonEntityIdPropertyEntityLoader(EntityPersister entityPersister, String documentIdSourcePropertyName, ValueReadHandle<?> documentIdSourceHandle, SessionImplementor session, MutableEntityLoadingOptions loadingOptions) {
        this.entityPersister = entityPersister;
        this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        this.documentIdSourceHandle = documentIdSourceHandle;
        this.session = session;
        this.loadingOptions = loadingOptions;
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference, Deadline deadline) {
        List<E> loadedEntities;
        HashMap<Object, EntityReference> documentIdSourceValueToReference = new HashMap<Object, EntityReference>();
        for (EntityReference reference : references) {
            documentIdSourceValueToReference.put(reference.id(), reference);
        }
        Long timeout = deadline == null ? null : Long.valueOf(deadline.remainingTimeMillis());
        try {
            loadedEntities = this.loadEntities(documentIdSourceValueToReference.keySet(), timeout);
        }
        catch (javax.persistence.LockTimeoutException | javax.persistence.QueryTimeoutException | QueryTimeoutException | LockTimeoutException e) {
            if (deadline == null) {
                throw e;
            }
            throw deadline.forceTimeoutAndCreateException((Exception)e);
        }
        for (E loadedEntity : loadedEntities) {
            Object unproxied = Hibernate.unproxy(loadedEntity);
            Object documentIdSourceValue = this.documentIdSourceHandle.get(unproxied);
            EntityReference reference = (EntityReference)documentIdSourceValueToReference.get(documentIdSourceValue);
            E previous = entitiesByReference.put(reference, loadedEntity);
            if (previous == null) continue;
            throw log.foundMultipleEntitiesForDocumentId(reference.name(), this.documentIdSourcePropertyName, reference.id());
        }
    }

    private List<? extends E> loadEntities(Collection<Object> documentIdSourceValues, Long timeout) {
        int fetchSize = this.loadingOptions.fetchSize();
        if (fetchSize >= documentIdSourceValues.size()) {
            Query<E> query = this.createQuery(fetchSize, timeout);
            query.setParameterList(DOCUMENT_ID_SOURCE_PROPERTY_PARAMETER_NAME, documentIdSourceValues);
            return query.getResultList();
        }
        ArrayList result = new ArrayList(documentIdSourceValues.size());
        ArrayList<Object> ids = new ArrayList<Object>(fetchSize);
        for (Object documentIdSourceValue : documentIdSourceValues) {
            ids.add(documentIdSourceValue);
            if (ids.size() < fetchSize) continue;
            Query<E> query = this.createQuery(fetchSize, timeout);
            query.setParameterList(DOCUMENT_ID_SOURCE_PROPERTY_PARAMETER_NAME, ids);
            result.addAll(query.getResultList());
            ids.clear();
        }
        if (!ids.isEmpty()) {
            Query<E> query = this.createQuery(fetchSize, timeout);
            query.setParameterList(DOCUMENT_ID_SOURCE_PROPERTY_PARAMETER_NAME, ids);
            result.addAll(query.getResultList());
        }
        return result;
    }

    private Query<? extends E> createQuery(int fetchSize, Long timeout) {
        EntityGraphHint<?> entityGraphHint;
        Query<?> query = HibernateOrmUtils.createQueryForLoadByUniqueProperty(this.session, this.entityPersister, this.documentIdSourcePropertyName, DOCUMENT_ID_SOURCE_PROPERTY_PARAMETER_NAME);
        query.setFetchSize(fetchSize);
        if (timeout != null) {
            query.setHint("javax.persistence.query.timeout", (Object)Math.toIntExact(timeout));
        }
        if ((entityGraphHint = this.loadingOptions.entityGraphHintOrNullForType(this.entityPersister)) != null) {
            query.applyGraph(entityGraphHint.graph, entityGraphHint.semantic);
        }
        return query;
    }

    private static class Factory
    implements EntityLoaderFactory {
        private final EntityPersister entityPersister;
        private final String documentIdSourcePropertyName;
        private final ValueReadHandle<?> documentIdSourceHandle;

        private Factory(EntityPersister entityPersister, String documentIdSourcePropertyName, ValueReadHandle<?> documentIdSourceHandle) {
            this.entityPersister = entityPersister;
            this.documentIdSourcePropertyName = documentIdSourcePropertyName;
            this.documentIdSourceHandle = documentIdSourceHandle;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.entityPersister.equals(other.entityPersister) && this.documentIdSourcePropertyName.equals(other.documentIdSourcePropertyName) && this.documentIdSourceHandle.equals(other.documentIdSourceHandle);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entityPersister, this.documentIdSourcePropertyName, this.documentIdSourceHandle);
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<E> create(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            return this.doCreate(targetEntityTypeContext, session, cacheLookupStrategy, loadingOptions);
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<? extends E> create(List<HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            if (targetEntityTypeContexts.size() != 1) {
                throw new AssertionFailure("Attempt to use a criteria-based entity loader with multiple target entity types. There is a bug in Hibernate Search, please report it. Expected entity name: " + this.entityPersister.getEntityName() + " Targeted entity names: " + targetEntityTypeContexts.stream().map(HibernateOrmLoadingIndexedTypeContext::hibernateOrmEntityName).collect(Collectors.toList()));
            }
            return this.doCreate(targetEntityTypeContexts.get(0), session, cacheLookupStrategy, loadingOptions);
        }

        private <E> HibernateOrmComposableEntityLoader<E> doCreate(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            if (!this.entityPersister.equals(targetEntityTypeContext.entityPersister())) {
                throw new AssertionFailure("Attempt to use a criteria-based entity loader with an unexpected target entity type. There is a bug in Hibernate Search, please report it. Expected entity name: " + this.entityPersister.getEntityName() + " Targeted entity name: " + targetEntityTypeContext.hibernateOrmEntityName());
            }
            HibernateOrmNonEntityIdPropertyEntityLoader result = new HibernateOrmNonEntityIdPropertyEntityLoader(this.entityPersister, this.documentIdSourcePropertyName, this.documentIdSourceHandle, session, loadingOptions);
            if (!EntityLoadingCacheLookupStrategy.SKIP.equals((Object)cacheLookupStrategy)) {
                log.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(targetEntityTypeContext.jpaEntityName(), cacheLookupStrategy);
            }
            return result;
        }
    }
}

