/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingMonitor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LoggingMassIndexingMonitor
implements MassIndexingMonitor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final LongAdder totalCounter = new LongAdder();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;

    public LoggingMassIndexingMonitor() {
        this(50);
    }

    public LoggingMassIndexingMonitor(int logAfterNumberOfDocuments) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentsAdded(long increment) {
        long previous = this.documentsDoneCounter.getAndAdd(increment);
        if (this.startTime == 0L) {
            LoggingMassIndexingMonitor loggingMassIndexingMonitor = this;
            synchronized (loggingMassIndexingMonitor) {
                if (this.startTime == 0L) {
                    this.startTime = System.nanoTime();
                }
            }
        }
        long current = previous + increment;
        int period = this.getStatusMessagePeriod();
        if (previous / (long)period < current / (long)period) {
            this.printStatusMessage(this.startTime, this.totalCounter.longValue(), current);
        }
    }

    @Override
    public void documentsBuilt(long number) {
    }

    @Override
    public void entitiesLoaded(long size) {
    }

    @Override
    public void addToTotalCount(long count) {
        this.totalCounter.add(count);
        log.indexingEntities(count);
    }

    @Override
    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.totalCounter.longValue());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long totalTodoCount, long doneCount) {
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        log.indexingProgressRaw(doneCount, elapsedMs);
        float estimateSpeed = (float)doneCount * 1000.0f / (float)elapsedMs;
        float estimatePercentileComplete = (float)doneCount * 100.0f / (float)totalTodoCount;
        log.indexingProgressStats(estimateSpeed, estimatePercentileComplete);
    }
}

