/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg;

import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;

public final class HibernateOrmMapperSettings {
    public static final String PREFIX = "hibernate.search.";
    public static final String ENABLED = "hibernate.search.enabled";
    public static final String AUTOMATIC_INDEXING_STRATEGY = "hibernate.search.automatic_indexing.strategy";
    public static final String AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = "hibernate.search.automatic_indexing.synchronization.strategy";
    public static final String AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = "hibernate.search.automatic_indexing.enable_dirty_check";
    public static final String QUERY_LOADING_CACHE_LOOKUP_STRATEGY = "hibernate.search.query.loading.cache_lookup.strategy";
    public static final String QUERY_LOADING_FETCH_SIZE = "hibernate.search.query.loading.fetch_size";
    public static final String MAPPING_PROCESS_ANNOTATIONS = "hibernate.search.mapping.process_annotations";
    public static final String MAPPING_CONFIGURER = "hibernate.search.mapping.configurer";
    public static final String SCHEMA_MANAGEMENT_STRATEGY = "hibernate.search.schema_management.strategy";

    private HibernateOrmMapperSettings() {
    }

    public static final class Defaults {
        public static final boolean ENABLED = true;
        public static final AutomaticIndexingStrategyName AUTOMATIC_INDEXING_STRATEGY = AutomaticIndexingStrategyName.SESSION;
        public static final BeanReference<AutomaticIndexingSynchronizationStrategy> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = BeanReference.of(AutomaticIndexingSynchronizationStrategy.class, (String)"write-sync");
        public static final boolean AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = true;
        public static final EntityLoadingCacheLookupStrategy QUERY_LOADING_CACHE_LOOKUP_STRATEGY = EntityLoadingCacheLookupStrategy.SKIP;
        public static final int QUERY_LOADING_FETCH_SIZE = 100;
        public static final boolean MAPPING_PROCESS_ANNOTATIONS = true;
        public static final SchemaManagementStrategyName SCHEMA_MANAGEMENT_STRATEGY = SchemaManagementStrategyName.CREATE_OR_VALIDATE;

        private Defaults() {
        }
    }

    public static final class Radicals {
        public static final String ENABLED = "enabled";
        public static final String AUTOMATIC_INDEXING_STRATEGY = "automatic_indexing.strategy";
        public static final String AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = "automatic_indexing.synchronization.strategy";
        public static final String AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = "automatic_indexing.enable_dirty_check";
        public static final String QUERY_LOADING_CACHE_LOOKUP_STRATEGY = "query.loading.cache_lookup.strategy";
        public static final String QUERY_LOADING_FETCH_SIZE = "query.loading.fetch_size";
        public static final String MAPPING_PROCESS_ANNOTATIONS = "mapping.process_annotations";
        public static final String MAPPING_CONFIGURER = "mapping.configurer";
        public static final String SCHEMA_MANAGEMENT_STRATEGY = "schema_management.strategy";

        private Radicals() {
        }
    }
}

