/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.query.fieldcache.DoubleFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.FloatFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.IntFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.LongFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.StringFieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FieldCacheLoadingType {
    STRING{

        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new StringFieldLoadingStrategy(fieldName);
        }
    }
    ,
    INT{

        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new IntFieldLoadingStrategy(fieldName);
        }
    }
    ,
    LONG{

        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new LongFieldLoadingStrategy(fieldName);
        }
    }
    ,
    DOUBLE{

        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new DoubleFieldLoadingStrategy(fieldName);
        }
    }
    ,
    FLOAT{

        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new FloatFieldLoadingStrategy(fieldName);
        }
    };

    static Map<Class<?>, FieldCacheLoadingType> fieldCacheTypes;

    public abstract FieldLoadingStrategy createLoadingStrategy(String var1);

    public static FieldLoadingStrategy getLoadingStrategy(String fieldName, Class<?> type) {
        return fieldCacheTypes.get(type).createLoadingStrategy(fieldName);
    }

    static {
        fieldCacheTypes = new HashMap();
        fieldCacheTypes.put(String.class, STRING);
        fieldCacheTypes.put(Integer.class, INT);
        fieldCacheTypes.put(Long.class, LONG);
        fieldCacheTypes.put(Double.class, DOUBLE);
        fieldCacheTypes.put(Float.class, FLOAT);
    }
}

