/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.hibernate.QueryTimeoutException;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.IndexSearcherWithPayload;
import org.hibernate.search.query.TimeoutManager;

public class QueryHits {
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    public final Query preparedQuery;
    public final IndexSearcherWithPayload searcher;
    public final Filter filter;
    public final Sort sort;
    public int totalHits;
    public TopDocs topDocs;
    private TimeoutManager timeoutManager;

    public QueryHits(IndexSearcherWithPayload searcher, Query preparedQuery, Filter filter, Sort sort, TimeoutManager timeoutManager) throws IOException {
        this(searcher, preparedQuery, filter, sort, 100, timeoutManager);
    }

    public QueryHits(IndexSearcherWithPayload searcher, Query preparedQuery, Filter filter, Sort sort, Integer n, TimeoutManager timeoutManager) throws IOException {
        this.timeoutManager = timeoutManager;
        this.preparedQuery = preparedQuery;
        this.searcher = searcher;
        this.filter = filter;
        this.sort = sort;
        this.updateTopDocs(n);
        this.totalHits = this.topDocs.totalHits;
    }

    public Document doc(int index) throws IOException {
        return this.searcher.getSearcher().doc(this.docId(index));
    }

    public Document doc(int index, FieldSelector selector) throws IOException {
        return this.searcher.getSearcher().doc(this.docId(index), selector);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        if (this.timeoutManager.isTimedOut() && index >= this.topDocs.scoreDocs.length) {
            throw new QueryTimeoutException("Timeout period exceeded. Cannot load document: " + index, (SQLException)null, this.preparedQuery.toString());
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Explanation explain(int index) throws IOException {
        Explanation explanation = this.searcher.getSearcher().explain(this.preparedQuery, this.docId(index));
        this.timeoutManager.isTimedOut();
        return explanation;
    }

    private boolean updateTopDocs(int n) throws IOException {
        TopScoreDocCollector topCollector;
        int maxDocs = Math.min(n, this.searcher.getSearcher().maxDoc());
        Weight weight = this.preparedQuery.weight((Searcher)this.searcher.getSearcher());
        if (this.sort == null) {
            topCollector = TopScoreDocCollector.create((int)maxDocs, (!weight.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        } else {
            boolean fillFields = true;
            topCollector = TopFieldCollector.create((Sort)this.sort, (int)maxDocs, (boolean)fillFields, (boolean)this.searcher.isFieldSortDoTrackScores(), (boolean)this.searcher.isFieldSortDoMaxScore(), (!weight.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        }
        TopScoreDocCollector maybeTimeLimitingCollector = topCollector;
        boolean timeoutAt0 = false;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT) {
            Long timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds();
            if (timeoutLeft != null) {
                if (timeoutLeft == 0L && this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && this.timeoutManager.isTimedOut()) {
                    this.timeoutManager.forceTimedOut();
                    timeoutAt0 = true;
                }
                maybeTimeLimitingCollector = new TimeLimitingCollector((Collector)topCollector, timeoutLeft.longValue());
            } else if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && this.timeoutManager.isTimedOut()) {
                this.timeoutManager.forceTimedOut();
            }
        }
        try {
            if (!timeoutAt0) {
                this.searcher.getSearcher().search(weight, this.filter, (Collector)maybeTimeLimitingCollector);
            }
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            this.timeoutManager.forceTimedOut();
            this.topDocs = topCollector.topDocs();
        }
        this.topDocs = topCollector.topDocs();
        return this.timeoutManager.isTimedOut();
    }
}

