/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.SearchFactoryImpl;

public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
Initializable {
    private static final Log log = LogFactory.getLog(FullTextIndexEventListener.class);
    private boolean used;
    private SearchFactoryImplementor searchFactoryImplementor;

    public void initialize(Configuration cfg) {
        this.searchFactoryImplementor = SearchFactoryImpl.getSearchFactory(cfg);
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if ("event".equals(indexingStrategy)) {
            this.used = this.searchFactoryImplementor.getDocumentBuilders().size() != 0;
        } else if ("manual".equals(indexingStrategy)) {
            this.used = false;
        } else {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.used && this.searchFactoryImplementor.getDocumentBuilders().containsKey(event.getEntity().getClass())) {
            this.processWork(event.getEntity(), event.getId(), WorkType.DELETE, (AbstractEvent)event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.used) {
            Object entity = event.getEntity();
            DocumentBuilder<Object> builder = this.searchFactoryImplementor.getDocumentBuilders().get(entity.getClass());
            if (builder != null) {
                Serializable id = event.getId();
                this.processWork(entity, id, WorkType.ADD, (AbstractEvent)event);
            }
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.used) {
            Object entity = event.getEntity();
            DocumentBuilder<Object> builder = this.searchFactoryImplementor.getDocumentBuilders().get(entity.getClass());
            if (builder != null) {
                Serializable id = event.getId();
                this.processWork(entity, id, WorkType.UPDATE, (AbstractEvent)event);
            }
        }
    }

    private void processWork(Object entity, Serializable id, WorkType workType, AbstractEvent event) {
        Work work = new Work(entity, id, workType);
        this.searchFactoryImplementor.getWorker().performWork(work, event.getSession());
    }
}

