/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class DeleteWorkExecutor
implements LuceneWorkExecutor {
    private static final Log log = LoggerFactory.make();
    protected final Workspace workspace;

    DeleteWorkExecutor(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        Query idQueryTerm;
        IndexedTypeIdentifier entityType = work.getEntityType();
        Serializable id = work.getId();
        log.tracef("Removing %s#%s by query.", entityType, id);
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(entityType);
        BooleanQuery.Builder entityDeletionQueryBuilder = new BooleanQuery.Builder();
        if (DeleteWorkExecutor.isIdNumeric(builder)) {
            idQueryTerm = NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id);
        } else {
            Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
            idQueryTerm = new TermQuery(idTerm);
        }
        entityDeletionQueryBuilder.add(idQueryTerm, BooleanClause.Occur.FILTER);
        Term classNameQueryTerm = new Term("_hibernate_class", entityType.getName());
        TermQuery classNameQuery = new TermQuery(classNameQueryTerm);
        entityDeletionQueryBuilder.add((Query)classNameQuery, BooleanClause.Occur.FILTER);
        this.addTenantQueryTerm(work.getTenantId(), entityDeletionQueryBuilder);
        try {
            BooleanQuery entityDeletionQuery = entityDeletionQueryBuilder.build();
            delegate.deleteDocuments((Query)entityDeletionQuery);
        }
        catch (Exception e) {
            String message = "Unable to remove " + entityType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
        this.workspace.notifyWorkApplied(work);
    }

    private void addTenantQueryTerm(String tenantId, BooleanQuery.Builder queryBuilder) {
        if (tenantId != null) {
            Term tenantTerm = new Term("__HSearch_TenantId", tenantId);
            queryBuilder.add((Query)new TermQuery(tenantTerm), BooleanClause.Occur.FILTER);
        }
    }

    protected static boolean isIdNumeric(DocumentBuilderIndexedEntity documentBuilder) {
        TwoWayFieldBridge idBridge = documentBuilder.getIdBridge();
        return idBridge instanceof NumericFieldBridge;
    }
}

