/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.collector.impl.FacetsCollectorDecorator;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceCollector;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class QueryHits {
    private static final Log log = LoggerFactory.make();
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    private static final int DEFAULT_FACET_RETRIEVAL_SIZE = 100;
    private static final EnumMap<FacetSortOrder, FacetComparator> facetComparators = new EnumMap(FacetSortOrder.class);
    private final LazyQueryState searcher;
    private final Filter filter;
    private final Sort sort;
    private final Map<String, FacetingRequestImpl> facetRequests;
    private final TimeoutManagerImpl timeoutManager;
    private int totalHits;
    private TopDocs topDocs;
    private Map<String, List<Facet>> facetMap;
    private FacetsCollector facetsCollector;
    private DistanceCollector distanceCollector = null;
    private Coordinates spatialSearchCenter = null;
    private String spatialFieldName = null;
    private final TimeoutExceptionFactory timeoutExceptionFactory;

    public QueryHits(LazyQueryState searcher, Filter filter, Sort sort, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, TimeoutExceptionFactory timeoutExceptionFactory, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this(searcher, filter, sort, 100, timeoutManager, facetRequests, timeoutExceptionFactory, spatialSearchCenter, spatialFieldName);
    }

    public QueryHits(LazyQueryState searcher, Filter filter, Sort sort, Integer n, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, TimeoutExceptionFactory timeoutExceptionFactory, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this.timeoutManager = timeoutManager;
        this.searcher = searcher;
        this.filter = filter;
        this.sort = sort;
        this.facetRequests = facetRequests;
        this.timeoutExceptionFactory = timeoutExceptionFactory;
        this.spatialSearchCenter = spatialSearchCenter;
        this.spatialFieldName = spatialFieldName;
        this.updateTopDocs(n);
    }

    public Document doc(int index) throws IOException {
        return this.searcher.doc(this.docId(index));
    }

    public void visitDocument(int index, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(this.docId(index), fieldVisitor);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        if (this.timeoutManager.isTimedOut() && index >= this.topDocs.scoreDocs.length) {
            throw this.timeoutExceptionFactory.createTimeoutException("Timeout period exceeded. Cannot load document: " + index, this.searcher.describeQuery());
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Double spatialDistance(int index) throws IOException {
        if (this.spatialSearchCenter == null) {
            return null;
        }
        return this.distanceCollector.getDistance(this.docId(index));
    }

    public Explanation explain(int index) throws IOException {
        Explanation explanation = this.searcher.explain(this.docId(index));
        this.timeoutManager.isTimedOut();
        return explanation;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    public Map<String, List<Facet>> getFacets() {
        if (this.facetRequests == null || this.facetRequests.size() == 0) {
            return Collections.emptyMap();
        }
        return this.facetMap;
    }

    private void updateTopDocs(int n) throws IOException {
        TotalHitCountCollector collector;
        TotalHitCountCollector hitCountCollector;
        TotalHitCountCollector topDocCollector;
        int totalMaxDocs = this.searcher.maxDoc();
        int maxDocs = Math.min(n, totalMaxDocs);
        if (maxDocs != 0) {
            topDocCollector = this.createTopDocCollector(maxDocs);
            hitCountCollector = null;
            collector = topDocCollector;
            collector = this.optionallyEnableFacetingCollector((Collector)collector);
            collector = this.optionallyEnableDistanceCollector((Collector)collector, maxDocs);
        } else {
            topDocCollector = null;
            collector = hitCountCollector = new TotalHitCountCollector();
        }
        collector = this.decorateWithTimeOutCollector((Collector)collector);
        boolean timeoutNow = this.isImmediateTimeout();
        if (!timeoutNow) {
            try {
                this.searcher.search(this.filter, (Collector)collector);
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                this.timeoutManager.forceTimedOut();
            }
        }
        if (maxDocs != 0) {
            this.topDocs = topDocCollector.topDocs();
            this.totalHits = this.topDocs.totalHits;
            if (this.facetsCollector != null) {
                this.updateFacets();
            }
        } else {
            this.topDocs = null;
            this.totalHits = hitCountCollector.getTotalHits();
        }
        this.timeoutManager.isTimedOut();
    }

    private void updateFacets() throws IOException {
        this.facetMap = new HashMap<String, List<Facet>>();
        for (FacetingRequestImpl facetRequest : this.facetRequests.values()) {
            int maxNumberOfExpectedFacets;
            ArrayList<Facet> facets = facetRequest instanceof DiscreteFacetRequest ? this.updateStringFacets((DiscreteFacetRequest)facetRequest) : this.updateRangeFacets((RangeFacetRequest)facetRequest);
            if (!facetRequest.getSort().equals((Object)FacetSortOrder.RANGE_DEFINITION_ORDER)) {
                Collections.sort(facets, facetComparators.get((Object)facetRequest.getSort()));
            }
            if ((maxNumberOfExpectedFacets = facetRequest.getMaxNumberOfFacets()) > 0 && facets.size() > maxNumberOfExpectedFacets) {
                facets = new ArrayList<Facet>(facets.subList(0, facetRequest.getMaxNumberOfFacets()));
            }
            this.facetMap.put(facetRequest.getFacetingName(), facets);
        }
    }

    private ArrayList<Facet> updateRangeFacets(RangeFacetRequest<?> facetRequest) throws IOException {
        ArrayList<Facet> facets;
        if (ReflectionHelper.isIntegerType(facetRequest.getFacetValueType()) || Date.class.isAssignableFrom(facetRequest.getFacetValueType())) {
            FacetResult facetResult = this.getFacetResultForLongRange(facetRequest);
            facets = new ArrayList<Facet>(facetResult.labelValues.length);
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                Facet facet = facetRequest.createFacet(labelAndValue.label, (Integer)labelAndValue.value);
                facets.add(facet);
            }
        } else if (ReflectionHelper.isFloatingPointType(facetRequest.getFacetValueType())) {
            FacetResult facetResult = this.getFacetResultForFloatingPointRange(facetRequest);
            facets = new ArrayList(facetResult.labelValues.length);
            for (LabelAndValue labelAndValue : facetResult.labelValues) {
                if (!facetRequest.hasZeroCountsIncluded() && (Integer)labelAndValue.value == 0) continue;
                Facet facet = facetRequest.createFacet(labelAndValue.label, (Integer)labelAndValue.value);
                facets.add(facet);
            }
        } else {
            throw log.unsupportedFacetRangeParameter(facetRequest.getFacetValueType().getName());
        }
        return facets;
    }

    private FacetResult getFacetResultForFloatingPointRange(RangeFacetRequest<?> facetRequest) throws IOException {
        List<FacetRange<?>> facetRanges = facetRequest.getFacetRangeList();
        DoubleRange[] ranges = new DoubleRange[facetRanges.size()];
        int i = 0;
        for (FacetRange<?> facetRange : facetRanges) {
            ranges[i] = new DoubleRange(facetRange.getRangeString(), facetRange.getMin() == null ? Double.MIN_VALUE : ((Number)facetRange.getMin()).doubleValue(), facetRange.isMinIncluded(), facetRange.getMax() == null ? Double.MAX_VALUE : ((Number)facetRange.getMax()).doubleValue(), facetRange.isMaxIncluded());
            ++i;
        }
        DoubleRangeFacetCounts facetCount = new DoubleRangeFacetCounts(facetRequest.getFieldName(), this.facetsCollector, ranges);
        return facetCount.getTopChildren(facetRequest.getMaxNumberOfFacets(), facetRequest.getFieldName(), new String[0]);
    }

    private FacetResult getFacetResultForLongRange(RangeFacetRequest<?> facetRequest) throws IOException {
        List<FacetRange<?>> facetRanges = facetRequest.getFacetRangeList();
        LongRange[] ranges = new LongRange[facetRanges.size()];
        int i = 0;
        for (FacetRange<?> facetRange : facetRanges) {
            long max;
            long min;
            if (ReflectionHelper.isIntegerType(facetRequest.getFacetValueType())) {
                min = facetRange.getMin() == null ? Long.MIN_VALUE : ((Number)facetRange.getMin()).longValue();
                max = facetRange.getMax() == null ? Long.MAX_VALUE : ((Number)facetRange.getMax()).longValue();
            } else {
                min = facetRange.getMin() == null ? Long.MIN_VALUE : ((Date)facetRange.getMin()).getTime();
                max = facetRange.getMax() == null ? Long.MAX_VALUE : ((Date)facetRange.getMax()).getTime();
            }
            ranges[i] = new LongRange(facetRange.getRangeString(), min, facetRange.isMinIncluded(), max, facetRange.isMaxIncluded());
            ++i;
        }
        LongRangeFacetCounts facetCount = new LongRangeFacetCounts(facetRequest.getFieldName(), this.facetsCollector, ranges);
        return facetCount.getTopChildren(facetRequest.getMaxNumberOfFacets(), facetRequest.getFieldName(), new String[0]);
    }

    private ArrayList<Facet> updateStringFacets(DiscreteFacetRequest facetRequest) throws IOException {
        FacetResult facetResult;
        DefaultSortedSetDocValuesReaderState docValuesReaderState;
        try {
            docValuesReaderState = new DefaultSortedSetDocValuesReaderState(this.searcher.getIndexReader());
        }
        catch (IllegalArgumentException e) {
            throw log.unknownFieldNameForFaceting(facetRequest.getFacetingName(), facetRequest.getFieldName());
        }
        SortedSetDocValuesFacetCounts facetCounts = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)docValuesReaderState, this.facetsCollector);
        Set<Object> termValues = Collections.emptySet();
        if (facetRequest.hasZeroCountsIncluded()) {
            termValues = this.findAllTermsForField(facetRequest.getFieldName(), this.searcher.getIndexReader());
        }
        int maxFacetCount = facetRequest.getMaxNumberOfFacets() < 0 ? 100 : facetRequest.getMaxNumberOfFacets();
        try {
            facetResult = facetCounts.getTopChildren(maxFacetCount, facetRequest.getFieldName(), new String[0]);
        }
        catch (IllegalArgumentException e) {
            throw log.unknownFieldNameForFaceting(facetRequest.getFacetingName(), facetRequest.getFieldName());
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (LabelAndValue labelAndValue : facetResult.labelValues) {
            Facet facet = facetRequest.createFacet(labelAndValue.label, (Integer)labelAndValue.value);
            facets.add(facet);
            termValues.remove(labelAndValue.label);
        }
        for (String string : termValues) {
            Facet facet = facetRequest.createFacet(string, 0);
            facets.add(0, facet);
        }
        return facets;
    }

    private Set<String> findAllTermsForField(String fieldName, IndexReader reader) throws IOException {
        HashSet<String> termValues = new HashSet<String>();
        for (AtomicReaderContext leaf : reader.leaves()) {
            BytesRef byteRef;
            AtomicReader atomicReader = leaf.reader();
            Terms terms = atomicReader.terms(fieldName);
            if (terms == null) continue;
            TermsEnum iterator = terms.iterator(null);
            while ((byteRef = iterator.next()) != null) {
                termValues.add(byteRef.utf8ToString());
            }
        }
        return termValues;
    }

    private Collector optionallyEnableFacetingCollector(Collector collector) {
        if (this.facetRequests == null || this.facetRequests.isEmpty()) {
            return collector;
        }
        this.facetsCollector = new FacetsCollector();
        return new FacetsCollectorDecorator(this.facetsCollector, collector);
    }

    private Collector optionallyEnableDistanceCollector(Collector collector, int maxDocs) {
        if (this.spatialFieldName == null || this.spatialFieldName.isEmpty() || this.spatialSearchCenter == null) {
            return collector;
        }
        this.distanceCollector = new DistanceCollector(collector, this.spatialSearchCenter, maxDocs, this.spatialFieldName);
        return this.distanceCollector;
    }

    private boolean isImmediateTimeout() {
        boolean timeoutAt0 = false;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT) {
            Long timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds();
            if (timeoutLeft != null) {
                if (timeoutLeft == 0L && this.timeoutManager.isTimedOut()) {
                    this.timeoutManager.forceTimedOut();
                    timeoutAt0 = true;
                }
            } else if (this.timeoutManager.isTimedOut()) {
                this.timeoutManager.forceTimedOut();
            }
        }
        return timeoutAt0;
    }

    private Collector decorateWithTimeOutCollector(Collector collector) {
        Long timeoutLeft;
        Collector maybeTimeLimitingCollector = collector;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && (timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds()) != null) {
            Counter counter = this.timeoutManager.getLuceneTimeoutCounter();
            maybeTimeLimitingCollector = new TimeLimitingCollector(collector, counter, timeoutLeft.longValue());
        }
        return maybeTimeLimitingCollector;
    }

    private TopDocsCollector<?> createTopDocCollector(int maxDocs) throws IOException {
        TopScoreDocCollector topCollector;
        if (this.sort == null) {
            topCollector = TopScoreDocCollector.create((int)maxDocs, (!this.searcher.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        } else {
            boolean fillFields = true;
            topCollector = TopFieldCollector.create((Sort)this.sort, (int)maxDocs, (boolean)fillFields, (boolean)this.searcher.isFieldSortDoTrackScores(), (boolean)this.searcher.isFieldSortDoMaxScore(), (!this.searcher.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        }
        return topCollector;
    }

    static {
        facetComparators.put(FacetSortOrder.COUNT_ASC, new FacetComparator(FacetSortOrder.COUNT_ASC));
        facetComparators.put(FacetSortOrder.COUNT_DESC, new FacetComparator(FacetSortOrder.COUNT_DESC));
        facetComparators.put(FacetSortOrder.FIELD_VALUE, new FacetComparator(FacetSortOrder.FIELD_VALUE));
    }

    public static class FacetComparator
    implements Comparator<Facet>,
    Serializable {
        private final FacetSortOrder sortOder;

        public FacetComparator(FacetSortOrder sortOrder) {
            this.sortOder = sortOrder;
        }

        @Override
        public int compare(Facet facet1, Facet facet2) {
            if (FacetSortOrder.COUNT_ASC.equals((Object)this.sortOder)) {
                return facet1.getCount() - facet2.getCount();
            }
            if (FacetSortOrder.COUNT_DESC.equals((Object)this.sortOder)) {
                return facet2.getCount() - facet1.getCount();
            }
            return facet1.getValue().compareTo(facet2.getValue());
        }
    }
}

