/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.works.IndexUpdateVisitor;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LuceneBackendResources {
    private static final Log log = LoggerFactory.make();
    private volatile IndexWorkVisitor<Void, LuceneWorkExecutor> workVisitor;
    private final AbstractWorkspaceImpl workspace;
    private final ErrorHandler errorHandler;
    private final int maxQueueLength;
    private final String indexName;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private volatile ExecutorService asyncIndexingExecutor;

    LuceneBackendResources(WorkerBuildContext context, DirectoryBasedIndexManager indexManager, Properties props, AbstractWorkspaceImpl workspace) {
        this.indexName = indexManager.getIndexName();
        this.errorHandler = context.getErrorHandler();
        this.workspace = workspace;
        this.maxQueueLength = PropertiesParseHelper.extractMaxQueueSize(this.indexName, props);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    private LuceneBackendResources(LuceneBackendResources previous) {
        this.indexName = previous.indexName;
        this.errorHandler = previous.errorHandler;
        this.workspace = previous.workspace;
        this.maxQueueLength = previous.maxQueueLength;
        this.asyncIndexingExecutor = previous.asyncIndexingExecutor;
        this.readLock = previous.readLock;
        this.writeLock = previous.writeLock;
    }

    public ExecutorService getAsynchIndexingExecutor() {
        ExecutorService executor = this.asyncIndexingExecutor;
        if (executor != null) {
            return executor;
        }
        return this.getAsynchIndexingExecutorSynchronized();
    }

    private synchronized ExecutorService getAsynchIndexingExecutorSynchronized() {
        ExecutorService executor = this.asyncIndexingExecutor;
        if (executor != null) {
            return executor;
        }
        this.asyncIndexingExecutor = Executors.newFixedThreadPool(1, "Index updates queue processor for index " + this.indexName, this.maxQueueLength);
        return this.asyncIndexingExecutor;
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexWorkVisitor<Void, LuceneWorkExecutor> getWorkVisitor() {
        if (this.workVisitor == null) {
            this.workVisitor = new IndexUpdateVisitor(this.workspace);
        }
        return this.workVisitor;
    }

    public AbstractWorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.flushCloseExecutor();
        }
        finally {
            this.workspace.shutDownNow();
        }
    }

    private void flushCloseExecutor() {
        if (this.asyncIndexingExecutor == null) {
            return;
        }
        this.asyncIndexingExecutor.shutdown();
        try {
            this.asyncIndexingExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(e);
            Thread.currentThread().interrupt();
        }
        if (!this.asyncIndexingExecutor.isTerminated()) {
            log.unableToShutdownAsynchronousIndexingByTimeout(this.indexName);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Lock getParallelModificationLock() {
        return this.readLock;
    }

    public Lock getExclusiveModificationLock() {
        return this.writeLock;
    }

    public LuceneBackendResources onTheFlyRebuild() {
        return new LuceneBackendResources(this);
    }
}

