/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.AccessTypeInformation;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.MetaModelGenerationException;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlMetaCollection;
import org.hibernate.jpamodelgen.xml.XmlMetaMap;
import org.hibernate.jpamodelgen.xml.XmlMetaSingleAttribute;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Attributes;
import org.hibernate.jpamodelgen.xml.jaxb.Basic;
import org.hibernate.jpamodelgen.xml.jaxb.ElementCollection;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.EmbeddableAttributes;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.Id;
import org.hibernate.jpamodelgen.xml.jaxb.ManyToMany;
import org.hibernate.jpamodelgen.xml.jaxb.ManyToOne;
import org.hibernate.jpamodelgen.xml.jaxb.MapKeyClass;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.OneToMany;
import org.hibernate.jpamodelgen.xml.jaxb.OneToOne;

public class XmlMetaEntity
implements MetaEntity {
    static Map<String, String> COLLECTIONS = new HashMap<String, String>();
    protected final String clazzName;
    protected final String packageName;
    protected final String defaultPackageName;
    protected final ImportContext importContext;
    protected final List<MetaAttribute> members = new ArrayList<MetaAttribute>();
    protected final TypeElement element;
    protected final Context context;
    protected final boolean isMetaComplete;
    private Attributes attributes;
    private EmbeddableAttributes embeddableAttributes;
    protected AccessTypeInformation accessTypeInfo;

    public XmlMetaEntity(Entity ormEntity, String defaultPackageName, TypeElement element, Context context) {
        this(ormEntity.getClazz(), defaultPackageName, element, context, ormEntity.isMetadataComplete());
        this.attributes = ormEntity.getAttributes();
        this.embeddableAttributes = null;
        this.init();
    }

    protected XmlMetaEntity(MappedSuperclass mappedSuperclass, String defaultPackageName, TypeElement element, Context context) {
        this(mappedSuperclass.getClazz(), defaultPackageName, element, context, mappedSuperclass.isMetadataComplete());
        this.attributes = mappedSuperclass.getAttributes();
        this.embeddableAttributes = null;
        this.init();
    }

    protected XmlMetaEntity(Embeddable embeddable, String defaultPackageName, TypeElement element, Context context) {
        this(embeddable.getClazz(), defaultPackageName, element, context, embeddable.isMetadataComplete());
        this.attributes = null;
        this.embeddableAttributes = embeddable.getAttributes();
    }

    private XmlMetaEntity(String clazz, String defaultPackageName, TypeElement element, Context context, Boolean metaComplete) {
        this.defaultPackageName = defaultPackageName;
        String className = clazz;
        String pkg = defaultPackageName;
        if (StringUtil.isFullyQualified(className)) {
            pkg = StringUtil.packageNameFromFqcn(className);
            className = StringUtil.classNameFromFqcn(clazz);
        }
        this.clazzName = className;
        this.packageName = pkg;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
        this.element = element;
        this.isMetaComplete = this.initIsMetaComplete(metaComplete);
    }

    protected void init() {
        this.accessTypeInfo = this.context.getAccessTypeInfo(this.getQualifiedName());
        if (this.attributes != null) {
            this.parseAttributes(this.attributes);
        } else {
            this.parseEmbeddableAttributes(this.embeddableAttributes);
        }
    }

    @Override
    public String getSimpleName() {
        return this.clazzName;
    }

    @Override
    public String getQualifiedName() {
        return this.packageName + "." + this.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public List<MetaAttribute> getMembers() {
        return this.members;
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public String importType(Name qualifiedName) {
        return this.importType(qualifiedName.toString());
    }

    @Override
    public TypeElement getTypeElement() {
        return this.element;
    }

    @Override
    public boolean isMetaComplete() {
        return this.isMetaComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaEntity");
        sb.append("{accessTypeInfo=").append(this.accessTypeInfo);
        sb.append(", clazzName='").append(this.clazzName).append('\'');
        sb.append(", members=").append(this.members);
        sb.append(", isMetaComplete=").append(this.isMetaComplete);
        sb.append('}');
        return sb.toString();
    }

    private boolean initIsMetaComplete(Boolean metadataComplete) {
        return this.context.isPersistenceUnitCompletelyXmlConfigured() || Boolean.TRUE.equals(metadataComplete);
    }

    private String[] getCollectionTypes(String propertyName, String explicitTargetEntity, String explicitMapKeyClass, ElementKind expectedElementKind) {
        String[] types = new String[3];
        for (Element element : this.element.getEnclosedElements()) {
            if (expectedElementKind.equals((Object)element.getKind()) || !element.getSimpleName().toString().equals(propertyName)) continue;
            DeclaredType type = (DeclaredType)element.asType();
            this.determineTargetType(type, propertyName, explicitTargetEntity, types);
            this.determineCollectionType(type, types);
            if (types[1].equals("javax.persistence.metamodel.MapAttribute")) {
                this.determineMapType(type, explicitMapKeyClass, types);
            }
            return types;
        }
        return null;
    }

    private void determineMapType(DeclaredType type, String explicitMapKeyClass, String[] types) {
        types[2] = explicitMapKeyClass != null ? explicitMapKeyClass : TypeUtils.getKeyType(type, this.context);
    }

    private void determineCollectionType(DeclaredType type, String[] types) {
        types[1] = COLLECTIONS.get(type.asElement().toString());
    }

    private void determineTargetType(DeclaredType type, String propertyName, String explicitTargetEntity, String[] types) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == 0 && explicitTargetEntity == null) {
            throw new MetaModelGenerationException("Unable to determine target entity type for " + this.clazzName + "." + propertyName + ".");
        }
        types[0] = explicitTargetEntity == null ? TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), this.context) : explicitTargetEntity;
    }

    private String getType(String propertyName, String explicitTargetEntity, ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            TypeMirror mirror;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String name = element.getSimpleName().toString();
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                name = StringUtil.getPropertyName(name);
                mirror = ((ExecutableElement)element).getReturnType();
            } else {
                mirror = element.asType();
            }
            if (name == null || !name.equals(propertyName)) continue;
            if (explicitTargetEntity != null) {
                return explicitTargetEntity;
            }
            switch (mirror.getKind()) {
                case INT: {
                    return "java.lang.Integer";
                }
                case LONG: {
                    return "java.lang.Long";
                }
                case BOOLEAN: {
                    return "java.lang.Boolean";
                }
                case BYTE: {
                    return "java.lang.Byte";
                }
                case SHORT: {
                    return "java.lang.Short";
                }
                case CHAR: {
                    return "java.lang.Char";
                }
                case FLOAT: {
                    return "java.lang.Float";
                }
                case DOUBLE: {
                    return "java.lang.Double";
                }
                case DECLARED: {
                    return ((Object)mirror).toString();
                }
                case TYPEVAR: {
                    return ((Object)mirror).toString();
                }
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to determine type for property " + propertyName + " of class " + this.getQualifiedName() + " using assess type " + this.accessTypeInfo.getDefaultAccessType());
        return null;
    }

    private void parseAttributes(Attributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        for (Id id : attributes.getId()) {
            ElementKind elementKind = this.getElementKind(id.getAccess());
            String type = this.getType(id.getName(), null, elementKind);
            if (type == null) continue;
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, id.getName(), type);
            this.members.add(attribute);
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> i$ = attributes.getManyToMany().iterator();
        while (i$.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)i$.next())) {
        }
        i$ = attributes.getOneToMany().iterator();
        while (i$.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)i$.next())) {
        }
        i$ = attributes.getElementCollection().iterator();
        while (i$.hasNext() && !this.parseElementCollection(collection = (ElementCollection)i$.next())) {
        }
    }

    private void parseEmbeddableAttributes(EmbeddableAttributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        if (attributes == null) {
            return;
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> i$ = attributes.getManyToMany().iterator();
        while (i$.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)i$.next())) {
        }
        i$ = attributes.getOneToMany().iterator();
        while (i$.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)i$.next())) {
        }
        i$ = attributes.getElementCollection().iterator();
        while (i$.hasNext() && !this.parseElementCollection(collection = (ElementCollection)i$.next())) {
        }
    }

    private boolean parseElementCollection(ElementCollection collection) {
        String[] types;
        ElementKind elementKind = this.getElementKind(collection.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(collection.getTargetClass());
        String explicitMapKey = this.determineExplicitMapKeyClass(collection.getMapKeyClass());
        try {
            types = this.getCollectionTypes(collection.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(collection.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, collection.getName(), types[0], types[1]) : new XmlMetaMap(this, collection.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private String determineExplicitTargetEntity(String targetClass) {
        String explicitTargetClass = targetClass;
        if (explicitTargetClass != null) {
            explicitTargetClass = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, targetClass);
        }
        return explicitTargetClass;
    }

    private String determineExplicitMapKeyClass(MapKeyClass mapKeyClass) {
        String explicitMapKey = null;
        if (mapKeyClass != null) {
            explicitMapKey = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, mapKeyClass.getClazz());
        }
        return explicitMapKey;
    }

    private boolean parseOneToMany(OneToMany oneToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(oneToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(oneToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(oneToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(oneToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(oneToMany.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, oneToMany.getName(), types[0], types[1]) : new XmlMetaMap(this, oneToMany.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private boolean parseManyToMany(ManyToMany manyToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(manyToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(manyToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(manyToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(manyToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(manyToMany.getName(), e);
            return true;
        }
        if (types != null) {
            XmlMetaCollection metaCollection = types[2] == null ? new XmlMetaCollection(this, manyToMany.getName(), types[0], types[1]) : new XmlMetaMap(this, manyToMany.getName(), types[0], types[1], types[2]);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseOneToOne(OneToOne oneToOne) {
        ElementKind elementKind = this.getElementKind(oneToOne.getAccess());
        String type = this.getType(oneToOne.getName(), oneToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseManyToOne(ManyToOne manyToOne) {
        ElementKind elementKind = this.getElementKind(manyToOne.getAccess());
        String type = this.getType(manyToOne.getName(), manyToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseBasic(Basic basic) {
        ElementKind elementKind = this.getElementKind(basic.getAccess());
        String type = this.getType(basic.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, basic.getName(), type);
            this.members.add(attribute);
        }
    }

    private void logMetaModelException(String name, MetaModelGenerationException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error processing xml for ");
        builder.append(this.clazzName);
        builder.append(".");
        builder.append(name);
        builder.append(". Error message: ");
        builder.append(e.getMessage());
        this.context.logMessage(Diagnostic.Kind.WARNING, builder.toString());
    }

    private ElementKind getElementKind(AccessType accessType) {
        if (accessType == null) {
            return TypeUtils.getElementKindForAccessType(this.accessTypeInfo.getDefaultAccessType());
        }
        if (AccessType.FIELD.equals((Object)accessType)) {
            return ElementKind.FIELD;
        }
        return ElementKind.METHOD;
    }

    static {
        COLLECTIONS.put("java.util.Collection", "javax.persistence.metamodel.CollectionAttribute");
        COLLECTIONS.put("java.util.Set", "javax.persistence.metamodel.SetAttribute");
        COLLECTIONS.put("java.util.List", "javax.persistence.metamodel.ListAttribute");
        COLLECTIONS.put("java.util.Map", "javax.persistence.metamodel.MapAttribute");
    }
}

