/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.jboss.logging.Logger;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    public static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)EntityManagerImpl.class.getName());
    protected Session session;
    protected boolean open = true;
    protected boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Map properties) {
        super(entityManagerFactory, pcType, transactionType, properties);
        this.discardOnClose = discardOnClose;
        Object localSessionInterceptor = null;
        if (properties != null) {
            localSessionInterceptor = properties.get("hibernate.ejb.interceptor.session_scoped");
        }
        if (localSessionInterceptor != null) {
            if (localSessionInterceptor instanceof Class) {
                sessionInterceptorClass = localSessionInterceptor;
            } else if (localSessionInterceptor instanceof String) {
                try {
                    sessionInterceptorClass = ReflectHelper.classForName((String)localSessionInterceptor, EntityManagerImpl.class);
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor, (Throwable)e);
                }
            } else {
                throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor);
            }
        }
        this.sessionInterceptorClass = sessionInterceptorClass;
        this.postInit();
    }

    @Override
    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        return this.getRawSession();
    }

    @Override
    protected Session getRawSession() {
        if (this.session == null) {
            SessionBuilder sessionBuilder = this.getEntityManagerFactory().getSessionFactory().withOptions();
            if (this.sessionInterceptorClass != null) {
                try {
                    Interceptor interceptor = (Interceptor)this.sessionInterceptorClass.newInstance();
                    sessionBuilder.interceptor(interceptor);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Session interceptor does not implement Interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
            }
            sessionBuilder.autoJoinTransactions(this.getTransactionType() != PersistenceUnitTransactionType.JTA);
            this.session = sessionBuilder.openSession();
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)this.session).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (!this.discardOnClose && this.isTransactionInProgress()) {
            this.getSession().getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int i) {
                    if (EntityManagerImpl.this.session != null) {
                        if (EntityManagerImpl.this.session.isOpen()) {
                            LOG.debugf("Closing entity manager after transaction completion", new Object[0]);
                            EntityManagerImpl.this.session.close();
                        } else {
                            LOG.entityManagerClosedBySomeoneElse("hibernate.transaction.auto_close_session");
                        }
                    }
                }
            });
        } else if (this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        try {
            if (this.open) {
                this.getSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }
}

