/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.AbstractGrailsMojo;

public class GrailsInstallPluginMojo
extends AbstractGrailsMojo {
    private String pluginName;
    private String pluginUrl;
    private String pluginVersion;
    private String pluginGroupId;
    private String pluginArtifactId;
    private boolean installGlobally;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String args = "";
        if (this.pluginUrl != null) {
            args = this.pluginUrl;
        } else if (this.pluginName != null) {
            args = this.pluginName;
            if (this.pluginVersion != null) {
                args = args + ' ' + this.pluginVersion;
            }
        } else if (this.pluginGroupId != null && this.pluginArtifactId != null && this.pluginVersion != null) {
            args = this.resolveGrailsPluginViaMavenCoordinates();
        } else {
            throw new MojoFailureException("Neither 'pluginName' nor 'pluginUrl' nor 'pluginGroupId'+'pluginArtifactId'+'pluginVersion' have been specified.");
        }
        if (this.installGlobally) {
            args = args + " --global";
        }
        this.runGrails("InstallPlugin", args, true);
    }

    private String resolveGrailsPluginViaMavenCoordinates() throws MojoFailureException {
        String localPathToPlugin = null;
        try {
            Set artifacts = this.project.getDependencyArtifacts();
            Iterator artifactIterator = artifacts.iterator();
            while (artifactIterator.hasNext()) {
                Artifact artifact = (Artifact)artifactIterator.next();
                if (!artifact.getGroupId().equals(this.pluginGroupId) || !artifact.getArtifactId().equals(this.pluginArtifactId) || !artifact.getVersion().equals(this.pluginVersion) || !(localPathToPlugin = artifact.getFile().toURI().toURL().toString()).startsWith("file:")) continue;
                localPathToPlugin = localPathToPlugin.substring(5);
                this.getLog().debug((CharSequence)("Resolved to plugin to: " + localPathToPlugin));
            }
        }
        catch (MalformedURLException mue) {
            throw new MojoFailureException("Caught MalformedURLException: " + mue.toString());
        }
        if (localPathToPlugin == null) {
            throw new MojoFailureException("Unable to resolve grails plugin via maven coordinates: " + this.pluginGroupId + ":" + this.pluginArtifactId + ":" + this.pluginVersion + " - is it declared as a dependency of the project?");
        }
        return localPathToPlugin;
    }
}

