/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.exception;

import java.sql.SQLException;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.ExceptionUtils;

public class FlywayMigrateException
extends FlywayException {
    private final MigrationInfo migration;
    private final boolean executableInTransaction;
    private final boolean outOfOrder;
    private final MigrateErrorResult errorResult;
    private int lineNumber;
    private String absolutePathOnDisk;

    public ErrorCode getMigrationErrorCode() {
        if (this.migration.getVersion() != null) {
            if (this.migration.getType().isBaseline()) {
                return CoreErrorCode.FAILED_BASELINE_MIGRATION;
            }
            return CoreErrorCode.FAILED_VERSIONED_MIGRATION;
        }
        return CoreErrorCode.FAILED_REPEATABLE_MIGRATION;
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, SQLException e, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(ExceptionUtils.toMessage(e), e);
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
        this.lineNumber = -1;
        this.absolutePathOnDisk = null;
    }

    public FlywayMigrateException(MigrationInfo migration, String message, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(message);
        this.outOfOrder = false;
        this.migration = migration;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
        this.lineNumber = -1;
        this.absolutePathOnDisk = null;
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, FlywayException e, boolean canExecuteInTransaction, MigrateResult partialResult) {
        super(e.getMessage(), e);
        this.setSqlDetails(e);
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
    }

    public FlywayMigrateException(MigrationInfo migration, boolean outOfOrder, String message, FlywayException e, boolean canExecuteInTransaction, MigrateResult partialResult, SqlStatement sqlStatement) {
        super(message, e.getCause());
        this.setSqlDetails(migration, sqlStatement);
        this.migration = migration;
        this.outOfOrder = outOfOrder;
        this.executableInTransaction = canExecuteInTransaction;
        this.errorResult = new MigrateErrorResult(partialResult, this);
    }

    private void setSqlDetails(MigrationInfo migration, SqlStatement sqlStatement) {
        this.lineNumber = sqlStatement.getLineNumber();
        this.absolutePathOnDisk = migration.getScript();
    }

    private void setSqlDetails(FlywayException e) {
        if (e instanceof FlywaySqlScriptException) {
            FlywaySqlScriptException flywaySqlScriptException = (FlywaySqlScriptException)e;
            this.lineNumber = flywaySqlScriptException.getLineNumber();
            this.absolutePathOnDisk = flywaySqlScriptException.getResource().getAbsolutePathOnDisk();
        } else {
            this.lineNumber = -1;
            this.absolutePathOnDisk = null;
        }
    }

    public MigrationInfo getMigration() {
        return this.migration;
    }

    public boolean isExecutableInTransaction() {
        return this.executableInTransaction;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public MigrateErrorResult getErrorResult() {
        return this.errorResult;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getAbsolutePathOnDisk() {
        return this.absolutePathOnDisk;
    }
}

