/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DefaultExecutionStrategy;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.jdbc.TransactionalExecutionTemplate;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.ParserSqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public abstract class BaseDatabaseType
implements DatabaseType {
    private static final Log LOG = LogFactory.getLog(BaseDatabaseType.class);
    private static final Pattern defaultJdbcCredentialsPattern = Pattern.compile("password=([^;&]*).*", 2);
    private static final Pattern hostJdbcCredentialsPattern = Pattern.compile("(?:jdbc:)?[^:]+://[^:]+:([^@]+)@.*", 2);
    protected static final String APPLICATION_NAME = "Flyway by Redgate";

    @Override
    public abstract String getName();

    @Override
    public List<String> getSupportedEngines() {
        return List.of(this.getName().replaceAll("\\s", ""));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public abstract int getNullType();

    @Override
    public boolean supportsReadOnlyTransactions() {
        return true;
    }

    @Override
    public abstract boolean handlesJDBCUrl(String var1);

    @Override
    public Pattern getJDBCCredentialsPattern() {
        return defaultJdbcCredentialsPattern;
    }

    @Override
    public List<Pattern> getJDBCCredentialsPatterns() {
        return List.of(this.getJDBCCredentialsPattern(), hostJdbcCredentialsPattern);
    }

    public static Pattern getDefaultJDBCCredentialsPattern() {
        return defaultJdbcCredentialsPattern;
    }

    @Override
    public abstract String getDriverClass(String var1, ClassLoader var2);

    @Override
    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        return null;
    }

    @Override
    public abstract boolean handlesDatabaseProductNameAndVersion(String var1, String var2, Connection var3);

    @Override
    public abstract Database createDatabase(Configuration var1, JdbcConnectionFactory var2, StatementInterceptor var3);

    @Override
    public abstract Parser createParser(Configuration var1, ResourceProvider var2, ParsingContext var3);

    @Override
    public SqlScriptFactory createSqlScriptFactory(Configuration configuration, ParsingContext parsingContext) {
        return (resource, mixed, resourceProvider) -> new ParserSqlScript(this.createParser(configuration, resourceProvider, parsingContext), resource, SqlScriptMetadata.getMetadataResource(resourceProvider, resource), mixed);
    }

    @Override
    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
        BaseDatabaseType thisRef = this;
        return (connection, undo, batch, outputQueryResults) -> new DefaultSqlScriptExecutor(new JdbcTemplate(connection, thisRef), callbackExecutor, undo, jdbcConnectionFactory.isSupportsBatch() && batch, outputQueryResults, statementInterceptor);
    }

    @Override
    public DatabaseExecutionStrategy createExecutionStrategy(Connection connection) {
        return new DefaultExecutionStrategy();
    }

    @Override
    public ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        return new TransactionalExecutionTemplate(connection, rollbackOnException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectVersionOutput(Connection connection) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        String result = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    @Override
    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
    }

    @Override
    public void setConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
    }

    @Override
    public void setOverridingConnectionProps(Map<String, String> props) {
    }

    @Override
    public void shutdownDatabase(String url, Driver driver) {
    }

    @Override
    public boolean detectUserRequiredByUrl(String url) {
        return true;
    }

    @Override
    public boolean detectPasswordRequiredByUrl(String url) {
        return true;
    }

    @Override
    public boolean externalAuthPropertiesRequired(String url, String username, String password) {
        return false;
    }

    @Override
    public Properties getExternalAuthProperties(String url, String username) {
        return new Properties();
    }

    @Override
    public Connection alterConnectionAsNeeded(Connection connection, Configuration configuration) {
        return connection;
    }

    @Override
    public String instantiateClassExtendedErrorMessage() {
        return "";
    }
}

