/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.annotation.AjaxElement;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.exception.ConstructionException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentAdapter
extends Fluent {
    public FluentAdapter(WebDriver webDriver) {
        super(webDriver);
    }

    public FluentAdapter() {
    }

    @Override
    protected void initTest() {
        Class cls = null;
        try {
            this.injectPageIntoContainer(this);
            this.initFluentWebElements(this);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
    }

    private void injectPageIntoContainer(Fluent container) throws ClassNotFoundException, IllegalAccessException {
        Class<?> cls = container.getClass();
        while (FluentAdapter.class.isAssignableFrom(cls) || FluentPage.class.isAssignableFrom(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Page.class)) continue;
                field.setAccessible(true);
                Class<?> clsField = field.getType();
                Class<?> clsPage = Class.forName(clsField.getName());
                Object page = this.initClass(clsPage);
                field.set(container, page);
                this.injectPageIntoContainer((Fluent)page);
            }
            cls = cls.getSuperclass();
        }
    }

    @Override
    public <T extends FluentPage> T createPage(Class<T> cls) {
        T container = this.initClass(cls);
        try {
            this.injectPageIntoContainer((Fluent)container);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        return container;
    }

    @Override
    protected <T extends FluentPage> T initClass(Class<T> cls) {
        FluentPage page = null;
        try {
            Constructor<T> construct = cls.getDeclaredConstructor(new Class[0]);
            construct.setAccessible(true);
            page = (FluentPage)construct.newInstance(new Object[0]);
            Class<?> parent = Class.forName(Fluent.class.getName());
            this.initDriver(page, parent);
            this.initBaseUrl(page, parent);
            this.initFluentWebElements(page);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("No constructor found on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InstantiationException e) {
            throw new ConstructionException("Unable to instantiate " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InvocationTargetException e) {
            throw new ConstructionException("Cannot invoke method setDriver on " + (cls != null ? cls.getName() : " null"), e);
        }
        return (T)page;
    }

    private <T extends Fluent> void initFluentWebElements(T page) {
        Class<?> classz = page.getClass();
        while (FluentAdapter.class.isAssignableFrom(classz) || FluentPage.class.isAssignableFrom(classz)) {
            for (Field fieldFromPage : classz.getDeclaredFields()) {
                if (!this.isFluentWebElementField(fieldFromPage)) continue;
                fieldFromPage.setAccessible(true);
                AjaxElement elem = fieldFromPage.getAnnotation(AjaxElement.class);
                if (elem == null) {
                    FluentAdapter.proxyElement((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.getDriver()), page, fieldFromPage);
                    continue;
                }
                FluentAdapter.proxyElement((ElementLocatorFactory)new AjaxElementLocatorFactory((SearchContext)this.getDriver(), elem.timeOutInSeconds()), page, fieldFromPage);
            }
            classz = classz.getSuperclass();
        }
    }

    private boolean isFluentWebElementField(Field field) {
        return FluentWebElement.class.isAssignableFrom(field.getType());
    }

    private <T extends FluentPage> void initBaseUrl(T page, Class parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.getBaseUrl() != null) {
            Method m = parent.getDeclaredMethod("withDefaultUrl", String.class);
            m.setAccessible(true);
            m.invoke(page, this.getBaseUrl());
        }
    }

    private <T extends FluentPage> void initDriver(T page, Class parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = parent.getDeclaredMethod("initFluent", WebDriver.class);
        m.setAccessible(true);
        m.invoke(page, this.getDriver());
    }

    private static void proxyElement(ElementLocatorFactory factory, Object page, Field field) {
        ElementLocator locator = factory.createLocator(field);
        if (locator == null) {
            return;
        }
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class}, (InvocationHandler)handler);
        try {
            field.setAccessible(true);
            field.set(page, new FluentWebElement(proxy));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public WebDriver getDefaultDriver() {
        return new FirefoxDriver();
    }

    public String getDefaultBaseUrl() {
        return null;
    }

    public void getDefaultConfig() {
    }

    public static void assertAt(FluentPage fluent) {
        fluent.isAt();
    }

    public void quit() {
        if (this.getDriver() != null) {
            this.getDriver().quit();
        }
    }
}

