/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.fluentlenium.core.FluentAdapter;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.action.FillConstructor;
import org.fluentlenium.core.action.FillSelectConstructor;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.annotation.AjaxElement;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.exception.ConstructionException;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Fluent
implements SearchActions {
    private WebDriver driver;
    private String baseUrl;
    private Search search;

    public Fluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        FluentThread.set(this);
    }

    public Fluent withDefaultUrl(String baseUrl) {
        if (baseUrl != null) {
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            this.baseUrl = baseUrl;
        }
        return this;
    }

    public Fluent withDefaultPageWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().pageLoadTimeout(l, timeUnit);
        return this;
    }

    public Fluent withDefaultSearchWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().implicitlyWait(l, timeUnit);
        return this;
    }

    public Fluent() {
        FluentThread.set(this);
    }

    public Fluent takeScreenShot() {
        this.takeScreenShot(new Date().getTime() + ".png");
        return this;
    }

    public Fluent takeScreenShot(String fileName) {
        if (!(this.getDriver() instanceof TakesScreenshot)) {
            throw new WebDriverException("Current browser doesn't allow taking screenshot.");
        }
        File scrFile = (File)((TakesScreenshot)this.getDriver()).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when taking the snapshot", e);
        }
        return this;
    }

    protected Fluent initFluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        return this;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected void initTest() {
        Class<?> cls = null;
        try {
            cls = Class.forName(this.getClass().getName());
            while (FluentAdapter.class.isAssignableFrom(cls)) {
                for (Field field : cls.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Page.class)) continue;
                    field.setAccessible(true);
                    Class<?> clsField = field.getType();
                    Class<?> clsPage = Class.forName(clsField.getName());
                    Object page = this.initClass(clsPage);
                    field.set(this, page);
                }
                cls = cls.getSuperclass();
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
    }

    public <T extends FluentPage> T createPage(Class<T> classOfPage) {
        return this.initClass(classOfPage);
    }

    protected <T extends FluentPage> T initClass(Class<T> cls) {
        FluentPage page = null;
        try {
            Field[] fields;
            Constructor<T> construct = cls.getDeclaredConstructor(new Class[0]);
            construct.setAccessible(true);
            page = (FluentPage)construct.newInstance(new Object[0]);
            Class<?> parent = Class.forName(Fluent.class.getName());
            this.initDriver(page, parent);
            this.initBaseUrl(page, parent);
            for (Field fieldFromPage : fields = cls.getDeclaredFields()) {
                if (!FluentWebElement.class.isAssignableFrom(fieldFromPage.getType())) continue;
                fieldFromPage.setAccessible(true);
                AjaxElement elem = fieldFromPage.getAnnotation(AjaxElement.class);
                if (elem == null) {
                    Fluent.proxyElement((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.getDriver()), page, fieldFromPage);
                    continue;
                }
                Fluent.proxyElement((ElementLocatorFactory)new AjaxElementLocatorFactory((SearchContext)this.getDriver(), elem.timeOutInSeconds()), page, fieldFromPage);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("No constructor found on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InstantiationException e) {
            throw new ConstructionException("Unable to instantiate " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InvocationTargetException e) {
            throw new ConstructionException("Cannot invoke method setDriver on " + (cls != null ? cls.getName() : " null"), e);
        }
        return (T)page;
    }

    private <T extends FluentPage> void initBaseUrl(T page, Class parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.getBaseUrl() != null) {
            Method m = parent.getDeclaredMethod("withDefaultUrl", String.class);
            m.setAccessible(true);
            m.invoke(page, this.getBaseUrl());
        }
    }

    private <T extends FluentPage> void initDriver(T page, Class parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = parent.getDeclaredMethod("initFluent", WebDriver.class);
        m.setAccessible(true);
        m.invoke(page, this.getDriver());
    }

    private static void proxyElement(ElementLocatorFactory factory, Object page, Field field) {
        ElementLocator locator = factory.createLocator(field);
        if (locator == null) {
            return;
        }
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class}, (InvocationHandler)handler);
        try {
            field.setAccessible(true);
            field.set(page, new FluentWebElement(proxy));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public FluentWait await() {
        return new FluentWait(this.driver, this.search);
    }

    public String title() {
        return this.driver.getTitle();
    }

    public Set<Cookie> getCookies() {
        return this.driver.manage().getCookies();
    }

    public Cookie getCookie(String name) {
        return this.driver.manage().getCookieNamed(name);
    }

    public String url() {
        String currentUrl = this.driver.getCurrentUrl();
        if (currentUrl != null && this.baseUrl != null && currentUrl.startsWith(this.baseUrl)) {
            currentUrl = currentUrl.substring(this.baseUrl.length());
        }
        return currentUrl;
    }

    public String pageSource() {
        return this.driver.getPageSource();
    }

    public <P extends FluentPage> P goTo(P page) {
        if (page == null) {
            throw new IllegalArgumentException("Page is mandatory");
        }
        page.go();
        return page;
    }

    public Fluent goTo(String url) {
        URI uri;
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        if (this.baseUrl != null && !(uri = URI.create(url)).isAbsolute()) {
            url = this.baseUrl + url;
        }
        this.getDriver().get(url);
        return this;
    }

    public Fluent executeScript(String script) {
        ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
        return this;
    }

    public FluentList<FluentWebElement> $(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    public FluentWebElement $(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.search.findFirst(name, filters);
    }

    public FillConstructor fill(String cssSelector, Filter ... filters) {
        return new FillConstructor(cssSelector, this.getDriver(), filters);
    }

    public FillConstructor fill(FluentDefaultActions list, Filter ... filters) {
        return new FillConstructor(list, this.getDriver(), filters);
    }

    public FillSelectConstructor fillSelect(String cssSelector, Filter ... filters) {
        return new FillSelectConstructor(cssSelector, this.getDriver(), filters);
    }

    public Fluent click(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).click();
        return this;
    }

    public Fluent clear(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).clear();
        return this;
    }

    public Fluent submit(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).submit();
        return this;
    }

    public List<String> text(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getTexts();
    }

    public List<String> value(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getValues();
    }

    public Fluent click(FluentDefaultActions fluentObject) {
        fluentObject.click();
        return this;
    }

    public Fluent clear(FluentList<FluentWebElement> fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent clear(FluentWebElement fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent submit(FluentDefaultActions fluentObject) {
        fluentObject.submit();
        return this;
    }

    public Fluent switchTo(FluentWebElement element) {
        if (null == element || null == element.getTagName() || null == element.getId() || !"iframe".equals(element.getTagName())) {
            this.driver.switchTo().defaultContent();
        } else {
            this.driver.switchTo().frame(element.getId());
        }
        return this;
    }

    public Fluent switchTo() {
        this.switchTo(null);
        return this;
    }

    public Fluent switchToDefault() {
        this.switchTo(null);
        return this;
    }
}

